/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerFragment;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerChecker {
    private static final Logger LOG = LoggerFactory.getLogger(LedgerChecker.class);
    public final BookieClient bookieClient;

    public LedgerChecker(BookKeeper bkc) {
        this.bookieClient = bkc.getBookieClient();
    }

    private void verifyLedgerFragment(LedgerFragment fragment, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb) throws InvalidFragmentException, BKException {
        Set<Integer> bookiesToCheck = fragment.getBookiesIndexes();
        if (bookiesToCheck.isEmpty()) {
            cb.operationComplete(0, fragment);
            return;
        }
        AtomicInteger numBookies = new AtomicInteger(bookiesToCheck.size());
        HashMap<Integer, Integer> badBookies = new HashMap<Integer, Integer>();
        for (Integer bookieIndex : bookiesToCheck) {
            LedgerFragmentCallback lfCb = new LedgerFragmentCallback(fragment, bookieIndex, cb, badBookies, numBookies);
            this.verifyLedgerFragment(fragment, bookieIndex, lfCb);
        }
    }

    private void verifyLedgerFragment(LedgerFragment fragment, int bookieIndex, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb) throws InvalidFragmentException {
        long firstStored = fragment.getFirstStoredEntryId(bookieIndex);
        long lastStored = fragment.getLastStoredEntryId(bookieIndex);
        BookieSocketAddress bookie = fragment.getAddress(bookieIndex);
        if (null == bookie) {
            throw new InvalidFragmentException();
        }
        if (firstStored == -1L) {
            if (lastStored != -1L) {
                throw new InvalidFragmentException();
            }
            cb.operationComplete(0, fragment);
        } else if (firstStored == lastStored) {
            ReadManyEntriesCallback manycb = new ReadManyEntriesCallback(1L, fragment, cb);
            this.bookieClient.readEntry(bookie, fragment.getLedgerId(), firstStored, manycb, null);
        } else {
            ReadManyEntriesCallback manycb = new ReadManyEntriesCallback(2L, fragment, cb);
            this.bookieClient.readEntry(bookie, fragment.getLedgerId(), firstStored, manycb, null);
            this.bookieClient.readEntry(bookie, fragment.getLedgerId(), lastStored, manycb, null);
        }
    }

    public void checkLedger(LedgerHandle lh, final BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb) {
        int i;
        HashSet<Integer> bookieIndexes;
        final HashSet<LedgerFragment> fragments = new HashSet<LedgerFragment>();
        Long curEntryId = null;
        ArrayList<BookieSocketAddress> curEnsemble = null;
        for (Map.Entry<Long, ArrayList<BookieSocketAddress>> e : lh.getLedgerMetadata().getEnsembles().entrySet()) {
            if (curEntryId != null) {
                bookieIndexes = new HashSet<Integer>();
                for (i = 0; i < curEnsemble.size(); ++i) {
                    bookieIndexes.add(i);
                }
                fragments.add(new LedgerFragment(lh, curEntryId, e.getKey() - 1L, bookieIndexes));
            }
            curEntryId = e.getKey();
            curEnsemble = e.getValue();
        }
        if (curEntryId != null) {
            long lastEntry = lh.getLastAddConfirmed();
            if (!lh.isClosed() && lastEntry < curEntryId) {
                lastEntry = curEntryId;
            }
            bookieIndexes = new HashSet();
            for (i = 0; i < curEnsemble.size(); ++i) {
                bookieIndexes.add(i);
            }
            final LedgerFragment lastLedgerFragment = new LedgerFragment(lh, curEntryId, lastEntry, bookieIndexes);
            if (curEntryId == lastEntry) {
                long entryToRead = curEntryId;
                EntryExistsCallback eecb = new EntryExistsCallback(lh.getLedgerMetadata().getWriteQuorumSize(), new BookkeeperInternalCallbacks.GenericCallback<Boolean>(){

                    @Override
                    public void operationComplete(int rc, Boolean result) {
                        if (result.booleanValue()) {
                            fragments.add(lastLedgerFragment);
                        }
                        LedgerChecker.this.checkFragments(fragments, cb);
                    }
                });
                DistributionSchedule.WriteSet writeSet = lh.getDistributionSchedule().getWriteSet(entryToRead);
                for (int i2 = 0; i2 < writeSet.size(); ++i2) {
                    BookieSocketAddress addr = curEnsemble.get(writeSet.get(i2));
                    this.bookieClient.readEntry(addr, lh.getId(), entryToRead, eecb, null);
                }
                writeSet.recycle();
                return;
            }
            fragments.add(lastLedgerFragment);
        }
        this.checkFragments(fragments, cb);
    }

    private void checkFragments(Set<LedgerFragment> fragments, BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb) {
        if (fragments.size() == 0) {
            cb.operationComplete(0, fragments);
            return;
        }
        FullLedgerCallback allFragmentsCb = new FullLedgerCallback(fragments.size(), cb);
        for (LedgerFragment r : fragments) {
            LOG.debug("Checking fragment {}", (Object)r);
            try {
                this.verifyLedgerFragment(r, allFragmentsCb);
            }
            catch (InvalidFragmentException ife) {
                LOG.error("Invalid fragment found : {}", (Object)r);
                allFragmentsCb.operationComplete(-14, r);
            }
            catch (BKException e) {
                LOG.error("BKException when checking fragment : {}", (Object)r, (Object)e);
            }
        }
    }

    private static class FullLedgerCallback
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> {
        final Set<LedgerFragment> badFragments = new HashSet<LedgerFragment>();
        final AtomicLong numFragments;
        final BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb;

        FullLedgerCallback(long numFragments, BookkeeperInternalCallbacks.GenericCallback<Set<LedgerFragment>> cb) {
            this.numFragments = new AtomicLong(numFragments);
            this.cb = cb;
        }

        @Override
        public void operationComplete(int rc, LedgerFragment result) {
            if (rc == -19) {
                this.cb.operationComplete(-19, this.badFragments);
                return;
            }
            if (rc != 0) {
                this.badFragments.add(result);
            }
            if (this.numFragments.decrementAndGet() == 0L) {
                this.cb.operationComplete(0, this.badFragments);
            }
        }
    }

    private static class EntryExistsCallback
    implements BookkeeperInternalCallbacks.ReadEntryCallback {
        AtomicBoolean entryMayExist = new AtomicBoolean(false);
        final AtomicInteger numReads;
        final BookkeeperInternalCallbacks.GenericCallback<Boolean> cb;

        EntryExistsCallback(int numReads, BookkeeperInternalCallbacks.GenericCallback<Boolean> cb) {
            this.numReads = new AtomicInteger(numReads);
            this.cb = cb;
        }

        @Override
        public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
            if (-13 != rc && -7 != rc) {
                this.entryMayExist.set(true);
            }
            if (this.numReads.decrementAndGet() == 0) {
                this.cb.operationComplete(rc, this.entryMayExist.get());
            }
        }
    }

    private static class LedgerFragmentCallback
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> {
        private final LedgerFragment fragment;
        private final int bookieIndex;
        private final Map<Integer, Integer> badBookies;
        private final AtomicInteger numBookies;
        private final BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb;

        LedgerFragmentCallback(LedgerFragment lf, int bookieIndex, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb, Map<Integer, Integer> badBookies, AtomicInteger numBookies) {
            this.fragment = lf;
            this.bookieIndex = bookieIndex;
            this.cb = cb;
            this.badBookies = badBookies;
            this.numBookies = numBookies;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void operationComplete(int rc, LedgerFragment lf) {
            if (0 != rc) {
                Map<Integer, Integer> map = this.badBookies;
                synchronized (map) {
                    this.badBookies.put(this.bookieIndex, rc);
                }
            }
            if (this.numBookies.decrementAndGet() == 0) {
                if (this.badBookies.isEmpty()) {
                    this.cb.operationComplete(0, this.fragment);
                } else {
                    int rcToReturn = -3;
                    for (Map.Entry<Integer, Integer> entry : this.badBookies.entrySet()) {
                        rcToReturn = entry.getValue();
                        if (entry.getValue() != -19) continue;
                        break;
                    }
                    this.cb.operationComplete(rcToReturn, this.fragment.subset(this.badBookies.keySet()));
                }
            }
        }
    }

    private static class ReadManyEntriesCallback
    implements BookkeeperInternalCallbacks.ReadEntryCallback {
        AtomicBoolean completed = new AtomicBoolean(false);
        final AtomicLong numEntries;
        final LedgerFragment fragment;
        final BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb;

        ReadManyEntriesCallback(long numEntries, LedgerFragment fragment, BookkeeperInternalCallbacks.GenericCallback<LedgerFragment> cb) {
            this.numEntries = new AtomicLong(numEntries);
            this.fragment = fragment;
            this.cb = cb;
        }

        @Override
        public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
            if (rc == 0) {
                if (this.numEntries.decrementAndGet() == 0L && !this.completed.getAndSet(true)) {
                    this.cb.operationComplete(rc, this.fragment);
                }
            } else if (!this.completed.getAndSet(true)) {
                this.cb.operationComplete(rc, this.fragment);
            }
        }
    }

    static class InvalidFragmentException
    extends Exception {
        private static final long serialVersionUID = 1467201276417062353L;

        InvalidFragmentException() {
        }
    }
}

