/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.client.api.DeleteBuilder;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bookkeeper.versioning.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerDeleteOp
extends OrderedSafeExecutor.OrderedSafeGenericCallback<Void> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerDeleteOp.class);
    final BookKeeper bk;
    final long ledgerId;
    final AsyncCallback.DeleteCallback cb;
    final Object ctx;
    final long startTime;
    final OpStatsLogger deleteOpLogger;

    LedgerDeleteOp(BookKeeper bk, long ledgerId, AsyncCallback.DeleteCallback cb, Object ctx) {
        super(bk.getMainWorkerPool(), ledgerId);
        this.bk = bk;
        this.ledgerId = ledgerId;
        this.cb = cb;
        this.ctx = ctx;
        this.startTime = MathUtils.nowInNano();
        this.deleteOpLogger = bk.getDeleteOpLogger();
    }

    public void initiate() {
        this.bk.getLedgerManager().removeLedgerMetadata(this.ledgerId, Version.ANY, this);
    }

    @Override
    public void safeOperationComplete(int rc, Void result) {
        if (0 != rc) {
            this.deleteOpLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.startTime), TimeUnit.NANOSECONDS);
        } else {
            this.deleteOpLogger.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.startTime), TimeUnit.NANOSECONDS);
        }
        this.cb.deleteComplete(rc, this.ctx);
    }

    public String toString() {
        return String.format("LedgerDeleteOp(%d)", this.ledgerId);
    }

    static class DeleteBuilderImpl
    implements DeleteBuilder {
        private Long builderLedgerId;
        private final BookKeeper bk;

        DeleteBuilderImpl(BookKeeper bk) {
            this.bk = bk;
        }

        @Override
        public DeleteBuilder withLedgerId(long ledgerId) {
            this.builderLedgerId = ledgerId;
            return this;
        }

        @Override
        public CompletableFuture<Void> execute() {
            CompletableFuture<Void> future = new CompletableFuture<Void>();
            SyncCallbackUtils.SyncDeleteCallback result = new SyncCallbackUtils.SyncDeleteCallback(future);
            this.delete(this.builderLedgerId, result);
            return future;
        }

        private boolean validate() {
            if (this.builderLedgerId == null || this.builderLedgerId < 0L) {
                LOG.error("invalid ledgerId {} < 0", (Object)this.builderLedgerId);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void delete(Long ledgerId, AsyncCallback.DeleteCallback cb) {
            if (!this.validate()) {
                cb.deleteComplete(-14, null);
                return;
            }
            LedgerDeleteOp op = new LedgerDeleteOp(this.bk, ledgerId, cb, null);
            ReentrantReadWriteLock closeLock = this.bk.getCloseLock();
            closeLock.readLock().lock();
            try {
                if (this.bk.isClosed()) {
                    cb.deleteComplete(-19, null);
                    return;
                }
                op.initiate();
            }
            finally {
                closeLock.readLock().unlock();
            }
        }
    }
}

