/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.annotations.VisibleForTesting;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DigestManager;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.ListenerBasedPendingReadOp;
import org.apache.bookkeeper.client.ReadLastConfirmedOp;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerRecoveryOp
implements BookkeeperInternalCallbacks.ReadEntryListener,
AsyncCallback.AddCallback {
    static final Logger LOG = LoggerFactory.getLogger(LedgerRecoveryOp.class);
    final LedgerHandle lh;
    final AtomicLong readCount = new AtomicLong(0L);
    final AtomicLong writeCount = new AtomicLong(0L);
    volatile boolean readDone = false;
    final AtomicBoolean callbackDone = new AtomicBoolean(false);
    volatile long startEntryToRead;
    volatile long endEntryToRead;
    final BookkeeperInternalCallbacks.GenericCallback<Void> cb;
    LedgerMetadata metadataForRecovery;
    boolean parallelRead = false;
    int readBatchSize = 1;
    @VisibleForTesting
    BookkeeperInternalCallbacks.ReadEntryListener entryListener = null;

    public LedgerRecoveryOp(LedgerHandle lh, BookkeeperInternalCallbacks.GenericCallback<Void> cb) {
        this.cb = cb;
        this.lh = lh;
    }

    LedgerRecoveryOp parallelRead(boolean enabled) {
        this.parallelRead = enabled;
        return this;
    }

    LedgerRecoveryOp readBatchSize(int batchSize) {
        this.readBatchSize = batchSize;
        return this;
    }

    @VisibleForTesting
    LedgerRecoveryOp setEntryListener(BookkeeperInternalCallbacks.ReadEntryListener entryListener) {
        this.entryListener = entryListener;
        return this;
    }

    public void initiate() {
        ReadLastConfirmedOp rlcop = new ReadLastConfirmedOp(this.lh, new ReadLastConfirmedOp.LastConfirmedDataCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void readLastConfirmedDataComplete(int rc, DigestManager.RecoveryData data) {
                if (rc == 0) {
                    LedgerHandle ledgerHandle = LedgerRecoveryOp.this.lh;
                    synchronized (ledgerHandle) {
                        LedgerRecoveryOp.this.lh.lastAddPushed = LedgerRecoveryOp.this.lh.lastAddConfirmed = data.lastAddConfirmed;
                        LedgerRecoveryOp.this.lh.length = data.length;
                        LedgerRecoveryOp.this.startEntryToRead = LedgerRecoveryOp.this.endEntryToRead = LedgerRecoveryOp.this.lh.lastAddConfirmed;
                    }
                    LedgerRecoveryOp.this.metadataForRecovery = new LedgerMetadata(LedgerRecoveryOp.this.lh.getLedgerMetadata());
                    LedgerRecoveryOp.this.doRecoveryRead();
                } else if (rc == -102) {
                    LedgerRecoveryOp.this.submitCallback(rc);
                } else {
                    LedgerRecoveryOp.this.submitCallback(-1);
                }
            }
        });
        rlcop.initiateWithFencing();
    }

    private void submitCallback(int rc) {
        if (0 == rc) {
            this.lh.bk.getRecoverAddCountLogger().registerSuccessfulValue(this.writeCount.get());
            this.lh.bk.getRecoverReadCountLogger().registerSuccessfulValue(this.readCount.get());
        } else {
            this.lh.bk.getRecoverAddCountLogger().registerFailedValue(this.writeCount.get());
            this.lh.bk.getRecoverReadCountLogger().registerFailedValue(this.readCount.get());
        }
        this.cb.operationComplete(rc, null);
    }

    private void doRecoveryRead() {
        if (!this.callbackDone.get()) {
            this.startEntryToRead = this.endEntryToRead + 1L;
            this.endEntryToRead += (long)this.readBatchSize;
            new RecoveryReadOp(this.lh, this.lh.bk.getScheduler(), this.startEntryToRead, this.endEntryToRead, this, null).parallelRead(this.parallelRead).initiate();
        }
    }

    private void closeAndCallback() {
        if (this.callbackDone.compareAndSet(false, true)) {
            this.lh.asyncCloseInternal(new AsyncCallback.CloseCallback(){

                @Override
                public void closeComplete(int rc, LedgerHandle lh, Object ctx) {
                    if (rc != 0) {
                        LOG.warn("Close ledger {} failed during recovery: ", (Object)LedgerRecoveryOp.this.lh.getId(), (Object)BKException.getMessage(rc));
                        LedgerRecoveryOp.this.submitCallback(rc);
                    } else {
                        LedgerRecoveryOp.this.submitCallback(0);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("After closing length is: {}", (Object)lh.getLength());
                        }
                    }
                }
            }, null, -11);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onEntryComplete(int rc, LedgerHandle lh, LedgerEntry entry, Object ctx) {
        BookkeeperInternalCallbacks.ReadEntryListener listener = this.entryListener;
        if (null != listener) {
            listener.onEntryComplete(rc, lh, entry, ctx);
        }
        if (!this.callbackDone.get() && !this.readDone && rc == 0) {
            this.readCount.incrementAndGet();
            byte[] data = entry.getEntry();
            LedgerHandle ledgerHandle = lh;
            synchronized (ledgerHandle) {
                lh.length = entry.getLength() - (long)data.length;
                if (entry.getEntryId() != lh.lastAddPushed + 1L) {
                    LOG.error("Unexpected to recovery add entry {} as entry {} for ledger {}.", new Object[]{entry.getEntryId(), lh.lastAddPushed + 1L, lh.getId()});
                    rc = -999;
                }
            }
            if (0 == rc) {
                lh.asyncRecoveryAddEntry(data, 0, data.length, this, null);
                if (entry.getEntryId() == this.endEntryToRead) {
                    this.doRecoveryRead();
                }
                return;
            }
        }
        if (rc == -13 || rc == -7) {
            this.readDone = true;
            if (this.readCount.get() == this.writeCount.get()) {
                this.closeAndCallback();
            }
            return;
        }
        if (0 != rc && this.callbackDone.compareAndSet(false, true)) {
            LOG.error("Failure {} while reading entries: ({} - {}), ledger: {} while recovering ledger", new Object[]{BKException.getMessage(rc), this.startEntryToRead, this.endEntryToRead, lh.getId()});
            this.submitCallback(rc);
        } else if (0 == rc) {
            LOG.warn("Successfully read entry {} for ledger {}, but readDone is already {}", new Object[]{entry.getEntryId(), lh.getId(), this.readDone});
        }
    }

    @Override
    public void addComplete(int rc, LedgerHandle lh, long entryId, Object ctx) {
        if (rc != 0) {
            LOG.error("Failure " + BKException.getMessage(rc) + " while writing entry: " + (entryId + 1L) + " ledger: " + lh.ledgerId + " while recovering ledger");
            if (this.callbackDone.compareAndSet(false, true)) {
                this.submitCallback(rc);
            }
            return;
        }
        long numAdd = this.writeCount.incrementAndGet();
        if (this.readDone && this.readCount.get() == numAdd) {
            this.closeAndCallback();
        }
    }

    class RecoveryReadOp
    extends ListenerBasedPendingReadOp {
        RecoveryReadOp(LedgerHandle lh, ScheduledExecutorService scheduler, long startEntryId, long endEntryId, BookkeeperInternalCallbacks.ReadEntryListener cb, Object ctx) {
            super(lh, scheduler, startEntryId, endEntryId, cb, ctx, true);
        }

        @Override
        protected LedgerMetadata getLedgerMetadata() {
            return LedgerRecoveryOp.this.metadataForRecovery;
        }
    }
}

