/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import io.netty.buffer.ByteBuf;
import io.netty.util.Recycler;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.util.Map;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class PendingAddOp
extends SafeRunnable
implements BookkeeperInternalCallbacks.WriteCallback,
TimerTask {
    private static final Logger LOG = LoggerFactory.getLogger(PendingAddOp.class);
    ByteBuf payload;
    ByteBuf toSend;
    AsyncCallback.AddCallback cb;
    Object ctx;
    long entryId;
    int entryLength;
    DistributionSchedule.AckSet ackSet;
    boolean completed = false;
    LedgerHandle lh;
    boolean isRecoveryAdd = false;
    long requestTimeNanos;
    int timeoutSec;
    Timeout timeout = null;
    OpStatsLogger addOpLogger;
    long currentLedgerLength;
    int pendingWriteRequests;
    boolean callbackTriggered;
    boolean hasRun;
    private final Recycler.Handle<PendingAddOp> recyclerHandle;
    private static final Recycler<PendingAddOp> RECYCLER = new Recycler<PendingAddOp>(){

        protected PendingAddOp newObject(Recycler.Handle<PendingAddOp> handle) {
            return new PendingAddOp(handle);
        }
    };

    static PendingAddOp create(LedgerHandle lh, ByteBuf payload, AsyncCallback.AddCallback cb, Object ctx) {
        PendingAddOp op = (PendingAddOp)RECYCLER.get();
        op.lh = lh;
        op.isRecoveryAdd = false;
        op.cb = cb;
        op.ctx = ctx;
        op.entryId = -1L;
        op.currentLedgerLength = -1L;
        op.payload = payload;
        op.entryLength = payload.readableBytes();
        op.completed = false;
        op.ackSet = lh.distributionSchedule.getAckSet();
        op.addOpLogger = lh.bk.getAddOpLogger();
        if (op.timeout != null) {
            op.timeout.cancel();
        }
        op.timeout = null;
        op.timeoutSec = lh.bk.getConf().getAddEntryQuorumTimeout();
        op.pendingWriteRequests = 0;
        op.callbackTriggered = false;
        op.hasRun = false;
        return op;
    }

    PendingAddOp enableRecoveryAdd() {
        this.isRecoveryAdd = true;
        return this;
    }

    void setEntryId(long entryId) {
        this.entryId = entryId;
    }

    void setLedgerLength(long ledgerLength) {
        this.currentLedgerLength = ledgerLength;
    }

    long getEntryId() {
        return this.entryId;
    }

    void sendWriteRequest(int bookieIndex) {
        int flags = this.isRecoveryAdd ? 2 : 0;
        this.lh.bk.getBookieClient().addEntry(this.lh.metadata.currentEnsemble.get(bookieIndex), this.lh.ledgerId, this.lh.ledgerKey, this.entryId, this.toSend, this, bookieIndex, flags);
        ++this.pendingWriteRequests;
    }

    public void run(Timeout timeout) {
        this.timeoutQuorumWait();
    }

    void timeoutQuorumWait() {
        try {
            this.lh.bk.getMainWorkerPool().submitOrdered(this.lh.ledgerId, new SafeRunnable(){

                public void safeRun() {
                    if (PendingAddOp.this.completed) {
                        return;
                    }
                    PendingAddOp.this.lh.handleUnrecoverableErrorDuringAdd(-21);
                }

                public String toString() {
                    return String.format("AddEntryQuorumTimeout(lid=%d, eid=%d)", PendingAddOp.this.lh.ledgerId, PendingAddOp.this.entryId);
                }
            });
        }
        catch (RejectedExecutionException e) {
            LOG.warn("Timeout add entry quorum wait failed {} entry: {}", (Object)this.lh.ledgerId, (Object)this.entryId);
        }
    }

    void unsetSuccessAndSendWriteRequest(int bookieIndex) {
        if (this.toSend == null) {
            return;
        }
        DistributionSchedule.WriteSet writeSet = this.lh.distributionSchedule.getWriteSet(this.entryId);
        try {
            if (!writeSet.contains(bookieIndex)) {
                this.lh.sendAddSuccessCallbacks();
                return;
            }
        }
        finally {
            writeSet.recycle();
        }
        if (this.callbackTriggered) {
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Unsetting success for ledger: " + this.lh.ledgerId + " entry: " + this.entryId + " bookie index: " + bookieIndex);
        }
        if (!this.ackSet.removeBookieAndCheck(bookieIndex)) {
            this.completed = false;
        }
        this.sendWriteRequest(bookieIndex);
    }

    public void safeRun() {
        this.hasRun = true;
        if (this.callbackTriggered) {
            this.maybeRecycle();
            return;
        }
        if (this.timeoutSec > -1) {
            this.timeout = this.lh.bk.getBookieClient().scheduleTimeout(this, this.timeoutSec, TimeUnit.SECONDS);
        }
        this.requestTimeNanos = MathUtils.nowInNano();
        Preconditions.checkNotNull((Object)this.lh);
        Preconditions.checkNotNull((Object)this.lh.macManager);
        this.toSend = this.lh.macManager.computeDigestAndPackageForSending(this.entryId, this.lh.lastAddConfirmed, this.currentLedgerLength, this.payload);
        DistributionSchedule.WriteSet writeSet = this.lh.distributionSchedule.getWriteSet(this.entryId);
        try {
            for (int i = 0; i < writeSet.size(); ++i) {
                this.sendWriteRequest(writeSet.get(i));
            }
        }
        finally {
            writeSet.recycle();
        }
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx) {
        int bookieIndex = (Integer)ctx;
        --this.pendingWriteRequests;
        if (!this.lh.metadata.currentEnsemble.get(bookieIndex).equals(addr)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Write did not succeed: " + ledgerId + ", " + entryId + ". But we have already fixed it.");
            }
            return;
        }
        boolean ackQuorum = false;
        if (0 == rc) {
            ackQuorum = this.ackSet.completeBookieAndCheck(bookieIndex);
        }
        if (this.completed) {
            this.sendAddSuccessCallbacks();
            this.maybeRecycle();
            return;
        }
        switch (rc) {
            case 0: {
                break;
            }
            case -19: {
                this.lh.errorOutPendingAdds(rc);
                return;
            }
            case -101: {
                LOG.warn("Fencing exception on write: L{} E{} on {}", new Object[]{ledgerId, entryId, addr});
                this.lh.handleUnrecoverableErrorDuringAdd(rc);
                return;
            }
            case -102: {
                LOG.warn("Unauthorized access exception on write: L{} E{} on {}", new Object[]{ledgerId, entryId, addr});
                this.lh.handleUnrecoverableErrorDuringAdd(rc);
                return;
            }
            default: {
                if (this.lh.bk.delayEnsembleChange) {
                    if (this.ackSet.failBookieAndCheck(bookieIndex, addr) || rc == -104) {
                        Map<Integer, BookieSocketAddress> failedBookies = this.ackSet.getFailedBookies();
                        LOG.warn("Failed to write entry ({}, {}) to bookies {}, handling failures.", new Object[]{ledgerId, entryId, failedBookies});
                        this.lh.handleBookieFailure(failedBookies);
                    } else if (LOG.isDebugEnabled()) {
                        LOG.debug("Failed to write entry ({}, {}) to bookie ({}, {}), but it didn't break ack quorum, delaying ensemble change : {}", new Object[]{ledgerId, entryId, bookieIndex, addr, BKException.getMessage(rc)});
                    }
                } else {
                    LOG.warn("Failed to write entry ({}, {}): {}", new Object[]{ledgerId, entryId, BKException.getMessage(rc)});
                    this.lh.handleBookieFailure((Map<Integer, BookieSocketAddress>)ImmutableMap.of((Object)bookieIndex, (Object)addr));
                }
                return;
            }
        }
        if (ackQuorum && !this.completed) {
            this.completed = true;
            this.sendAddSuccessCallbacks();
        }
    }

    void sendAddSuccessCallbacks() {
        this.lh.sendAddSuccessCallbacks();
    }

    void submitCallback(int rc) {
        if (null != this.timeout) {
            this.timeout.cancel();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Submit callback (lid:{}, eid: {}). rc:{}", new Object[]{this.lh.getId(), this.entryId, rc});
        }
        long latencyNanos = MathUtils.elapsedNanos((long)this.requestTimeNanos);
        if (rc != 0) {
            this.addOpLogger.registerFailedEvent(latencyNanos, TimeUnit.NANOSECONDS);
            LOG.error("Write of ledger entry to quorum failed: L{} E{}", (Object)this.lh.getId(), (Object)this.entryId);
        } else {
            this.addOpLogger.registerSuccessfulEvent(latencyNanos, TimeUnit.NANOSECONDS);
        }
        this.cb.addComplete(rc, this.lh, this.entryId, this.ctx);
        this.callbackTriggered = true;
        this.maybeRecycle();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("PendingAddOp(lid:").append(this.lh.ledgerId).append(", eid:").append(this.entryId).append(", completed:").append(this.completed).append(")");
        return sb.toString();
    }

    public int hashCode() {
        return (int)this.entryId;
    }

    public boolean equals(Object o) {
        if (o instanceof PendingAddOp) {
            return this.entryId == ((PendingAddOp)o).entryId;
        }
        return this == o;
    }

    private PendingAddOp(Recycler.Handle<PendingAddOp> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }

    private void maybeRecycle() {
        if (this.hasRun && this.callbackTriggered && this.pendingWriteRequests == 0) {
            this.recycle();
        }
    }

    private void recycle() {
        this.entryId = -1L;
        this.currentLedgerLength = -1L;
        ReferenceCountUtil.release((Object)this.toSend);
        this.payload = null;
        this.toSend = null;
        this.cb = null;
        this.ctx = null;
        this.ackSet.recycle();
        this.ackSet = null;
        this.lh = null;
        this.isRecoveryAdd = false;
        this.addOpLogger = null;
        this.completed = false;
        this.pendingWriteRequests = 0;
        this.callbackTriggered = false;
        this.hasRun = false;
        if (this.timeout != null) {
            this.timeout.cancel();
        }
        this.timeout = null;
        this.recyclerHandle.recycle((Object)this);
    }
}

