/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import io.netty.util.HashedWheelTimer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Supplier;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.WeightedRandomSelection;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.Configurable;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.net.NetUtils;
import org.apache.bookkeeper.net.NetworkTopology;
import org.apache.bookkeeper.net.NetworkTopologyImpl;
import org.apache.bookkeeper.net.Node;
import org.apache.bookkeeper.net.ScriptBasedMapping;
import org.apache.bookkeeper.net.StabilizeNetworkTopology;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.configuration.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class RackawareEnsemblePlacementPolicyImpl
extends TopologyAwareEnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(RackawareEnsemblePlacementPolicyImpl.class);
    boolean isWeighted;
    int maxWeightMultiple;
    private Map<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject> bookieInfoMap = new HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject>();
    private WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> weightedSelection;
    public static final String REPP_DNS_RESOLVER_CLASS = "reppDnsResolverClass";
    public static final String REPP_RANDOM_READ_REORDERING = "ensembleRandomReadReordering";
    static final int RACKNAME_DISTANCE_FROM_LEAVES = 1;
    static final int LOCAL_MASK = 0x1000000;
    static final int LOCAL_FAIL_MASK = 0x2000000;
    static final int REMOTE_MASK = 0x4000000;
    static final int REMOTE_FAIL_MASK = 0x8000000;
    static final int READ_ONLY_MASK = 0x10000000;
    static final int UNAVAIL_MASK = 0x20000000;
    static final int MASK_BITS = -1048576;
    protected NetworkTopology topology;
    protected DNSToSwitchMapping dnsResolver;
    protected HashedWheelTimer timer;
    protected final Map<BookieSocketAddress, TopologyAwareEnsemblePlacementPolicy.BookieNode> knownBookies;
    protected TopologyAwareEnsemblePlacementPolicy.BookieNode localNode;
    protected final ReentrantReadWriteLock rwLock;
    protected ImmutableSet<BookieSocketAddress> readOnlyBookies = null;
    protected boolean reorderReadsRandom = false;
    protected boolean enforceDurability = false;
    protected int stabilizePeriodSeconds = 0;
    protected StatsLogger statsLogger = null;
    protected OpStatsLogger bookiesJoinedCounter = null;
    protected OpStatsLogger bookiesLeftCounter = null;
    private String defaultRack = "/default-rack";

    RackawareEnsemblePlacementPolicyImpl() {
        this(false);
    }

    RackawareEnsemblePlacementPolicyImpl(boolean enforceDurability) {
        this.enforceDurability = enforceDurability;
        this.topology = new NetworkTopologyImpl();
        this.knownBookies = new HashMap<BookieSocketAddress, TopologyAwareEnsemblePlacementPolicy.BookieNode>();
        this.rwLock = new ReentrantReadWriteLock();
    }

    protected TopologyAwareEnsemblePlacementPolicy.BookieNode createBookieNode(BookieSocketAddress addr) {
        return new TopologyAwareEnsemblePlacementPolicy.BookieNode(addr, this.resolveNetworkLocation(addr));
    }

    protected RackawareEnsemblePlacementPolicyImpl initialize(DNSToSwitchMapping dnsResolver, HashedWheelTimer timer, boolean reorderReadsRandom, int stabilizePeriodSeconds, boolean isWeighted, int maxWeightMultiple, StatsLogger statsLogger) {
        TopologyAwareEnsemblePlacementPolicy.BookieNode bn;
        Preconditions.checkNotNull((Object)statsLogger, (Object)"statsLogger should not be null, use NullStatsLogger instead.");
        this.statsLogger = statsLogger;
        this.bookiesJoinedCounter = statsLogger.getOpStatsLogger("BOOKIES_JOINED");
        this.bookiesLeftCounter = statsLogger.getOpStatsLogger("BOOKIES_LEFT");
        this.reorderReadsRandom = reorderReadsRandom;
        this.stabilizePeriodSeconds = stabilizePeriodSeconds;
        this.dnsResolver = new DNSResolverDecorator(dnsResolver, () -> this.getDefaultRack());
        this.timer = timer;
        this.topology = stabilizePeriodSeconds > 0 ? new StabilizeNetworkTopology(timer, stabilizePeriodSeconds) : new NetworkTopologyImpl();
        try {
            bn = this.createBookieNode(new BookieSocketAddress(InetAddress.getLocalHost().getHostAddress(), 0));
        }
        catch (UnknownHostException e) {
            LOG.error("Failed to get local host address : ", (Throwable)e);
            bn = null;
        }
        this.localNode = bn;
        LOG.info("Initialize rackaware ensemble placement policy @ {} @ {} : {}.", new Object[]{this.localNode, null == this.localNode ? "Unknown" : this.localNode.getNetworkLocation(), dnsResolver.getClass().getName()});
        this.isWeighted = isWeighted;
        if (this.isWeighted) {
            this.maxWeightMultiple = maxWeightMultiple;
            this.weightedSelection = new WeightedRandomSelection(this.maxWeightMultiple);
            LOG.info("Weight based placement with max multiple of " + this.maxWeightMultiple);
        } else {
            LOG.info("Not weighted");
        }
        return this;
    }

    public RackawareEnsemblePlacementPolicyImpl withDefaultRack(String rack) {
        Preconditions.checkNotNull((Object)rack, (Object)"Default rack cannot be null");
        this.defaultRack = rack;
        return this;
    }

    public String getDefaultRack() {
        return this.defaultRack;
    }

    @Override
    public RackawareEnsemblePlacementPolicyImpl initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger) {
        DNSToSwitchMapping dnsResolver;
        if (optionalDnsResolver.isPresent()) {
            dnsResolver = optionalDnsResolver.get();
        } else {
            String dnsResolverName = conf.getString(REPP_DNS_RESOLVER_CLASS, ScriptBasedMapping.class.getName());
            try {
                dnsResolver = ReflectionUtils.newInstance(dnsResolverName, DNSToSwitchMapping.class);
                if (dnsResolver instanceof Configurable) {
                    ((Configurable)((Object)dnsResolver)).setConf((Configuration)conf);
                }
            }
            catch (RuntimeException re) {
                LOG.info("Failed to initialize DNS Resolver {}, used default subnet resolver.", (Object)dnsResolverName, (Object)re);
                dnsResolver = new DefaultResolver(() -> this.getDefaultRack());
            }
        }
        return this.initialize(dnsResolver, timer, conf.getBoolean(REPP_RANDOM_READ_REORDERING, false), conf.getNetworkTopologyStabilizePeriodSeconds(), conf.getDiskWeightBasedPlacementEnabled(), conf.getBookieMaxWeightMultipleForWeightBasedPlacement(), statsLogger);
    }

    @Override
    public void uninitalize() {
    }

    protected String resolveNetworkLocation(BookieSocketAddress addr) {
        return NetUtils.resolveNetworkLocation(this.dnsResolver, addr.getSocketAddress());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<BookieSocketAddress> onClusterChanged(Set<BookieSocketAddress> writableBookies, Set<BookieSocketAddress> readOnlyBookies) {
        this.rwLock.writeLock().lock();
        try {
            Set<BookieSocketAddress> oldBookieSet = this.knownBookies.keySet();
            ImmutableSet leftBookies = Sets.difference(oldBookieSet, writableBookies).immutableCopy();
            ImmutableSet joinedBookies = Sets.difference(writableBookies, oldBookieSet).immutableCopy();
            ImmutableSet deadBookies = Sets.difference((Set)leftBookies, readOnlyBookies).immutableCopy();
            LOG.debug("Cluster changed : left bookies are {}, joined bookies are {}, while dead bookies are {}.", new Object[]{leftBookies, joinedBookies, deadBookies});
            this.handleBookiesThatLeft((Set<BookieSocketAddress>)leftBookies);
            this.handleBookiesThatJoined((Set<BookieSocketAddress>)joinedBookies);
            if (this.isWeighted && (leftBookies.size() > 0 || joinedBookies.size() > 0)) {
                this.weightedSelection.updateMap(this.bookieInfoMap);
            }
            if (!readOnlyBookies.isEmpty()) {
                this.readOnlyBookies = ImmutableSet.copyOf(readOnlyBookies);
            }
            ImmutableSet immutableSet = deadBookies;
            return immutableSet;
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieSocketAddress> leftBookies) {
        for (BookieSocketAddress addr : leftBookies) {
            try {
                TopologyAwareEnsemblePlacementPolicy.BookieNode node = this.knownBookies.remove(addr);
                if (null == node) continue;
                this.topology.remove(node);
                if (this.isWeighted) {
                    this.bookieInfoMap.remove(node);
                }
                this.bookiesLeftCounter.registerSuccessfulValue(1L);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Cluster changed : bookie {} left from cluster.", (Object)addr);
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception while handling leaving bookie {}", (Object)addr, (Object)t);
                if (this.bookiesLeftCounter == null) continue;
                this.bookiesLeftCounter.registerFailedValue(1L);
            }
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieSocketAddress> joinedBookies) {
        for (BookieSocketAddress addr : joinedBookies) {
            try {
                TopologyAwareEnsemblePlacementPolicy.BookieNode node = this.createBookieNode(addr);
                this.topology.add(node);
                this.knownBookies.put(addr, node);
                if (this.isWeighted) {
                    this.bookieInfoMap.putIfAbsent(node, new BookieInfoReader.BookieInfo());
                }
                this.bookiesJoinedCounter.registerSuccessfulValue(1L);
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("Cluster changed : bookie {} joined the cluster.", (Object)addr);
            }
            catch (Throwable t) {
                LOG.error("Unexpected exception while handling joining bookie {}", (Object)addr, (Object)t);
                this.bookiesJoinedCounter.registerFailedValue(1L);
            }
        }
    }

    protected Set<Node> convertBookiesToNodes(Set<BookieSocketAddress> excludeBookies) {
        HashSet<Node> nodes = new HashSet<Node>();
        for (BookieSocketAddress addr : excludeBookies) {
            TopologyAwareEnsemblePlacementPolicy.BookieNode bn = this.knownBookies.get(addr);
            if (null == bn) {
                bn = this.createBookieNode(addr);
            }
            nodes.add(bn);
        }
        return nodes;
    }

    @Override
    public ArrayList<BookieSocketAddress> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        return this.newEnsembleInternal(ensembleSize, writeQuorumSize, excludeBookies, null, null);
    }

    protected ArrayList<BookieSocketAddress> newEnsembleInternal(int ensembleSize, int writeQuorumSize, Set<BookieSocketAddress> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        return this.newEnsembleInternal(ensembleSize, writeQuorumSize, writeQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
    }

    @Override
    public ArrayList<BookieSocketAddress> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieSocketAddress> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        return this.newEnsembleInternal(ensembleSize, writeQuorumSize, ackQuorumSize, excludeBookies, parentEnsemble, parentPredicate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ArrayList<BookieSocketAddress> newEnsembleInternal(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Set<BookieSocketAddress> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> parentPredicate) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            Set<Node> excludeNodes = this.convertBookiesToNodes(excludeBookies);
            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 1, parentEnsemble, parentPredicate);
            Node prevNode = null;
            int numRacks = this.topology.getNumOfRacks();
            if (numRacks < 2) {
                List<TopologyAwareEnsemblePlacementPolicy.BookieNode> bns = this.selectRandom(ensembleSize, excludeNodes, TopologyAwareEnsemblePlacementPolicy.TruePredicate.instance, ensemble);
                ArrayList<BookieSocketAddress> addrs = new ArrayList<BookieSocketAddress>(ensembleSize);
                for (TopologyAwareEnsemblePlacementPolicy.BookieNode bn : bns) {
                    addrs.add(bn.getAddr());
                }
                ArrayList<BookieSocketAddress> arrayList = addrs;
                return arrayList;
            }
            for (int i = 0; i < ensembleSize; ++i) {
                String curRack = null == prevNode ? (null == this.localNode || this.defaultRack.equals(this.localNode.getNetworkLocation()) ? "" : this.localNode.getNetworkLocation()) : "~" + prevNode.getNetworkLocation();
                prevNode = this.selectFromNetworkLocation(curRack, (Set)excludeNodes, (ITopologyAwareEnsemblePlacementPolicy.Predicate)ensemble, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)ensemble);
            }
            ArrayList<BookieSocketAddress> bookieList = ensemble.toList();
            if (ensembleSize != bookieList.size()) {
                LOG.error("Not enough {} bookies are available to form an ensemble : {}.", (Object)ensembleSize, bookieList);
                throw new BKException.BKNotEnoughBookiesException();
            }
            ArrayList<BookieSocketAddress> arrayList = bookieList;
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BookieSocketAddress replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Collection<BookieSocketAddress> currentEnsemble, BookieSocketAddress bookieToReplace, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            excludeBookies.addAll(currentEnsemble);
            TopologyAwareEnsemblePlacementPolicy.BookieNode bn = this.knownBookies.get(bookieToReplace);
            if (null == bn) {
                bn = this.createBookieNode(bookieToReplace);
            }
            Set<Node> excludeNodes = this.convertBookiesToNodes(excludeBookies);
            excludeNodes.add(bn);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to choose a new bookie to replace {}, excluding {}.", (Object)bookieToReplace, excludeNodes);
            }
            Node candidate = this.selectFromNetworkLocation(bn.getNetworkLocation(), (Set)excludeNodes, (ITopologyAwareEnsemblePlacementPolicy.Predicate)TopologyAwareEnsemblePlacementPolicy.TruePredicate.instance, (ITopologyAwareEnsemblePlacementPolicy.Ensemble)TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.instance);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bookie {} is chosen to replace bookie {}.", (Object)candidate, (Object)bn);
            }
            BookieSocketAddress bookieSocketAddress = ((TopologyAwareEnsemblePlacementPolicy.BookieNode)candidate).getAddr();
            return bookieSocketAddress;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateBookieInfo(Map<BookieSocketAddress, BookieInfoReader.BookieInfo> bookieInfoMap) {
        if (!this.isWeighted) {
            LOG.info("bookieFreeDiskInfo callback called even without weighted placement policy being used.");
            return;
        }
        ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode> allBookies = new ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode>(this.knownBookies.values());
        HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject> map = new HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject>();
        for (TopologyAwareEnsemblePlacementPolicy.BookieNode bookie : allBookies) {
            if (bookieInfoMap.containsKey(bookie.getAddr())) {
                map.put(bookie, bookieInfoMap.get(bookie.getAddr()));
                continue;
            }
            map.put(bookie, new BookieInfoReader.BookieInfo());
        }
        this.rwLock.writeLock().lock();
        try {
            this.bookieInfoMap = map;
            this.weightedSelection.updateMap(this.bookieInfoMap);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    @Override
    public TopologyAwareEnsemblePlacementPolicy.BookieNode selectFromNetworkLocation(String networkLoc, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        try {
            return this.selectRandomFromRack(networkLoc, excludeBookies, predicate, ensemble);
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            LOG.warn("Failed to choose a bookie from {} : excluded {}, fallback to choose bookie randomly from the cluster.", (Object)networkLoc, excludeBookies);
            return this.selectRandom(1, excludeBookies, predicate, ensemble).get(0);
        }
    }

    protected String getRemoteRack(TopologyAwareEnsemblePlacementPolicy.BookieNode node) {
        return "~" + node.getNetworkLocation();
    }

    private WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> prepareForWeightedSelection(List<Node> leaves) {
        HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject> rackMap = new HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject>();
        for (Node n : leaves) {
            if (!(n instanceof TopologyAwareEnsemblePlacementPolicy.BookieNode)) continue;
            TopologyAwareEnsemblePlacementPolicy.BookieNode bookie = (TopologyAwareEnsemblePlacementPolicy.BookieNode)n;
            if (this.bookieInfoMap.containsKey(bookie)) {
                rackMap.put(bookie, this.bookieInfoMap.get(bookie));
                continue;
            }
            rackMap.put(bookie, new BookieInfoReader.BookieInfo());
        }
        if (rackMap.size() == 0) {
            return null;
        }
        WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> wRSelection = new WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode>(this.maxWeightMultiple);
        wRSelection.updateMap(rackMap);
        return wRSelection;
    }

    protected TopologyAwareEnsemblePlacementPolicy.BookieNode selectRandomFromRack(String netPath, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        block8: {
            Node n;
            WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> wRSelection = null;
            ArrayList<Node> leaves = new ArrayList<Node>(this.topology.getLeaves(netPath));
            if (!this.isWeighted) {
                Collections.shuffle(leaves);
            } else {
                if (CollectionUtils.subtract(leaves, excludeBookies).size() < 1) {
                    throw new BKException.BKNotEnoughBookiesException();
                }
                wRSelection = this.prepareForWeightedSelection(leaves);
                if (wRSelection == null) {
                    throw new BKException.BKNotEnoughBookiesException();
                }
            }
            Iterator it = leaves.iterator();
            HashSet<Node> bookiesSeenSoFar = new HashSet<Node>();
            do {
                if (this.isWeighted) {
                    if (bookiesSeenSoFar.size() != leaves.size()) {
                        n = wRSelection.getNextRandom();
                        bookiesSeenSoFar.add(n);
                        continue;
                    }
                    break block8;
                }
                if (!it.hasNext()) break block8;
                n = (Node)it.next();
            } while (excludeBookies.contains(n) || !(n instanceof TopologyAwareEnsemblePlacementPolicy.BookieNode) || !predicate.apply((TopologyAwareEnsemblePlacementPolicy.BookieNode)n, ensemble));
            TopologyAwareEnsemblePlacementPolicy.BookieNode bn = (TopologyAwareEnsemblePlacementPolicy.BookieNode)n;
            if (ensemble.addNode(bn)) {
                excludeBookies.add(bn);
            }
            return bn;
        }
        throw new BKException.BKNotEnoughBookiesException();
    }

    protected List<TopologyAwareEnsemblePlacementPolicy.BookieNode> selectRandom(int numBookies, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        return this.selectRandomInternal(null, numBookies, excludeBookies, predicate, ensemble);
    }

    protected List<TopologyAwareEnsemblePlacementPolicy.BookieNode> selectRandomInternal(List<TopologyAwareEnsemblePlacementPolicy.BookieNode> bookiesToSelectFrom, int numBookies, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        WeightedRandomSelection<TopologyAwareEnsemblePlacementPolicy.BookieNode> wRSelection = null;
        if (bookiesToSelectFrom == null) {
            wRSelection = this.weightedSelection;
            bookiesToSelectFrom = new ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode>(this.knownBookies.values());
        }
        if (this.isWeighted) {
            if (CollectionUtils.subtract(bookiesToSelectFrom, excludeBookies).size() < numBookies) {
                throw new BKException.BKNotEnoughBookiesException();
            }
            if (wRSelection == null) {
                HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject> rackMap = new HashMap<TopologyAwareEnsemblePlacementPolicy.BookieNode, WeightedRandomSelection.WeightedObject>();
                for (TopologyAwareEnsemblePlacementPolicy.BookieNode n : bookiesToSelectFrom) {
                    if (excludeBookies.contains(n)) continue;
                    if (this.bookieInfoMap.containsKey(n)) {
                        rackMap.put(n, this.bookieInfoMap.get(n));
                        continue;
                    }
                    rackMap.put(n, new BookieInfoReader.BookieInfo());
                }
                wRSelection = new WeightedRandomSelection(this.maxWeightMultiple);
                wRSelection.updateMap(rackMap);
            }
        } else {
            Collections.shuffle(bookiesToSelectFrom);
        }
        ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode> newBookies = new ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode>(numBookies);
        Iterator<TopologyAwareEnsemblePlacementPolicy.BookieNode> it = bookiesToSelectFrom.iterator();
        HashSet<TopologyAwareEnsemblePlacementPolicy.BookieNode> bookiesSeenSoFar = new HashSet<TopologyAwareEnsemblePlacementPolicy.BookieNode>();
        while (numBookies > 0) {
            TopologyAwareEnsemblePlacementPolicy.BookieNode bookie;
            if (this.isWeighted) {
                if (bookiesSeenSoFar.size() == bookiesToSelectFrom.size()) break;
                bookie = wRSelection.getNextRandom();
                bookiesSeenSoFar.add(bookie);
            } else {
                if (!it.hasNext()) break;
                bookie = it.next();
            }
            if (excludeBookies.contains(bookie) || this.enforceDurability && !predicate.apply(bookie, ensemble) || !ensemble.addNode(bookie)) continue;
            excludeBookies.add(bookie);
            newBookies.add(bookie);
            --numBookies;
        }
        if (numBookies == 0) {
            return newBookies;
        }
        LOG.warn("Failed to find {} bookies : excludeBookies {}, allBookies {}.", new Object[]{numBookies, excludeBookies, bookiesToSelectFrom});
        throw new BKException.BKNotEnoughBookiesException();
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(ArrayList<BookieSocketAddress> ensemble, Map<BookieSocketAddress, Long> bookieFailureHistory, DistributionSchedule.WriteSet writeSet) {
        int i;
        int ensembleSize = ensemble.size();
        for (i = 0; i < writeSet.size(); ++i) {
            int idx = writeSet.get(i);
            BookieSocketAddress address = ensemble.get(idx);
            Long lastFailedEntryOnBookie = bookieFailureHistory.get(address);
            if (null == this.knownBookies.get(address)) {
                if (null == this.readOnlyBookies || !this.readOnlyBookies.contains((Object)address)) {
                    writeSet.set(i, idx | 0x20000000);
                    continue;
                }
                writeSet.set(i, idx | 0x10000000);
                continue;
            }
            if (lastFailedEntryOnBookie == null || lastFailedEntryOnBookie < 0L) {
                writeSet.set(i, idx | 0x1000000);
                continue;
            }
            long failIdx = lastFailedEntryOnBookie * (long)ensembleSize + (long)idx;
            writeSet.set(i, (int)(failIdx & 0xFFFFFL) | 0x2000000);
        }
        for (i = 0; i < writeSet.size(); ++i) {
            writeSet.set(i, writeSet.get(i) | (i & 0xF) << 20);
        }
        writeSet.sort();
        for (i = 0; i < writeSet.size(); ++i) {
            writeSet.set(i, writeSet.get(i) & 0xFF0FFFFF);
        }
        if (this.reorderReadsRandom) {
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask(writeSet, 0x1000000, -1048576);
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask(writeSet, 0x10000000, -1048576);
            RackawareEnsemblePlacementPolicyImpl.shuffleWithMask(writeSet, 0x20000000, -1048576);
        }
        for (i = 0; i < writeSet.size(); ++i) {
            writeSet.set(i, (writeSet.get(i) & 0xFFFFF) % ensembleSize);
        }
        return writeSet;
    }

    static void shuffleWithMask(DistributionSchedule.WriteSet writeSet, int mask, int bits) {
        int i;
        int first = -1;
        int last = -1;
        for (i = 0; i < writeSet.size(); ++i) {
            if ((writeSet.get(i) & bits) != mask) continue;
            if (first == -1) {
                first = i;
            }
            last = i;
        }
        if (first != -1) {
            for (i = last + 1; i > first; --i) {
                int swapWith = ThreadLocalRandom.current().nextInt(i);
                writeSet.set(swapWith, writeSet.set(i, writeSet.get(swapWith)));
            }
        }
    }

    static class DNSResolverDecorator
    implements DNSToSwitchMapping {
        final Supplier<String> defaultRackSupplier;
        final DNSToSwitchMapping resolver;

        DNSResolverDecorator(DNSToSwitchMapping resolver, Supplier<String> defaultRackSupplier) {
            Preconditions.checkNotNull((Object)resolver, (Object)"Resolver cannot be null");
            Preconditions.checkNotNull(defaultRackSupplier, (Object)"defaultRackSupplier should not be null");
            this.defaultRackSupplier = defaultRackSupplier;
            this.resolver = resolver;
        }

        @Override
        public List<String> resolve(List<String> names) {
            if (names == null) {
                return Collections.emptyList();
            }
            String defaultRack = this.defaultRackSupplier.get();
            Preconditions.checkNotNull((Object)defaultRack, (Object)"Default rack cannot be null");
            List<String> rNames = this.resolver.resolve(names);
            if (rNames != null && rNames.size() == names.size()) {
                for (int i = 0; i < rNames.size(); ++i) {
                    if (rNames.get(i) != null) continue;
                    LOG.warn("Failed to resolve network location for {}, using default rack for it : {}.", (Object)names.get(i), (Object)defaultRack);
                    rNames.set(i, defaultRack);
                }
                return rNames;
            }
            LOG.warn("Failed to resolve network location for {}, using default rack for them : {}.", names, (Object)defaultRack);
            rNames = new ArrayList<String>(names.size());
            for (int i = 0; i < names.size(); ++i) {
                rNames.add(defaultRack);
            }
            return rNames;
        }

        @Override
        public boolean useHostName() {
            return this.resolver.useHostName();
        }

        @Override
        public void reloadCachedMappings() {
            this.resolver.reloadCachedMappings();
        }
    }

    static class DefaultResolver
    implements DNSToSwitchMapping {
        final Supplier<String> defaultRackSupplier;

        public DefaultResolver() {
            this(() -> "/default-region/default-rack");
        }

        public DefaultResolver(Supplier<String> defaultRackSupplier) {
            Preconditions.checkNotNull(defaultRackSupplier, (Object)"defaultRackSupplier should not be null");
            this.defaultRackSupplier = defaultRackSupplier;
        }

        @Override
        public List<String> resolve(List<String> names) {
            ArrayList<String> rNames = new ArrayList<String>(names.size());
            for (String name : names) {
                String defaultRack = this.defaultRackSupplier.get();
                Preconditions.checkNotNull((Object)defaultRack, (Object)"defaultRack cannot be null");
                rNames.add(defaultRack);
            }
            return rNames;
        }

        @Override
        public void reloadCachedMappings() {
        }
    }
}

