/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.NodeBase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class TopologyAwareEnsemblePlacementPolicy
implements ITopologyAwareEnsemblePlacementPolicy<BookieNode> {
    static final Logger LOG = LoggerFactory.getLogger(TopologyAwareEnsemblePlacementPolicy.class);

    TopologyAwareEnsemblePlacementPolicy() {
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadSequence(ArrayList<BookieSocketAddress> ensemble, Map<BookieSocketAddress, Long> bookieFailureHistory, DistributionSchedule.WriteSet writeSet) {
        return writeSet;
    }

    @Override
    public DistributionSchedule.WriteSet reorderReadLACSequence(ArrayList<BookieSocketAddress> ensemble, Map<BookieSocketAddress, Long> bookieFailureHistory, DistributionSchedule.WriteSet writeSet) {
        DistributionSchedule.WriteSet retList = this.reorderReadSequence(ensemble, bookieFailureHistory, writeSet);
        retList.addMissingIndices(ensemble.size());
        return retList;
    }

    protected static class RRTopologyAwareCoverageEnsemble
    implements ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode>,
    ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> {
        final int distanceFromLeaves;
        final int ensembleSize;
        final int writeQuorumSize;
        final int ackQuorumSize;
        final int minRacksOrRegionsForDurability;
        final ArrayList<BookieNode> chosenNodes;
        final Set<String> racksOrRegions;
        private final CoverageSet[] quorums;
        final ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate;
        final ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble;

        protected RRTopologyAwareCoverageEnsemble(RRTopologyAwareCoverageEnsemble that) {
            this.distanceFromLeaves = that.distanceFromLeaves;
            this.ensembleSize = that.ensembleSize;
            this.writeQuorumSize = that.writeQuorumSize;
            this.ackQuorumSize = that.ackQuorumSize;
            this.chosenNodes = Lists.newArrayList(that.chosenNodes);
            this.quorums = new CoverageSet[that.quorums.length];
            for (int i = 0; i < that.quorums.length; ++i) {
                this.quorums[i] = null != that.quorums[i] ? that.quorums[i].duplicate() : null;
            }
            this.parentPredicate = that.parentPredicate;
            this.parentEnsemble = that.parentEnsemble;
            this.racksOrRegions = null != that.racksOrRegions ? new HashSet<String>(that.racksOrRegions) : null;
            this.minRacksOrRegionsForDurability = that.minRacksOrRegionsForDurability;
        }

        protected RRTopologyAwareCoverageEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, int distanceFromLeaves, Set<String> racksOrRegions, int minRacksOrRegionsForDurability) {
            this(ensembleSize, writeQuorumSize, ackQuorumSize, distanceFromLeaves, null, null, racksOrRegions, minRacksOrRegionsForDurability);
        }

        protected RRTopologyAwareCoverageEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, int distanceFromLeaves, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate) {
            this(ensembleSize, writeQuorumSize, ackQuorumSize, distanceFromLeaves, parentEnsemble, parentPredicate, null, 0);
        }

        protected RRTopologyAwareCoverageEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, int distanceFromLeaves, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> parentEnsemble, ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> parentPredicate, Set<String> racksOrRegions, int minRacksOrRegionsForDurability) {
            this.ensembleSize = ensembleSize;
            this.writeQuorumSize = writeQuorumSize;
            this.ackQuorumSize = ackQuorumSize;
            this.distanceFromLeaves = distanceFromLeaves;
            this.chosenNodes = new ArrayList(ensembleSize);
            this.quorums = minRacksOrRegionsForDurability > 0 ? new RackOrRegionDurabilityCoverageSet[ensembleSize] : new RackQuorumCoverageSet[ensembleSize];
            this.parentEnsemble = parentEnsemble;
            this.parentPredicate = parentPredicate;
            this.racksOrRegions = racksOrRegions;
            this.minRacksOrRegionsForDurability = minRacksOrRegionsForDurability;
        }

        @Override
        public boolean apply(BookieNode candidate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> ensemble) {
            if (ensemble != this) {
                return false;
            }
            if (this.chosenNodes.contains(candidate)) {
                return false;
            }
            if (this.ensembleSize == this.writeQuorumSize && this.minRacksOrRegionsForDurability > 0) {
                if (null == this.quorums[0]) {
                    this.quorums[0] = new RackOrRegionDurabilityCoverageSet();
                }
                if (!this.quorums[0].apply(candidate)) {
                    return false;
                }
            } else {
                int startPos;
                int candidatePos = this.chosenNodes.size();
                for (int i = startPos = candidatePos - this.writeQuorumSize + 1; i <= candidatePos; ++i) {
                    int idx = (i + this.ensembleSize) % this.ensembleSize;
                    if (null == this.quorums[idx]) {
                        this.quorums[idx] = this.minRacksOrRegionsForDurability > 0 ? new RackOrRegionDurabilityCoverageSet() : new RackQuorumCoverageSet();
                    }
                    if (this.quorums[idx].apply(candidate)) continue;
                    return false;
                }
            }
            return null == this.parentPredicate || this.parentPredicate.apply(candidate, this.parentEnsemble);
        }

        @Override
        public boolean addNode(BookieNode node) {
            if (this.chosenNodes.contains(node)) {
                return false;
            }
            if (this.ensembleSize == this.writeQuorumSize && this.minRacksOrRegionsForDurability > 0) {
                if (null == this.quorums[0]) {
                    this.quorums[0] = new RackOrRegionDurabilityCoverageSet();
                }
                this.quorums[0].addBookie(node);
            } else {
                int startPos;
                int candidatePos = this.chosenNodes.size();
                for (int i = startPos = candidatePos - this.writeQuorumSize + 1; i <= candidatePos; ++i) {
                    int idx = (i + this.ensembleSize) % this.ensembleSize;
                    if (null == this.quorums[idx]) {
                        this.quorums[idx] = this.minRacksOrRegionsForDurability > 0 ? new RackOrRegionDurabilityCoverageSet() : new RackQuorumCoverageSet();
                    }
                    this.quorums[idx].addBookie(node);
                }
            }
            this.chosenNodes.add(node);
            return null == this.parentEnsemble || this.parentEnsemble.addNode(node);
        }

        @Override
        public ArrayList<BookieSocketAddress> toList() {
            ArrayList<BookieSocketAddress> addresses = new ArrayList<BookieSocketAddress>(this.ensembleSize);
            for (BookieNode bn : this.chosenNodes) {
                addresses.add(bn.getAddr());
            }
            return addresses;
        }

        @Override
        public boolean validate() {
            HashSet<BookieSocketAddress> addresses = new HashSet<BookieSocketAddress>(this.ensembleSize);
            HashSet<String> racksOrRegions = new HashSet<String>();
            for (BookieNode bn : this.chosenNodes) {
                if (addresses.contains(bn.getAddr())) {
                    return false;
                }
                addresses.add(bn.getAddr());
                racksOrRegions.add(bn.getNetworkLocation(this.distanceFromLeaves));
            }
            return this.minRacksOrRegionsForDurability == 0 || racksOrRegions.size() >= this.minRacksOrRegionsForDurability;
        }

        public String toString() {
            return this.chosenNodes.toString();
        }

        protected class RackOrRegionDurabilityCoverageSet
        implements CoverageSet {
            HashMap<String, Integer> allocationToRacksOrRegions = new HashMap();

            RackOrRegionDurabilityCoverageSet() {
                for (String rackOrRegion : RRTopologyAwareCoverageEnsemble.this.racksOrRegions) {
                    this.allocationToRacksOrRegions.put(rackOrRegion, 0);
                }
            }

            @Override
            public RackOrRegionDurabilityCoverageSet duplicate() {
                RackOrRegionDurabilityCoverageSet ret = new RackOrRegionDurabilityCoverageSet();
                ret.allocationToRacksOrRegions = Maps.newHashMap(this.allocationToRacksOrRegions);
                return ret;
            }

            private boolean checkSumOfSubsetWithinLimit(Set<String> includedRacksOrRegions, Set<String> remainingRacksOrRegions, int subsetSize, int maxAllowedSum) {
                if (remainingRacksOrRegions.isEmpty() || subsetSize <= 0) {
                    if (maxAllowedSum < 0 && LOG.isTraceEnabled()) {
                        LOG.trace("CHECK FAILED: RacksOrRegions Included {} Remaining {}, subsetSize {}, maxAllowedSum {}", new Object[]{includedRacksOrRegions, remainingRacksOrRegions, subsetSize, maxAllowedSum});
                    }
                    return maxAllowedSum >= 0;
                }
                for (String rackOrRegion : remainingRacksOrRegions) {
                    Integer currentAllocation = this.allocationToRacksOrRegions.get(rackOrRegion);
                    if (currentAllocation == null) {
                        this.allocationToRacksOrRegions.put(rackOrRegion, 0);
                        currentAllocation = 0;
                    }
                    if (currentAllocation > maxAllowedSum) {
                        if (LOG.isTraceEnabled()) {
                            LOG.trace("CHECK FAILED: RacksOrRegions Included {} Candidate {}, subsetSize {}, maxAllowedSum {}", new Object[]{includedRacksOrRegions, rackOrRegion, subsetSize, maxAllowedSum});
                        }
                        return false;
                    }
                    HashSet<String> remainingElements = new HashSet<String>(remainingRacksOrRegions);
                    HashSet<String> includedElements = new HashSet<String>(includedRacksOrRegions);
                    includedElements.add(rackOrRegion);
                    remainingElements.remove(rackOrRegion);
                    if (this.checkSumOfSubsetWithinLimit(includedElements, remainingElements, subsetSize - 1, maxAllowedSum - currentAllocation)) continue;
                    return false;
                }
                return true;
            }

            @Override
            public boolean apply(BookieNode candidate) {
                if (RRTopologyAwareCoverageEnsemble.this.minRacksOrRegionsForDurability <= 1) {
                    return true;
                }
                String candidateRackOrRegion = candidate.getNetworkLocation(RRTopologyAwareCoverageEnsemble.this.distanceFromLeaves);
                candidateRackOrRegion = candidateRackOrRegion.startsWith("/") ? candidateRackOrRegion.substring(1) : candidateRackOrRegion;
                HashSet<String> remainingRacksOrRegions = new HashSet<String>(RRTopologyAwareCoverageEnsemble.this.racksOrRegions);
                remainingRacksOrRegions.remove(candidateRackOrRegion);
                HashSet<String> includedRacksOrRegions = new HashSet<String>();
                includedRacksOrRegions.add(candidateRackOrRegion);
                Integer currentAllocation = this.allocationToRacksOrRegions.get(candidateRackOrRegion);
                if (currentAllocation == null) {
                    LOG.info("Detected a region that was not initialized {}", (Object)candidateRackOrRegion);
                    if (candidateRackOrRegion.equals("/default-region")) {
                        LOG.error("Failed to resolve network location {}", (Object)candidate);
                    } else if (!RRTopologyAwareCoverageEnsemble.this.racksOrRegions.contains(candidateRackOrRegion)) {
                        LOG.error("Unknown region detected {}", (Object)candidateRackOrRegion);
                    }
                    this.allocationToRacksOrRegions.put(candidateRackOrRegion, 0);
                    currentAllocation = 0;
                }
                int inclusiveLimit = RRTopologyAwareCoverageEnsemble.this.ackQuorumSize - 1 - (currentAllocation + 1);
                return this.checkSumOfSubsetWithinLimit(includedRacksOrRegions, remainingRacksOrRegions, RRTopologyAwareCoverageEnsemble.this.minRacksOrRegionsForDurability - 2, inclusiveLimit);
            }

            @Override
            public void addBookie(BookieNode candidate) {
                String candidateRackOrRegion = candidate.getNetworkLocation(RRTopologyAwareCoverageEnsemble.this.distanceFromLeaves);
                candidateRackOrRegion = candidateRackOrRegion.startsWith("/") ? candidateRackOrRegion.substring(1) : candidateRackOrRegion;
                int oldCount = 0;
                if (null != this.allocationToRacksOrRegions.get(candidateRackOrRegion)) {
                    oldCount = this.allocationToRacksOrRegions.get(candidateRackOrRegion);
                }
                this.allocationToRacksOrRegions.put(candidateRackOrRegion, oldCount + 1);
            }
        }

        protected class RackQuorumCoverageSet
        implements CoverageSet {
            HashSet<String> racksOrRegionsInQuorum = new HashSet();
            int seenBookies = 0;

            protected RackQuorumCoverageSet() {
            }

            @Override
            public boolean apply(BookieNode candidate) {
                if (RRTopologyAwareCoverageEnsemble.this.writeQuorumSize < 2) {
                    return true;
                }
                if (this.seenBookies + 1 == RRTopologyAwareCoverageEnsemble.this.writeQuorumSize) {
                    return this.racksOrRegionsInQuorum.size() > (this.racksOrRegionsInQuorum.contains(candidate.getNetworkLocation(RRTopologyAwareCoverageEnsemble.this.distanceFromLeaves)) ? 1 : 0);
                }
                return true;
            }

            @Override
            public void addBookie(BookieNode candidate) {
                ++this.seenBookies;
                this.racksOrRegionsInQuorum.add(candidate.getNetworkLocation(RRTopologyAwareCoverageEnsemble.this.distanceFromLeaves));
            }

            @Override
            public RackQuorumCoverageSet duplicate() {
                RackQuorumCoverageSet ret = new RackQuorumCoverageSet();
                ret.racksOrRegionsInQuorum = Sets.newHashSet(this.racksOrRegionsInQuorum);
                ret.seenBookies = this.seenBookies;
                return ret;
            }
        }

        protected static interface CoverageSet {
            public boolean apply(BookieNode var1);

            public void addBookie(BookieNode var1);

            public CoverageSet duplicate();
        }
    }

    protected static class BookieNode
    extends NodeBase {
        private final BookieSocketAddress addr;

        BookieNode(BookieSocketAddress addr, String networkLoc) {
            super(addr.toString(), networkLoc);
            this.addr = addr;
        }

        public BookieSocketAddress getAddr() {
            return this.addr;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof BookieNode)) {
                return false;
            }
            BookieNode other = (BookieNode)obj;
            return this.getName().equals(other.getName());
        }

        @Override
        public String toString() {
            return String.format("<Bookie:%s>", this.name);
        }
    }

    protected static class EnsembleForReplacementWithNoConstraints
    implements ITopologyAwareEnsemblePlacementPolicy.Ensemble<BookieNode> {
        public static final EnsembleForReplacementWithNoConstraints instance = new EnsembleForReplacementWithNoConstraints();
        static final ArrayList<BookieSocketAddress> EMPTY_LIST = new ArrayList(0);

        protected EnsembleForReplacementWithNoConstraints() {
        }

        @Override
        public boolean addNode(BookieNode node) {
            return true;
        }

        @Override
        public ArrayList<BookieSocketAddress> toList() {
            return EMPTY_LIST;
        }

        @Override
        public boolean validate() {
            return true;
        }
    }

    protected static class TruePredicate
    implements ITopologyAwareEnsemblePlacementPolicy.Predicate<BookieNode> {
        public static final TruePredicate instance = new TruePredicate();

        protected TruePredicate() {
        }

        @Override
        public boolean apply(BookieNode candidate, ITopologyAwareEnsemblePlacementPolicy.Ensemble chosenNodes) {
            return true;
        }
    }
}

