/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.RateLimiter;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.BookieShell;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateLedgerOp {
    private static final Logger LOG = LoggerFactory.getLogger(UpdateLedgerOp.class);
    private final BookKeeper bkc;
    private final BookKeeperAdmin admin;

    public UpdateLedgerOp(BookKeeper bkc, BookKeeperAdmin admin) {
        this.bkc = bkc;
        this.admin = admin;
    }

    public void updateBookieIdInLedgers(final BookieSocketAddress oldBookieId, final BookieSocketAddress newBookieId, final int rate, final int limit, final BookieShell.UpdateLedgerNotifier progressable) throws BKException, IOException {
        ThreadFactoryBuilder tfb = new ThreadFactoryBuilder().setNameFormat("UpdateLedgerThread").setDaemon(true);
        ExecutorService executor = Executors.newSingleThreadExecutor(tfb.build());
        final AtomicInteger issuedLedgerCnt = new AtomicInteger();
        final AtomicInteger updatedLedgerCnt = new AtomicInteger();
        Future<?> updateBookieCb = executor.submit(new Runnable(){

            @Override
            public void run() {
                this.updateLedgers(oldBookieId, newBookieId, rate, limit, progressable);
            }

            private void updateLedgers(BookieSocketAddress oldBookieId2, BookieSocketAddress newBookieId2, int rate2, int limit2, BookieShell.UpdateLedgerNotifier progressable2) {
                try {
                    AtomicBoolean stop = new AtomicBoolean(false);
                    Set<Long> outstandings = Collections.newSetFromMap(new ConcurrentHashMap());
                    RateLimiter throttler = RateLimiter.create((double)rate2);
                    Iterator<Long> ledgerItr = UpdateLedgerOp.this.admin.listLedgers().iterator();
                    CountDownLatch syncObj = new CountDownLatch(1);
                    while (ledgerItr.hasNext() && !stop.get()) {
                        throttler.acquire();
                        Long lId = ledgerItr.next();
                        ReadLedgerMetadataCb readCb = new ReadLedgerMetadataCb(UpdateLedgerOp.this.bkc, lId, oldBookieId2, newBookieId2);
                        outstandings.add(lId);
                        UpdateLedgerCb updateLedgerCb = new UpdateLedgerCb(lId, stop, issuedLedgerCnt, updatedLedgerCnt, outstandings, syncObj, progressable2);
                        Futures.addCallback(readCb.getFutureListener(), (FutureCallback)updateLedgerCb);
                        issuedLedgerCnt.incrementAndGet();
                        if (limit2 != Integer.MIN_VALUE && issuedLedgerCnt.get() >= limit2 || !ledgerItr.hasNext()) {
                            stop.set(true);
                        }
                        UpdateLedgerOp.this.bkc.getLedgerManager().readLedgerMetadata(lId, readCb);
                    }
                    syncObj.await();
                }
                catch (IOException ioe) {
                    LOG.error("Exception while updating ledger", (Throwable)ioe);
                    throw new RuntimeException("Exception while updating ledger", ioe.getCause());
                }
                catch (InterruptedException ie) {
                    LOG.error("Exception while updating ledger metadata", (Throwable)ie);
                    Thread.currentThread().interrupt();
                    throw new RuntimeException("Exception while updating ledger", ie.getCause());
                }
            }
        });
        try {
            updateBookieCb.get();
        }
        catch (ExecutionException ee) {
            throw new IOException("Exception while updating ledger", ee);
        }
        catch (InterruptedException ie) {
            Thread.currentThread().interrupt();
            throw new IOException("Exception while updating ledger", ie);
        }
        finally {
            executor.shutdown();
        }
    }

    private static final class ReadLedgerMetadataCb
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> {
        final BookKeeper bkc;
        final Long ledgerId;
        final BookieSocketAddress curBookieAddr;
        final BookieSocketAddress toBookieAddr;
        SettableFuture<Void> future = SettableFuture.create();

        public ReadLedgerMetadataCb(BookKeeper bkc, Long ledgerId, BookieSocketAddress curBookieAddr, BookieSocketAddress toBookieAddr) {
            this.bkc = bkc;
            this.ledgerId = ledgerId;
            this.curBookieAddr = curBookieAddr;
            this.toBookieAddr = toBookieAddr;
        }

        ListenableFuture<Void> getFutureListener() {
            return this.future;
        }

        @Override
        public void operationComplete(int rc, LedgerMetadata metadata) {
            if (-7 == rc) {
                this.future.set(null);
                return;
            }
            if (0 != rc) {
                LOG.error("Get ledger metadata {} failed. Error code {}", (Object)this.ledgerId, (Object)rc);
                this.future.setException((Throwable)BKException.create(rc));
                return;
            }
            boolean updateEnsemble = false;
            for (ArrayList<BookieSocketAddress> ensembles : metadata.getEnsembles().values()) {
                int index = ensembles.indexOf(this.curBookieAddr);
                if (-1 == index) continue;
                ensembles.set(index, this.toBookieAddr);
                updateEnsemble = true;
            }
            if (!updateEnsemble) {
                this.future.set(null);
                return;
            }
            BookkeeperInternalCallbacks.GenericCallback<Void> writeCb = new BookkeeperInternalCallbacks.GenericCallback<Void>(){

                @Override
                public void operationComplete(int rc, Void result) {
                    if (rc != 0) {
                        LOG.error("Ledger {} metadata update failed. Error code {}", (Object)ledgerId, (Object)rc);
                        future.setException((Throwable)BKException.create(rc));
                        return;
                    }
                    future.set(null);
                }
            };
            this.bkc.getLedgerManager().writeLedgerMetadata(this.ledgerId, metadata, writeCb);
        }
    }

    private static final class UpdateLedgerCb
    implements FutureCallback<Void> {
        final long ledgerId;
        final AtomicBoolean stop;
        final AtomicInteger issuedLedgerCnt;
        final AtomicInteger updatedLedgerCnt;
        final Set<Long> outstandings;
        final CountDownLatch syncObj;
        final BookieShell.UpdateLedgerNotifier progressable;

        public UpdateLedgerCb(long ledgerId, AtomicBoolean stop, AtomicInteger issuedLedgerCnt, AtomicInteger updatedLedgerCnt, Set<Long> outstandings, CountDownLatch syncObj, BookieShell.UpdateLedgerNotifier progressable) {
            this.ledgerId = ledgerId;
            this.stop = stop;
            this.issuedLedgerCnt = issuedLedgerCnt;
            this.updatedLedgerCnt = updatedLedgerCnt;
            this.outstandings = outstandings;
            this.syncObj = syncObj;
            this.progressable = progressable;
        }

        public void onFailure(Throwable th) {
            LOG.error("Error updating ledger {}", (Object)this.ledgerId, (Object)th);
            this.stop.set(true);
            this.finishUpdateLedger();
        }

        public void onSuccess(Void obj) {
            this.updatedLedgerCnt.incrementAndGet();
            this.progressable.progress(this.updatedLedgerCnt.get(), this.issuedLedgerCnt.get());
            this.finishUpdateLedger();
        }

        private void finishUpdateLedger() {
            this.outstandings.remove(this.ledgerId);
            if (this.outstandings.isEmpty() && this.stop.get()) {
                LOG.info("Total number of ledgers issued={} updated={}", (Object)this.issuedLedgerCnt.get(), (Object)this.updatedLedgerCnt.get());
                this.syncObj.countDown();
            }
        }
    }
}

