/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public abstract class BKException
extends Exception {
    protected final int code;

    public BKException(int code) {
        super(BKException.getMessage(code));
        this.code = code;
    }

    public final int getCode() {
        return this.code;
    }

    public static String getMessage(int code) {
        switch (code) {
            case 0: {
                return "No problem";
            }
            case -1: {
                return "Error while reading ledger";
            }
            case -2: {
                return "Invalid quorum size on ensemble size";
            }
            case -3: {
                return "Invalid quorum size on ensemble size";
            }
            case -4: {
                return "Digest engine not initialized";
            }
            case -5: {
                return "Entry digest does not match";
            }
            case -6: {
                return "Not enough non-faulty bookies available";
            }
            case -7: {
                return "No such ledger exists";
            }
            case -8: {
                return "Bookie handle is not available";
            }
            case -9: {
                return "Error while using ZooKeeper";
            }
            case -18: {
                return "Error while using MetaStore";
            }
            case -20: {
                return "Ledger existed";
            }
            case -10: {
                return "Error while recovering ledger";
            }
            case -11: {
                return "Attempt to write to a closed ledger";
            }
            case -12: {
                return "Write failed on bookie";
            }
            case -13: {
                return "No such entry";
            }
            case -14: {
                return "Incorrect parameter input";
            }
            case -15: {
                return "Interrupted while waiting for permit";
            }
            case -16: {
                return "Bookie protocol version on server is incompatible with client";
            }
            case -17: {
                return "Bad ledger metadata version";
            }
            case -22: {
                return "Attempted to add Duplicate entryId";
            }
            case -101: {
                return "Ledger has been fenced off. Some other client must have opened it to read";
            }
            case -102: {
                return "Attempted to access ledger using the wrong password";
            }
            case -103: {
                return "Attempting to use an unclosed fragment; This is not safe";
            }
            case -104: {
                return "Attempting to write on ReadOnly bookie";
            }
            case -105: {
                return "Too many requests to the same Bookie";
            }
            case -106: {
                return "Next ledgerID is too large.";
            }
            case -200: {
                return "Errors in replication pipeline";
            }
            case -19: {
                return "BookKeeper client is closed";
            }
            case -100: {
                return "Invalid operation";
            }
            case -21: {
                return "Add entry quorum wait timed out";
            }
            case -23: {
                return "Bookie operation timeout";
            }
            case -24: {
                return "Failed to establish a secure connection";
            }
        }
        return "Unexpected condition";
    }

    public static interface Code {
        public static final int UNINITIALIZED = 1;
        public static final int OK = 0;
        public static final int ReadException = -1;
        public static final int QuorumException = -2;
        public static final int NoBookieAvailableException = -3;
        public static final int DigestNotInitializedException = -4;
        public static final int DigestMatchException = -5;
        public static final int NotEnoughBookiesException = -6;
        public static final int NoSuchLedgerExistsException = -7;
        public static final int BookieHandleNotAvailableException = -8;
        public static final int ZKException = -9;
        public static final int LedgerRecoveryException = -10;
        public static final int LedgerClosedException = -11;
        public static final int WriteException = -12;
        public static final int NoSuchEntryException = -13;
        public static final int IncorrectParameterException = -14;
        public static final int InterruptedException = -15;
        public static final int ProtocolVersionException = -16;
        public static final int MetadataVersionException = -17;
        public static final int MetaStoreException = -18;
        public static final int ClientClosedException = -19;
        public static final int LedgerExistException = -20;
        public static final int AddEntryQuorumTimeoutException = -21;
        public static final int DuplicateEntryIdException = -22;
        public static final int TimeoutException = -23;
        public static final int SecurityException = -24;
        public static final int IllegalOpException = -100;
        public static final int LedgerFencedException = -101;
        public static final int UnauthorizedAccessException = -102;
        public static final int UnclosedFragmentException = -103;
        public static final int WriteOnReadOnlyBookieException = -104;
        public static final int TooManyRequestsException = -105;
        public static final int LedgerIdOverflowException = -106;
        public static final int ReplicationException = -200;
        public static final int UnexpectedConditionException = -999;
    }
}

