/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.conf;

import java.net.URL;
import java.util.Iterator;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.commons.configuration.CompositeConfiguration;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.SystemConfiguration;

public abstract class AbstractConfiguration
extends CompositeConfiguration {
    public static final String READ_SYSTEM_PROPERTIES_PROPERTY = "org.apache.bookkeeper.conf.readsystemproperties";
    private static final boolean READ_SYSTEM_PROPERTIES = Boolean.getBoolean("org.apache.bookkeeper.conf.readsystemproperties");
    protected static final ClassLoader defaultLoader;
    protected static final String LEDGER_MANAGER_TYPE = "ledgerManagerType";
    protected static final String LEDGER_MANAGER_FACTORY_CLASS = "ledgerManagerFactoryClass";
    protected static final String ZK_LEDGERS_ROOT_PATH = "zkLedgersRootPath";
    protected static final String ZK_REQUEST_RATE_LIMIT = "zkRequestRateLimit";
    protected static final String AVAILABLE_NODE = "available";
    protected static final String REREPLICATION_ENTRY_BATCH_SIZE = "rereplicationEntryBatchSize";
    protected static final String METASTORE_IMPL_CLASS = "metastoreImplClass";
    protected static final String METASTORE_MAX_ENTRIES_PER_SCAN = "metastoreMaxEntriesPerScan";
    protected static final String TLS_PROVIDER = "tlsProvider";
    protected static final String TLS_PROVIDER_FACTORY_CLASS = "tlsProviderFactoryClass";
    protected static final String TLS_CLIENT_AUTHENTICATION = "tlsClientAuthentication";
    protected static final String TLS_ENABLED_CIPHER_SUITES = "tlsEnabledCipherSuites";
    protected static final String TLS_ENABLED_PROTOCOLS = "tlsEnabledProtocols";
    protected static final String NETTY_MAX_FRAME_SIZE = "nettyMaxFrameSizeBytes";
    protected static final int DEFAULT_NETTY_MAX_FRAME_SIZE = 0x500000;
    protected static final String ZK_ENABLE_SECURITY = "zkEnableSecurity";
    public static final String LEDGER_MANAGER_FACTORY_DISABLE_CLASS_CHECK = "ledgerManagerFactoryDisableClassCheck";

    protected AbstractConfiguration() {
        if (READ_SYSTEM_PROPERTIES) {
            this.addConfiguration((Configuration)new SystemConfiguration());
        }
    }

    public void loadConf(URL confURL) throws ConfigurationException {
        PropertiesConfiguration loadedConf = new PropertiesConfiguration(confURL);
        Iterator iter = loadedConf.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.setProperty(key, loadedConf.getProperty(key));
        }
    }

    public void loadConf(CompositeConfiguration baseConf) {
        Iterator iter = baseConf.getKeys();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            this.setProperty(key, baseConf.getProperty(key));
        }
    }

    @Deprecated
    public void setLedgerManagerType(String lmType) {
        this.setProperty(LEDGER_MANAGER_TYPE, lmType);
    }

    @Deprecated
    public String getLedgerManagerType() {
        return this.getString(LEDGER_MANAGER_TYPE);
    }

    public void setLedgerManagerFactoryClassName(String factoryClassName) {
        this.setProperty(LEDGER_MANAGER_FACTORY_CLASS, factoryClassName);
    }

    public void setLedgerManagerFactoryClass(Class<? extends LedgerManagerFactory> factoryClass) {
        this.setProperty(LEDGER_MANAGER_FACTORY_CLASS, factoryClass.getName());
    }

    public Class<? extends LedgerManagerFactory> getLedgerManagerFactoryClass() throws ConfigurationException {
        return ReflectionUtils.getClass((Configuration)this, LEDGER_MANAGER_FACTORY_CLASS, null, LedgerManagerFactory.class, defaultLoader);
    }

    public void setZkLedgersRootPath(String zkLedgersPath) {
        this.setProperty(ZK_LEDGERS_ROOT_PATH, zkLedgersPath);
    }

    public String getZkLedgersRootPath() {
        return this.getString(ZK_LEDGERS_ROOT_PATH, "/ledgers");
    }

    public double getZkRequestRateLimit() {
        return this.getDouble(ZK_REQUEST_RATE_LIMIT, 0.0);
    }

    public void setZkRequestRateLimit(double rateLimit) {
        this.setProperty(ZK_REQUEST_RATE_LIMIT, rateLimit);
    }

    public boolean isZkEnableSecurity() {
        return this.getBoolean(ZK_ENABLE_SECURITY, false);
    }

    public void setZkEnableSecurity(boolean zkEnableSecurity) {
        this.setProperty(ZK_ENABLE_SECURITY, zkEnableSecurity);
    }

    public String getZkAvailableBookiesPath() {
        return this.getZkLedgersRootPath() + "/" + AVAILABLE_NODE;
    }

    public void setRereplicationEntryBatchSize(long rereplicationEntryBatchSize) {
        this.setProperty(REREPLICATION_ENTRY_BATCH_SIZE, rereplicationEntryBatchSize);
    }

    public long getRereplicationEntryBatchSize() {
        return this.getLong(REREPLICATION_ENTRY_BATCH_SIZE, 10L);
    }

    public String getMetastoreImplClass() {
        return this.getString(METASTORE_IMPL_CLASS);
    }

    public void setMetastoreImplClass(String metastoreImplClass) {
        this.setProperty(METASTORE_IMPL_CLASS, metastoreImplClass);
    }

    public int getMetastoreMaxEntriesPerScan() {
        return this.getInt(METASTORE_MAX_ENTRIES_PER_SCAN, 50);
    }

    public void setMetastoreMaxEntriesPerScan(int maxEntries) {
        this.setProperty(METASTORE_MAX_ENTRIES_PER_SCAN, maxEntries);
    }

    public void setFeature(String configProperty, Feature feature) {
        this.setProperty(configProperty, feature);
    }

    public Feature getFeature(String configProperty, Feature defaultValue) {
        if (null == this.getProperty(configProperty)) {
            return defaultValue;
        }
        return (Feature)this.getProperty(configProperty);
    }

    public AbstractConfiguration setClientAuthProviderFactoryClass(String factoryClass) {
        this.setProperty("clientAuthProviderFactoryClass", factoryClass);
        return this;
    }

    public String getClientAuthProviderFactoryClass() {
        return this.getString("clientAuthProviderFactoryClass", null);
    }

    public int getNettyMaxFrameSizeBytes() {
        return this.getInt(NETTY_MAX_FRAME_SIZE, 0x500000);
    }

    public AbstractConfiguration setNettyMaxFrameSizeBytes(int maxSize) {
        this.setProperty(NETTY_MAX_FRAME_SIZE, String.valueOf(maxSize));
        return this;
    }

    public String getTLSProviderFactoryClass() {
        return this.getString(TLS_PROVIDER_FACTORY_CLASS, null);
    }

    public AbstractConfiguration setTLSProviderFactoryClass(String factoryClass) {
        this.setProperty(TLS_PROVIDER_FACTORY_CLASS, factoryClass);
        return this;
    }

    public String getTLSProvider() {
        return this.getString(TLS_PROVIDER, "OpenSSL");
    }

    public AbstractConfiguration setTLSProvider(String provider) {
        this.setProperty(TLS_PROVIDER, provider);
        return this;
    }

    public boolean getTLSClientAuthentication() {
        return this.getBoolean(TLS_CLIENT_AUTHENTICATION, false);
    }

    public AbstractConfiguration setTLSClientAuthentication(boolean enabled) {
        this.setProperty(TLS_CLIENT_AUTHENTICATION, enabled);
        return this;
    }

    public AbstractConfiguration setTLSEnabledCipherSuites(String list) {
        this.setProperty(TLS_ENABLED_CIPHER_SUITES, list);
        return this;
    }

    public String getTLSEnabledCipherSuites() {
        return this.getString(TLS_ENABLED_CIPHER_SUITES, null);
    }

    public AbstractConfiguration setTLSEnabledProtocols(String list) {
        this.setProperty(TLS_ENABLED_PROTOCOLS, list);
        return this;
    }

    public String getTLSEnabledProtocols() {
        return this.getString(TLS_ENABLED_PROTOCOLS, null);
    }

    static {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (null == loader) {
            loader = AbstractConfiguration.class.getClassLoader();
        }
        defaultLoader = loader;
    }
}

