/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.versioning.Versioned;
import org.apache.zookeeper.ZooKeeper;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public interface RegistrationClient
extends AutoCloseable {
    public RegistrationClient initialize(ClientConfiguration var1, ScheduledExecutorService var2, StatsLogger var3, Optional<ZooKeeper> var4) throws BKException;

    @Override
    public void close();

    public CompletableFuture<Versioned<Set<BookieSocketAddress>>> getWritableBookies();

    public CompletableFuture<Versioned<Set<BookieSocketAddress>>> getReadOnlyBookies();

    public CompletableFuture<Void> watchWritableBookies(RegistrationListener var1);

    public void unwatchWritableBookies(RegistrationListener var1);

    public CompletableFuture<Void> watchReadOnlyBookies(RegistrationListener var1);

    public void unwatchReadOnlyBookies(RegistrationListener var1);

    public static interface RegistrationListener {
        public void onBookiesChanged(Versioned<Set<BookieSocketAddress>> var1);
    }
}

