/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.discover;

import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.versioning.Version;
import org.apache.bookkeeper.versioning.Versioned;

@InterfaceAudience.LimitedPrivate
@InterfaceStability.Evolving
public interface RegistrationManager
extends AutoCloseable {
    public RegistrationManager initialize(ServerConfiguration var1, RegistrationListener var2, StatsLogger var3) throws BookieException;

    @Override
    public void close();

    public String getClusterInstanceId() throws BookieException;

    public void registerBookie(String var1, boolean var2) throws BookieException;

    public void unregisterBookie(String var1, boolean var2) throws BookieException;

    public void writeCookie(String var1, Versioned<byte[]> var2) throws BookieException;

    public Versioned<byte[]> readCookie(String var1) throws BookieException;

    public void removeCookie(String var1, Version var2) throws BookieException;

    @FunctionalInterface
    public static interface RegistrationListener {
        public void onRegistrationExpired();
    }
}

