/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.base.Charsets;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ExtensionRegistry;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Recycler;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.auth.AuthProviderFactoryFactory;
import org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.DefaultPerChannelBookieClientPool;
import org.apache.bookkeeper.proto.PerChannelBookieClient;
import org.apache.bookkeeper.proto.PerChannelBookieClientFactory;
import org.apache.bookkeeper.proto.PerChannelBookieClientPool;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieClient
implements PerChannelBookieClientFactory {
    static final Logger LOG = LoggerFactory.getLogger(BookieClient.class);
    AtomicLong totalBytesOutstanding = new AtomicLong();
    OrderedSafeExecutor executor;
    EventLoopGroup eventLoopGroup;
    final ConcurrentHashMap<BookieSocketAddress, PerChannelBookieClientPool> channels = new ConcurrentHashMap();
    final HashedWheelTimer requestTimer;
    private final ClientAuthProvider.Factory authProviderFactory;
    private final ExtensionRegistry registry;
    private final ClientConfiguration conf;
    private volatile boolean closed;
    private final ReentrantReadWriteLock closeLock;
    private final StatsLogger statsLogger;
    private final int numConnectionsPerBookie;
    private final long bookieErrorThresholdPerInterval;

    public BookieClient(ClientConfiguration conf, EventLoopGroup eventLoopGroup, OrderedSafeExecutor executor) throws IOException {
        this(conf, eventLoopGroup, executor, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public BookieClient(ClientConfiguration conf, EventLoopGroup eventLoopGroup, OrderedSafeExecutor executor, StatsLogger statsLogger) throws IOException {
        this.conf = conf;
        this.eventLoopGroup = eventLoopGroup;
        this.executor = executor;
        this.closed = false;
        this.closeLock = new ReentrantReadWriteLock();
        this.registry = ExtensionRegistry.newInstance();
        this.authProviderFactory = AuthProviderFactoryFactory.newClientAuthProviderFactory(conf);
        this.statsLogger = statsLogger;
        this.numConnectionsPerBookie = conf.getNumChannelsPerBookie();
        this.requestTimer = new HashedWheelTimer(new ThreadFactoryBuilder().setNameFormat("BookieClientTimer-%d").build(), conf.getPCBCTimeoutTimerTickDurationMs(), TimeUnit.MILLISECONDS, conf.getPCBCTimeoutTimerNumTicks());
        this.bookieErrorThresholdPerInterval = conf.getBookieErrorThresholdPerInterval();
    }

    private int getRc(int rc) {
        if (0 == rc) {
            return rc;
        }
        if (this.closed) {
            return -19;
        }
        return rc;
    }

    public List<BookieSocketAddress> getFaultyBookies() {
        ArrayList faultyBookies = Lists.newArrayList();
        for (PerChannelBookieClientPool channelPool : this.channels.values()) {
            if (!(channelPool instanceof DefaultPerChannelBookieClientPool)) continue;
            DefaultPerChannelBookieClientPool pool = (DefaultPerChannelBookieClientPool)channelPool;
            if (pool.errorCounter.getAndSet(0L) < this.bookieErrorThresholdPerInterval) continue;
            faultyBookies.add(pool.address);
        }
        return faultyBookies;
    }

    @Override
    public PerChannelBookieClient create(BookieSocketAddress address, PerChannelBookieClientPool pcbcPool, SecurityHandlerFactory shFactory) throws SecurityException {
        return new PerChannelBookieClient(this.conf, this.executor, this.eventLoopGroup, address, this.requestTimer, this.statsLogger, this.authProviderFactory, this.registry, pcbcPool, shFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PerChannelBookieClientPool lookupClient(BookieSocketAddress addr) {
        PerChannelBookieClientPool clientPool = this.channels.get(addr);
        if (null == clientPool) {
            this.closeLock.readLock().lock();
            try {
                if (this.closed) {
                    PerChannelBookieClientPool perChannelBookieClientPool = null;
                    return perChannelBookieClientPool;
                }
                DefaultPerChannelBookieClientPool newClientPool = new DefaultPerChannelBookieClientPool(this.conf, this, addr, this.numConnectionsPerBookie);
                PerChannelBookieClientPool oldClientPool = this.channels.putIfAbsent(addr, newClientPool);
                if (null == oldClientPool) {
                    clientPool = newClientPool;
                    clientPool.intialize();
                } else {
                    clientPool = oldClientPool;
                    newClientPool.close(false);
                }
            }
            catch (SecurityException e) {
                LOG.error("Security Exception in creating new default PCBC pool: ", (Throwable)e);
                PerChannelBookieClientPool perChannelBookieClientPool = null;
                return perChannelBookieClientPool;
            }
            finally {
                this.closeLock.readLock().unlock();
            }
        }
        return clientPool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeLac(final BookieSocketAddress addr, final long ledgerId, final byte[] masterKey, final long lac, final ByteBuf toSend, final BookkeeperInternalCallbacks.WriteLacCallback cb, final Object ctx) {
        this.closeLock.readLock().lock();
        try {
            PerChannelBookieClientPool client = this.lookupClient(addr);
            if (client == null) {
                cb.writeLacComplete(this.getRc(-8), ledgerId, addr, ctx);
                return;
            }
            toSend.retain();
            client.obtain(new BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>(){

                @Override
                public void operationComplete(final int rc, PerChannelBookieClient pcbc) {
                    if (rc != 0) {
                        try {
                            BookieClient.this.executor.submitOrdered(ledgerId, new SafeRunnable(){

                                public void safeRun() {
                                    cb.writeLacComplete(rc, ledgerId, addr, ctx);
                                }
                            });
                        }
                        catch (RejectedExecutionException re) {
                            cb.writeLacComplete(BookieClient.this.getRc(-15), ledgerId, addr, ctx);
                        }
                    } else {
                        pcbc.writeLac(ledgerId, masterKey, lac, toSend, cb, ctx);
                    }
                    toSend.release();
                }
            }, ledgerId);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private void completeAdd(final int rc, final long ledgerId, final long entryId, final BookieSocketAddress addr, final BookkeeperInternalCallbacks.WriteCallback cb, final Object ctx) {
        try {
            this.executor.submitOrdered(ledgerId, new SafeRunnable(){

                public void safeRun() {
                    cb.writeComplete(rc, ledgerId, entryId, addr, ctx);
                }

                public String toString() {
                    return String.format("CompleteWrite(ledgerId=%d, entryId=%d, addr=%s)", ledgerId, entryId, addr);
                }
            });
        }
        catch (RejectedExecutionException ree) {
            cb.writeComplete(this.getRc(-15), ledgerId, entryId, addr, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addEntry(BookieSocketAddress addr, long ledgerId, byte[] masterKey, long entryId, ByteBuf toSend, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, int options) {
        this.closeLock.readLock().lock();
        try {
            PerChannelBookieClientPool client = this.lookupClient(addr);
            if (client == null) {
                this.completeAdd(this.getRc(-8), ledgerId, entryId, addr, cb, ctx);
                return;
            }
            toSend.retain();
            client.obtain(ChannelReadyForAddEntryCallback.create(this, toSend, ledgerId, entryId, addr, ctx, cb, options, masterKey), ledgerId);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    private void completeRead(final int rc, final long ledgerId, final long entryId, final ByteBuf entry, final BookkeeperInternalCallbacks.ReadEntryCallback cb, final Object ctx) {
        try {
            this.executor.submitOrdered(ledgerId, new SafeRunnable(){

                public void safeRun() {
                    cb.readEntryComplete(rc, ledgerId, entryId, entry, ctx);
                }
            });
        }
        catch (RejectedExecutionException ree) {
            cb.readEntryComplete(this.getRc(-15), ledgerId, entryId, entry, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readEntryAndFenceLedger(BookieSocketAddress addr, final long ledgerId, final byte[] masterKey, final long entryId, final BookkeeperInternalCallbacks.ReadEntryCallback cb, final Object ctx) {
        this.closeLock.readLock().lock();
        try {
            PerChannelBookieClientPool client = this.lookupClient(addr);
            if (client == null) {
                this.completeRead(this.getRc(-8), ledgerId, entryId, null, cb, ctx);
                return;
            }
            client.obtain(new BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>(){

                @Override
                public void operationComplete(int rc, PerChannelBookieClient pcbc) {
                    if (rc != 0) {
                        BookieClient.this.completeRead(rc, ledgerId, entryId, null, cb, ctx);
                        return;
                    }
                    pcbc.readEntryAndFenceLedger(ledgerId, masterKey, entryId, cb, ctx);
                }
            }, ledgerId);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readLac(BookieSocketAddress addr, final long ledgerId, final BookkeeperInternalCallbacks.ReadLacCallback cb, final Object ctx) {
        this.closeLock.readLock().lock();
        try {
            PerChannelBookieClientPool client = this.lookupClient(addr);
            if (client == null) {
                cb.readLacComplete(this.getRc(-8), ledgerId, null, null, ctx);
                return;
            }
            client.obtain(new BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>(){

                @Override
                public void operationComplete(final int rc, PerChannelBookieClient pcbc) {
                    if (rc != 0) {
                        try {
                            BookieClient.this.executor.submitOrdered(ledgerId, new SafeRunnable(){

                                public void safeRun() {
                                    cb.readLacComplete(rc, ledgerId, null, null, ctx);
                                }
                            });
                        }
                        catch (RejectedExecutionException re) {
                            cb.readLacComplete(BookieClient.this.getRc(-15), ledgerId, null, null, ctx);
                        }
                        return;
                    }
                    pcbc.readLac(ledgerId, cb, ctx);
                }
            }, ledgerId);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readEntry(BookieSocketAddress addr, final long ledgerId, final long entryId, final BookkeeperInternalCallbacks.ReadEntryCallback cb, final Object ctx) {
        this.closeLock.readLock().lock();
        try {
            PerChannelBookieClientPool client = this.lookupClient(addr);
            if (client == null) {
                cb.readEntryComplete(this.getRc(-8), ledgerId, entryId, null, ctx);
                return;
            }
            client.obtain(new BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>(){

                @Override
                public void operationComplete(int rc, PerChannelBookieClient pcbc) {
                    if (rc != 0) {
                        BookieClient.this.completeRead(rc, ledgerId, entryId, null, cb, ctx);
                        return;
                    }
                    pcbc.readEntry(ledgerId, entryId, cb, ctx);
                }
            }, ledgerId);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readEntryWaitForLACUpdate(BookieSocketAddress addr, final long ledgerId, final long entryId, final long previousLAC, final long timeOutInMillis, final boolean piggyBackEntry, final BookkeeperInternalCallbacks.ReadEntryCallback cb, final Object ctx) {
        this.closeLock.readLock().lock();
        try {
            PerChannelBookieClientPool client = this.lookupClient(addr);
            if (client == null) {
                this.completeRead(-8, ledgerId, entryId, null, cb, ctx);
                return;
            }
            client.obtain(new BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>(){

                @Override
                public void operationComplete(int rc, PerChannelBookieClient pcbc) {
                    if (rc != 0) {
                        BookieClient.this.completeRead(rc, ledgerId, entryId, null, cb, ctx);
                        return;
                    }
                    pcbc.readEntryWaitForLACUpdate(ledgerId, entryId, previousLAC, timeOutInMillis, piggyBackEntry, cb, ctx);
                }
            }, ledgerId);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getBookieInfo(BookieSocketAddress addr, final long requested, final BookkeeperInternalCallbacks.GetBookieInfoCallback cb, final Object ctx) {
        this.closeLock.readLock().lock();
        try {
            PerChannelBookieClientPool client = this.lookupClient(addr);
            if (client == null) {
                cb.getBookieInfoComplete(this.getRc(-8), new BookieInfoReader.BookieInfo(), ctx);
                return;
            }
            client.obtain(new BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>(){

                @Override
                public void operationComplete(final int rc, PerChannelBookieClient pcbc) {
                    if (rc != 0) {
                        try {
                            BookieClient.this.executor.submit(new SafeRunnable(){

                                public void safeRun() {
                                    cb.getBookieInfoComplete(rc, new BookieInfoReader.BookieInfo(), ctx);
                                }
                            });
                        }
                        catch (RejectedExecutionException re) {
                            cb.getBookieInfoComplete(BookieClient.this.getRc(-15), new BookieInfoReader.BookieInfo(), ctx);
                        }
                        return;
                    }
                    pcbc.getBookieInfo(requested, cb, ctx);
                }
            }, requested);
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Timeout scheduleTimeout(TimerTask task, long timeoutSec, TimeUnit timeUnit) {
        return this.requestTimer.newTimeout(task, timeoutSec, timeUnit);
    }

    public void close() {
        this.closeLock.writeLock().lock();
        try {
            this.closed = true;
            for (PerChannelBookieClientPool pool : this.channels.values()) {
                pool.close(true);
            }
            this.channels.clear();
            this.authProviderFactory.close();
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.requestTimer.stop();
    }

    public static void main(String[] args) throws NumberFormatException, IOException, InterruptedException {
        if (args.length != 3) {
            System.err.println("USAGE: BookieClient bookieHost port ledger#");
            return;
        }
        BookkeeperInternalCallbacks.WriteCallback cb = new BookkeeperInternalCallbacks.WriteCallback(){

            @Override
            public void writeComplete(int rc, long ledger, long entry, BookieSocketAddress addr, Object ctx) {
                Counter counter = (Counter)ctx;
                counter.dec();
                if (rc != 0) {
                    System.out.println("rc = " + rc + " for " + entry + "@" + ledger);
                }
            }
        };
        Counter counter = new Counter();
        byte[] hello = "hello".getBytes(Charsets.UTF_8);
        long ledger = Long.parseLong(args[2]);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(1);
        OrderedSafeExecutor executor = (OrderedSafeExecutor)OrderedSafeExecutor.newBuilder().name("BookieClientWorker").numThreads(1).build();
        BookieClient bc = new BookieClient(new ClientConfiguration(), (EventLoopGroup)eventLoopGroup, executor);
        BookieSocketAddress addr = new BookieSocketAddress(args[0], Integer.parseInt(args[1]));
        for (int i = 0; i < 100000; ++i) {
            counter.inc();
            bc.addEntry(addr, ledger, new byte[0], i, Unpooled.wrappedBuffer((byte[])hello), cb, counter, 0);
        }
        counter.wait(0);
        System.out.println("Total = " + counter.total());
        eventLoopGroup.shutdownGracefully();
        executor.shutdown();
    }

    private static class Counter {
        int i;
        int total;

        private Counter() {
        }

        synchronized void inc() {
            ++this.i;
            ++this.total;
        }

        synchronized void dec() {
            --this.i;
            this.notifyAll();
        }

        synchronized void wait(int limit) throws InterruptedException {
            while (this.i > limit) {
                this.wait();
            }
        }

        synchronized int total() {
            return this.total;
        }
    }

    private static class ChannelReadyForAddEntryCallback
    implements BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> {
        private final Recycler.Handle<ChannelReadyForAddEntryCallback> recyclerHandle;
        private BookieClient bookieClient;
        private ByteBuf toSend;
        private long ledgerId;
        private long entryId;
        private BookieSocketAddress addr;
        private Object ctx;
        private BookkeeperInternalCallbacks.WriteCallback cb;
        private int options;
        private byte[] masterKey;
        private static final Recycler<ChannelReadyForAddEntryCallback> RECYCLER = new Recycler<ChannelReadyForAddEntryCallback>(){

            protected ChannelReadyForAddEntryCallback newObject(Recycler.Handle<ChannelReadyForAddEntryCallback> recyclerHandle) {
                return new ChannelReadyForAddEntryCallback(recyclerHandle);
            }
        };

        static ChannelReadyForAddEntryCallback create(BookieClient bookieClient, ByteBuf toSend, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx, BookkeeperInternalCallbacks.WriteCallback cb, int options, byte[] masterKey) {
            ChannelReadyForAddEntryCallback callback = (ChannelReadyForAddEntryCallback)RECYCLER.get();
            callback.bookieClient = bookieClient;
            callback.toSend = toSend;
            callback.ledgerId = ledgerId;
            callback.entryId = entryId;
            callback.addr = addr;
            callback.ctx = ctx;
            callback.cb = cb;
            callback.options = options;
            callback.masterKey = masterKey;
            return callback;
        }

        @Override
        public void operationComplete(int rc, PerChannelBookieClient pcbc) {
            if (rc != 0) {
                this.bookieClient.completeAdd(rc, this.ledgerId, this.entryId, this.addr, this.cb, this.ctx);
            } else {
                pcbc.addEntry(this.ledgerId, this.masterKey, this.entryId, this.toSend, this.cb, this.ctx, this.options);
            }
            this.toSend.release();
            this.recycle();
        }

        private ChannelReadyForAddEntryCallback(Recycler.Handle<ChannelReadyForAddEntryCallback> recyclerHandle) {
            this.recyclerHandle = recyclerHandle;
        }

        public void recycle() {
            this.recyclerHandle.recycle((Object)this);
        }
    }
}

