/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistry;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.MessageToMessageEncoder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.List;
import org.apache.bookkeeper.client.MacDigestManager;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.ServerStats;
import org.apache.bookkeeper.util.DoubleByteBuf;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieProtoEncoding {
    private static final Logger LOG = LoggerFactory.getLogger(BookieProtoEncoding.class);

    private static ByteBuf serializeProtobuf(MessageLite msg, ByteBufAllocator allocator) {
        int size = msg.getSerializedSize();
        ByteBuf buf = allocator.heapBuffer(size, size);
        try {
            msg.writeTo(CodedOutputStream.newInstance((byte[])buf.array(), (int)(buf.arrayOffset() + buf.writerIndex()), (int)size));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        buf.writerIndex(buf.capacity());
        return buf;
    }

    @ChannelHandler.Sharable
    public static class ResponseDecoder
    extends MessageToMessageDecoder<Object> {
        final EnDecoder REP_PREV3;
        final EnDecoder REP_V3;
        boolean usingV3Protocol;

        ResponseDecoder(ExtensionRegistry extensionRegistry) {
            this.REP_PREV3 = new ResponseEnDeCoderPreV3(extensionRegistry);
            this.REP_V3 = new ResponseEnDecoderV3(extensionRegistry);
            this.usingV3Protocol = true;
        }

        protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received response {} from channel {} to decode.", msg, (Object)ctx.channel());
            }
            if (!(msg instanceof ByteBuf)) {
                out.add(msg);
            }
            ByteBuf buffer = (ByteBuf)msg;
            buffer.markReaderIndex();
            if (this.usingV3Protocol) {
                try {
                    out.add(this.REP_V3.decode(buffer));
                }
                catch (InvalidProtocolBufferException e) {
                    this.usingV3Protocol = false;
                    buffer.resetReaderIndex();
                    out.add(this.REP_PREV3.decode(buffer));
                }
            } else {
                out.add(this.REP_PREV3.decode(buffer));
            }
        }
    }

    @ChannelHandler.Sharable
    public static class ResponseEncoder
    extends MessageToMessageEncoder<Object> {
        final EnDecoder REP_PREV3;
        final EnDecoder REP_V3;

        ResponseEncoder(ExtensionRegistry extensionRegistry) {
            this.REP_PREV3 = new ResponseEnDeCoderPreV3(extensionRegistry);
            this.REP_V3 = new ResponseEnDecoderV3(extensionRegistry);
        }

        protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Encode response {} to channel {}.", msg, (Object)ctx.channel());
            }
            if (msg instanceof BookkeeperProtocol.Response) {
                out.add(this.REP_V3.encode(msg, ctx.alloc()));
            } else if (msg instanceof BookieProtocol.Response) {
                out.add(this.REP_PREV3.encode(msg, ctx.alloc()));
            } else {
                LOG.error("Invalid response to encode to {}: {}", (Object)ctx.channel(), (Object)msg.getClass().getName());
                out.add(msg);
            }
        }
    }

    @ChannelHandler.Sharable
    public static class RequestDecoder
    extends MessageToMessageDecoder<Object> {
        final EnDecoder REQ_PREV3;
        final EnDecoder REQ_V3;
        boolean usingV3Protocol;

        RequestDecoder(ExtensionRegistry extensionRegistry) {
            this.REQ_PREV3 = new RequestEnDeCoderPreV3(extensionRegistry);
            this.REQ_V3 = new RequestEnDecoderV3(extensionRegistry);
            this.usingV3Protocol = true;
        }

        protected void decode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Received request {} from channel {} to decode.", msg, (Object)ctx.channel());
            }
            if (!(msg instanceof ByteBuf)) {
                out.add(msg);
                return;
            }
            ByteBuf buffer = (ByteBuf)msg;
            buffer.markReaderIndex();
            if (this.usingV3Protocol) {
                try {
                    out.add(this.REQ_V3.decode(buffer));
                }
                catch (InvalidProtocolBufferException e) {
                    this.usingV3Protocol = false;
                    buffer.resetReaderIndex();
                    out.add(this.REQ_PREV3.decode(buffer));
                }
            } else {
                out.add(this.REQ_PREV3.decode(buffer));
            }
        }
    }

    @ChannelHandler.Sharable
    public static class RequestEncoder
    extends MessageToMessageEncoder<Object> {
        final EnDecoder REQ_PREV3;
        final EnDecoder REQ_V3;

        public RequestEncoder(ExtensionRegistry extensionRegistry) {
            this.REQ_PREV3 = new RequestEnDeCoderPreV3(extensionRegistry);
            this.REQ_V3 = new RequestEnDecoderV3(extensionRegistry);
        }

        protected void encode(ChannelHandlerContext ctx, Object msg, List<Object> out) throws Exception {
            if (msg instanceof BookkeeperProtocol.Request) {
                out.add(this.REQ_V3.encode(msg, ctx.alloc()));
            } else if (msg instanceof BookieProtocol.Request) {
                out.add(this.REQ_PREV3.encode(msg, ctx.alloc()));
            } else {
                LOG.error("Invalid request to encode to {}: {}", (Object)ctx.channel(), (Object)msg.getClass().getName());
                out.add(msg);
            }
        }
    }

    public static class ResponseEnDecoderV3
    implements EnDecoder {
        final ExtensionRegistry extensionRegistry;

        public ResponseEnDecoderV3(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
        }

        @Override
        public Object decode(ByteBuf packet) throws Exception {
            return BookkeeperProtocol.Response.parseFrom((InputStream)new ByteBufInputStream(packet), (ExtensionRegistryLite)this.extensionRegistry);
        }

        @Override
        public Object encode(Object msg, ByteBufAllocator allocator) throws Exception {
            BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)msg;
            return BookieProtoEncoding.serializeProtobuf((MessageLite)response, allocator);
        }
    }

    public static class RequestEnDecoderV3
    implements EnDecoder {
        final ExtensionRegistry extensionRegistry;

        public RequestEnDecoderV3(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
        }

        @Override
        public Object decode(ByteBuf packet) throws Exception {
            return BookkeeperProtocol.Request.parseFrom((InputStream)new ByteBufInputStream(packet), (ExtensionRegistryLite)this.extensionRegistry);
        }

        @Override
        public Object encode(Object msg, ByteBufAllocator allocator) throws Exception {
            BookkeeperProtocol.Request request = (BookkeeperProtocol.Request)msg;
            return BookieProtoEncoding.serializeProtobuf((MessageLite)request, allocator);
        }
    }

    public static class ResponseEnDeCoderPreV3
    implements EnDecoder {
        final ExtensionRegistry extensionRegistry;

        public ResponseEnDeCoderPreV3(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object encode(Object msg, ByteBufAllocator allocator) throws Exception {
            if (!(msg instanceof BookieProtocol.Response)) {
                return msg;
            }
            BookieProtocol.Response r = (BookieProtocol.Response)msg;
            ByteBuf buf = allocator.buffer(24);
            buf.writeInt(BookieProtocol.PacketHeader.toInt(r.getProtocolVersion(), r.getOpCode(), (short)0));
            ServerStats.getInstance().incrementPacketsSent();
            try {
                if (msg instanceof BookieProtocol.ReadResponse) {
                    buf.writeInt(r.getErrorCode());
                    buf.writeLong(r.getLedgerId());
                    buf.writeLong(r.getEntryId());
                    BookieProtocol.ReadResponse rr = (BookieProtocol.ReadResponse)r;
                    if (rr.hasData()) {
                        ByteBuf byteBuf = DoubleByteBuf.get(buf, rr.getData());
                        return byteBuf;
                    }
                    ByteBuf byteBuf = buf;
                    return byteBuf;
                }
                if (msg instanceof BookieProtocol.AddResponse) {
                    buf.writeInt(r.getErrorCode());
                    buf.writeLong(r.getLedgerId());
                    buf.writeLong(r.getEntryId());
                    ByteBuf rr = buf;
                    return rr;
                }
                if (msg instanceof BookieProtocol.AuthResponse) {
                    BookkeeperProtocol.AuthMessage am = ((BookieProtocol.AuthResponse)r).getAuthMessage();
                    ByteBuf byteBuf = DoubleByteBuf.get(buf, Unpooled.wrappedBuffer((byte[])am.toByteArray()));
                    return byteBuf;
                }
                LOG.error("Cannot encode unknown response type {}", (Object)msg.getClass().getName());
                Object object = msg;
                return object;
            }
            finally {
                r.recycle();
            }
        }

        @Override
        public Object decode(ByteBuf buffer) throws Exception {
            int packetHeader = buffer.readInt();
            byte version = BookieProtocol.PacketHeader.getVersion(packetHeader);
            byte opCode = BookieProtocol.PacketHeader.getOpCode(packetHeader);
            switch (opCode) {
                case 1: {
                    int rc = buffer.readInt();
                    long ledgerId = buffer.readLong();
                    long entryId = buffer.readLong();
                    return BookieProtocol.AddResponse.create(version, rc, ledgerId, entryId);
                }
                case 2: {
                    int rc = buffer.readInt();
                    long ledgerId = buffer.readLong();
                    long entryId = buffer.readLong();
                    if (rc == 0) {
                        return new BookieProtocol.ReadResponse(version, rc, ledgerId, entryId, buffer.retainedSlice());
                    }
                    return new BookieProtocol.ReadResponse(version, rc, ledgerId, entryId);
                }
                case 3: {
                    ByteBufInputStream bufStream = new ByteBufInputStream(buffer);
                    BookkeeperProtocol.AuthMessage.Builder builder = BookkeeperProtocol.AuthMessage.newBuilder();
                    builder.mergeFrom((InputStream)bufStream, (ExtensionRegistryLite)this.extensionRegistry);
                    BookkeeperProtocol.AuthMessage am = builder.build();
                    return new BookieProtocol.AuthResponse(version, am);
                }
            }
            throw new IllegalStateException("Received unknown response : op code = " + opCode);
        }
    }

    public static class RequestEnDeCoderPreV3
    implements EnDecoder {
        final ExtensionRegistry extensionRegistry;
        private static final byte[] emptyPasswordMasterKey;

        public RequestEnDeCoderPreV3(ExtensionRegistry extensionRegistry) {
            this.extensionRegistry = extensionRegistry;
        }

        @Override
        public Object encode(Object msg, ByteBufAllocator allocator) throws Exception {
            if (!(msg instanceof BookieProtocol.Request)) {
                return msg;
            }
            BookieProtocol.Request r = (BookieProtocol.Request)msg;
            if (r instanceof BookieProtocol.AddRequest) {
                BookieProtocol.AddRequest ar = (BookieProtocol.AddRequest)r;
                int totalHeaderSize = 24;
                ByteBuf buf = allocator.buffer(totalHeaderSize);
                buf.writeInt(BookieProtocol.PacketHeader.toInt(r.getProtocolVersion(), r.getOpCode(), r.getFlags()));
                buf.writeBytes(r.getMasterKey(), 0, 20);
                ByteBuf data = ar.getData();
                ar.recycle();
                return DoubleByteBuf.get(buf, data);
            }
            if (r instanceof BookieProtocol.ReadRequest) {
                int totalHeaderSize = 20;
                if (r.hasMasterKey()) {
                    totalHeaderSize += 20;
                }
                ByteBuf buf = allocator.buffer(totalHeaderSize);
                buf.writeInt(BookieProtocol.PacketHeader.toInt(r.getProtocolVersion(), r.getOpCode(), r.getFlags()));
                buf.writeLong(r.getLedgerId());
                buf.writeLong(r.getEntryId());
                if (r.hasMasterKey()) {
                    buf.writeBytes(r.getMasterKey(), 0, 20);
                }
                return buf;
            }
            if (r instanceof BookieProtocol.AuthRequest) {
                BookkeeperProtocol.AuthMessage am = ((BookieProtocol.AuthRequest)r).getAuthMessage();
                int totalHeaderSize = 4;
                int totalSize = totalHeaderSize + am.getSerializedSize();
                ByteBuf buf = allocator.buffer(totalSize);
                buf.writeInt(BookieProtocol.PacketHeader.toInt(r.getProtocolVersion(), r.getOpCode(), r.getFlags()));
                ByteBufOutputStream bufStream = new ByteBufOutputStream(buf);
                am.writeTo((OutputStream)bufStream);
                return buf;
            }
            return msg;
        }

        @Override
        public Object decode(ByteBuf packet) throws Exception {
            int packetHeader = packet.readInt();
            byte version = BookieProtocol.PacketHeader.getVersion(packetHeader);
            byte opCode = BookieProtocol.PacketHeader.getOpCode(packetHeader);
            short flags = BookieProtocol.PacketHeader.getFlags(packetHeader);
            long ledgerId = -1L;
            long entryId = -1L;
            ServerStats.getInstance().incrementPacketsReceived();
            switch (opCode) {
                case 1: {
                    byte[] masterKey = RequestEnDeCoderPreV3.readMasterKey(packet);
                    ledgerId = packet.getLong(packet.readerIndex());
                    entryId = packet.getLong(packet.readerIndex() + 8);
                    return BookieProtocol.AddRequest.create(version, ledgerId, entryId, flags, masterKey, packet.retain());
                }
                case 2: {
                    ledgerId = packet.readLong();
                    entryId = packet.readLong();
                    if ((flags & 1) == 1 && version >= 2) {
                        byte[] masterKey = RequestEnDeCoderPreV3.readMasterKey(packet);
                        return new BookieProtocol.ReadRequest(version, ledgerId, entryId, flags, masterKey);
                    }
                    return new BookieProtocol.ReadRequest(version, ledgerId, entryId, flags);
                }
                case 3: {
                    BookkeeperProtocol.AuthMessage.Builder builder = BookkeeperProtocol.AuthMessage.newBuilder();
                    builder.mergeFrom((InputStream)new ByteBufInputStream(packet), (ExtensionRegistryLite)this.extensionRegistry);
                    return new BookieProtocol.AuthRequest(version, builder.build());
                }
            }
            return packet;
        }

        private static byte[] readMasterKey(ByteBuf packet) {
            byte[] masterKey = null;
            boolean isEmptyKey = true;
            for (int i = 0; i < 20; ++i) {
                if (packet.getByte(packet.readerIndex() + i) == emptyPasswordMasterKey[i]) continue;
                isEmptyKey = false;
                break;
            }
            if (isEmptyKey) {
                masterKey = emptyPasswordMasterKey;
                packet.readerIndex(packet.readerIndex() + 20);
            } else {
                masterKey = new byte[20];
                packet.readBytes(masterKey, 0, 20);
            }
            return masterKey;
        }

        static {
            try {
                emptyPasswordMasterKey = MacDigestManager.genDigest("ledger", new byte[0]);
            }
            catch (NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static interface EnDecoder {
        public Object encode(Object var1, ByteBufAllocator var2) throws Exception;

        public Object decode(ByteBuf var1) throws Exception;
    }
}

