/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.channel.Channel;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class PacketProcessorBase
extends SafeRunnable {
    private static final Logger logger = LoggerFactory.getLogger(PacketProcessorBase.class);
    BookieProtocol.Request request;
    Channel channel;
    BookieRequestProcessor requestProcessor;
    long enqueueNanos;

    PacketProcessorBase() {
    }

    protected void init(BookieProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        this.request = request;
        this.channel = channel;
        this.requestProcessor = requestProcessor;
        this.enqueueNanos = MathUtils.nowInNano();
    }

    protected void reset() {
        this.request = null;
        this.channel = null;
        this.requestProcessor = null;
        this.enqueueNanos = -1L;
    }

    protected boolean isVersionCompatible() {
        byte version = this.request.getProtocolVersion();
        if (version < 0 || version > 2) {
            logger.error("Invalid protocol version, expected something between 0 & 2. got " + this.request.getProtocolVersion());
            return false;
        }
        return true;
    }

    protected void sendResponse(int rc, Object response, OpStatsLogger statsLogger) {
        this.channel.writeAndFlush(response, this.channel.voidPromise());
        if (0 == rc) {
            statsLogger.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
        } else {
            statsLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.enqueueNanos), TimeUnit.NANOSECONDS);
        }
    }

    public void safeRun() {
        if (!this.isVersionCompatible()) {
            this.sendResponse(103, ResponseBuilder.buildErrorResponse(103, this.request), this.requestProcessor.readRequestStats);
            return;
        }
        this.processPacket();
    }

    protected abstract void processPacket();
}

