/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.base.Joiner;
import com.google.common.collect.Sets;
import com.google.protobuf.ByteString;
import com.google.protobuf.ExtensionRegistry;
import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.WriteBufferWaterMark;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.handler.codec.LengthFieldPrepender;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.ssl.SslHandler;
import io.netty.util.HashedWheelTimer;
import io.netty.util.Recycler;
import io.netty.util.Timeout;
import io.netty.util.TimerTask;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.security.cert.Certificate;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.bookkeeper.auth.BookKeeperPrincipal;
import org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.bookkeeper.client.BookieInfoReader;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.AuthHandler;
import org.apache.bookkeeper.proto.BookieProtoEncoding;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.ClientConnectionPeer;
import org.apache.bookkeeper.proto.LocalBookiesRegistry;
import org.apache.bookkeeper.proto.PerChannelBookieClientPool;
import org.apache.bookkeeper.proto.ReadLastConfirmedAndEntryContext;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.bookkeeper.util.MathUtils;
import org.apache.bookkeeper.util.OrderedSafeExecutor;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ChannelHandler.Sharable
public class PerChannelBookieClient
extends ChannelInboundHandlerAdapter {
    static final Logger LOG = LoggerFactory.getLogger(PerChannelBookieClient.class);
    private static final Set<Integer> expectedBkOperationErrors = Collections.unmodifiableSet(Sets.newHashSet((Object[])new Integer[]{-8, -13, -7, -101, -20, -22, -104}));
    public static final AtomicLong txnIdGenerator = new AtomicLong(0L);
    final BookieSocketAddress addr;
    final EventLoopGroup eventLoopGroup;
    final OrderedSafeExecutor executor;
    final HashedWheelTimer requestTimer;
    final int addEntryTimeout;
    final int readEntryTimeout;
    final int maxFrameSize;
    final int getBookieInfoTimeout;
    final int startTLSTimeout;
    private final ConcurrentHashMap<CompletionKey, CompletionValue> completionObjects = new ConcurrentHashMap();
    private final StatsLogger statsLogger;
    private final OpStatsLogger readEntryOpLogger;
    private final OpStatsLogger readTimeoutOpLogger;
    private final OpStatsLogger addEntryOpLogger;
    private final OpStatsLogger writeLacOpLogger;
    private final OpStatsLogger readLacOpLogger;
    private final OpStatsLogger addTimeoutOpLogger;
    private final OpStatsLogger writeLacTimeoutOpLogger;
    private final OpStatsLogger readLacTimeoutOpLogger;
    private final OpStatsLogger getBookieInfoOpLogger;
    private final OpStatsLogger getBookieInfoTimeoutOpLogger;
    private final OpStatsLogger startTLSOpLogger;
    private final OpStatsLogger startTLSTimeoutOpLogger;
    private final boolean useV2WireProtocol;
    private volatile Queue<BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>> pendingOps = new ArrayDeque<BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>>();
    volatile Channel channel = null;
    private final ClientConnectionPeer connectionPeer;
    private volatile BookKeeperPrincipal authorizedId = BookKeeperPrincipal.ANONYMOUS;
    volatile ConnectionState state;
    final ReentrantReadWriteLock closeLock = new ReentrantReadWriteLock();
    private final ClientConfiguration conf;
    private final PerChannelBookieClientPool pcbcPool;
    private final ClientAuthProvider.Factory authProviderFactory;
    private final ExtensionRegistry extRegistry;
    private final SecurityHandlerFactory shFactory;
    private final Recycler<AddCompletion> ADD_COMPLETION_RECYCLER = new Recycler<AddCompletion>(){

        protected AddCompletion newObject(Recycler.Handle<AddCompletion> handle) {
            return new AddCompletion(handle);
        }
    };
    private final Recycler<V2CompletionKey> V2_KEY_RECYCLER = new Recycler<V2CompletionKey>(){

        protected V2CompletionKey newObject(Recycler.Handle<V2CompletionKey> handle) {
            return new V2CompletionKey(handle);
        }
    };

    public PerChannelBookieClient(OrderedSafeExecutor executor, EventLoopGroup eventLoopGroup, BookieSocketAddress addr) throws SecurityException {
        this(new ClientConfiguration(), executor, eventLoopGroup, addr, null, (StatsLogger)NullStatsLogger.INSTANCE, null, null, null);
    }

    public PerChannelBookieClient(OrderedSafeExecutor executor, EventLoopGroup eventLoopGroup, BookieSocketAddress addr, ClientAuthProvider.Factory authProviderFactory, ExtensionRegistry extRegistry) throws SecurityException {
        this(new ClientConfiguration(), executor, eventLoopGroup, addr, null, (StatsLogger)NullStatsLogger.INSTANCE, authProviderFactory, extRegistry, null);
    }

    public PerChannelBookieClient(ClientConfiguration conf, OrderedSafeExecutor executor, EventLoopGroup eventLoopGroup, BookieSocketAddress addr, HashedWheelTimer requestTimer, StatsLogger parentStatsLogger, ClientAuthProvider.Factory authProviderFactory, ExtensionRegistry extRegistry, PerChannelBookieClientPool pcbcPool) throws SecurityException {
        this(conf, executor, eventLoopGroup, addr, null, (StatsLogger)NullStatsLogger.INSTANCE, authProviderFactory, extRegistry, pcbcPool, null);
    }

    public PerChannelBookieClient(ClientConfiguration conf, OrderedSafeExecutor executor, EventLoopGroup eventLoopGroup, BookieSocketAddress addr, HashedWheelTimer requestTimer, StatsLogger parentStatsLogger, ClientAuthProvider.Factory authProviderFactory, ExtensionRegistry extRegistry, PerChannelBookieClientPool pcbcPool, SecurityHandlerFactory shFactory) throws SecurityException {
        this.maxFrameSize = conf.getNettyMaxFrameSizeBytes();
        this.conf = conf;
        this.addr = addr;
        this.executor = executor;
        this.eventLoopGroup = LocalBookiesRegistry.isLocalBookie(addr) ? new DefaultEventLoopGroup() : eventLoopGroup;
        this.state = ConnectionState.DISCONNECTED;
        this.requestTimer = requestTimer;
        this.addEntryTimeout = conf.getAddEntryTimeout();
        this.readEntryTimeout = conf.getReadEntryTimeout();
        this.getBookieInfoTimeout = conf.getBookieInfoTimeout();
        this.startTLSTimeout = conf.getStartTLSTimeout();
        this.useV2WireProtocol = conf.getUseV2WireProtocol();
        this.authProviderFactory = authProviderFactory;
        this.extRegistry = extRegistry;
        this.shFactory = shFactory;
        if (shFactory != null) {
            shFactory.init(SecurityHandlerFactory.NodeType.Client, conf);
        }
        StringBuilder nameBuilder = new StringBuilder();
        nameBuilder.append(addr.getHostName().replace('.', '_').replace('-', '_')).append("_").append(addr.getPort());
        this.statsLogger = parentStatsLogger.scope("per_channel_bookie_client").scope(nameBuilder.toString());
        this.readEntryOpLogger = this.statsLogger.getOpStatsLogger("READ_ENTRY");
        this.addEntryOpLogger = this.statsLogger.getOpStatsLogger("ADD_ENTRY");
        this.writeLacOpLogger = this.statsLogger.getOpStatsLogger("WRITE_LAC");
        this.readLacOpLogger = this.statsLogger.getOpStatsLogger("READ_LAC");
        this.getBookieInfoOpLogger = this.statsLogger.getOpStatsLogger("GET_BOOKIE_INFO");
        this.readTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_READ_ENTRY");
        this.addTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_ADD_ENTRY");
        this.writeLacTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_WRITE_LAC");
        this.readLacTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_READ_LAC");
        this.getBookieInfoTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_GET_BOOKIE_INFO");
        this.startTLSOpLogger = this.statsLogger.getOpStatsLogger("START_TLS");
        this.startTLSTimeoutOpLogger = this.statsLogger.getOpStatsLogger("TIMEOUT_START_TLS");
        this.pcbcPool = pcbcPool;
        this.connectionPeer = new ClientConnectionPeer(){

            @Override
            public SocketAddress getRemoteAddr() {
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null) {
                    return c.remoteAddress();
                }
                return null;
            }

            @Override
            public Collection<Object> getProtocolPrincipals() {
                Channel c = PerChannelBookieClient.this.channel;
                if (c == null) {
                    return Collections.emptyList();
                }
                SslHandler ssl = (SslHandler)c.pipeline().get(SslHandler.class);
                if (ssl == null) {
                    return Collections.emptyList();
                }
                try {
                    Certificate[] certificates = ssl.engine().getSession().getPeerCertificates();
                    if (certificates == null) {
                        return Collections.emptyList();
                    }
                    ArrayList<Object> result = new ArrayList<Object>();
                    result.addAll(Arrays.asList(certificates));
                    return result;
                }
                catch (SSLPeerUnverifiedException err) {
                    return Collections.emptyList();
                }
            }

            @Override
            public void disconnect() {
                Channel c = PerChannelBookieClient.this.channel;
                if (c != null) {
                    c.close();
                }
                LOG.info("authplugin disconnected channel {}", (Object)PerChannelBookieClient.this.channel);
            }

            @Override
            public void setAuthorizedId(BookKeeperPrincipal principal) {
                PerChannelBookieClient.this.authorizedId = principal;
                LOG.info("connection {} authenticated as {}", (Object)PerChannelBookieClient.this.channel, (Object)principal);
            }

            @Override
            public BookKeeperPrincipal getAuthorizedId() {
                return PerChannelBookieClient.this.authorizedId;
            }

            @Override
            public boolean isSecure() {
                Channel c = PerChannelBookieClient.this.channel;
                if (c == null) {
                    return false;
                }
                return c.pipeline().get(SslHandler.class) != null;
            }
        };
    }

    private void completeOperation(BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> op, int rc) {
        this.closeLock.readLock().lock();
        try {
            if (ConnectionState.CLOSED == this.state) {
                op.operationComplete(-19, this);
            } else {
                op.operationComplete(rc, this);
            }
        }
        finally {
            this.closeLock.readLock().unlock();
        }
    }

    protected ChannelFuture connect() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Connecting to bookie: {}", (Object)this.addr);
        }
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(this.eventLoopGroup);
        if (this.eventLoopGroup instanceof EpollEventLoopGroup) {
            bootstrap.channel(EpollSocketChannel.class);
        } else if (this.eventLoopGroup instanceof DefaultEventLoopGroup) {
            bootstrap.channel(LocalChannel.class);
        } else {
            bootstrap.channel(NioSocketChannel.class);
        }
        Object allocator = this.conf.isNettyUsePooledBuffers() ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT;
        bootstrap.option(ChannelOption.ALLOCATOR, allocator);
        bootstrap.option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)this.conf.getClientConnectTimeoutMillis());
        bootstrap.option(ChannelOption.WRITE_BUFFER_WATER_MARK, (Object)new WriteBufferWaterMark(this.conf.getClientWriteBufferLowWaterMark(), this.conf.getClientWriteBufferHighWaterMark()));
        if (!(this.eventLoopGroup instanceof DefaultEventLoopGroup)) {
            bootstrap.option(ChannelOption.TCP_NODELAY, (Object)this.conf.getClientTcpNoDelay());
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.conf.getClientSockKeepalive());
            if (this.conf.getClientSendBufferSize() > 0) {
                bootstrap.option(ChannelOption.SO_SNDBUF, (Object)this.conf.getClientSendBufferSize());
            }
            if (this.conf.getClientReceiveBufferSize() > 0) {
                bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.conf.getClientReceiveBufferSize());
            }
        }
        bootstrap.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ChannelPipeline pipeline = ch.pipeline();
                pipeline.addLast("lengthbasedframedecoder", (ChannelHandler)new LengthFieldBasedFrameDecoder(PerChannelBookieClient.this.maxFrameSize, 0, 4, 0, 4));
                pipeline.addLast("lengthprepender", (ChannelHandler)new LengthFieldPrepender(4));
                pipeline.addLast("bookieProtoEncoder", (ChannelHandler)new BookieProtoEncoding.RequestEncoder(PerChannelBookieClient.this.extRegistry));
                pipeline.addLast("bookieProtoDecoder", (ChannelHandler)new BookieProtoEncoding.ResponseDecoder(PerChannelBookieClient.this.extRegistry));
                pipeline.addLast("authHandler", (ChannelHandler)new AuthHandler.ClientSideHandler(PerChannelBookieClient.this.authProviderFactory, txnIdGenerator, PerChannelBookieClient.this.connectionPeer));
                pipeline.addLast("mainhandler", (ChannelHandler)PerChannelBookieClient.this);
            }
        });
        InetSocketAddress bookieAddr = this.addr.getSocketAddress();
        if (this.eventLoopGroup instanceof DefaultEventLoopGroup) {
            bookieAddr = this.addr.getLocalAddress();
        }
        ChannelFuture future = bootstrap.connect((SocketAddress)bookieAddr);
        future.addListener((GenericFutureListener)new ConnectionFutureListener());
        return future;
    }

    void cleanDisconnectAndClose() {
        this.disconnect();
        this.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void connectIfNeededAndDoOp(BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient> op) {
        boolean completeOpNow = false;
        int opRc = 0;
        if (this.channel != null && this.state == ConnectionState.CONNECTED) {
            completeOpNow = true;
        } else {
            PerChannelBookieClient perChannelBookieClient = this;
            synchronized (perChannelBookieClient) {
                if (this.channel != null && this.state == ConnectionState.CONNECTED) {
                    completeOpNow = true;
                    opRc = 0;
                } else if (this.state == ConnectionState.CLOSED) {
                    completeOpNow = true;
                    opRc = -8;
                } else {
                    this.pendingOps.add(op);
                    if (this.state == ConnectionState.CONNECTING || this.state == ConnectionState.START_TLS) {
                        return;
                    }
                    this.state = ConnectionState.CONNECTING;
                }
            }
            if (!completeOpNow) {
                this.connect();
            }
        }
        if (completeOpNow) {
            this.completeOperation(op, opRc);
        }
    }

    void writeLac(long ledgerId, byte[] masterKey, long lac, ByteBuf toSend, BookkeeperInternalCallbacks.WriteLacCallback cb, Object ctx) {
        long txnId = this.getTxnId();
        V3CompletionKey completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.WRITE_LAC);
        this.completionObjects.put(completionKey, new WriteLacCompletion(completionKey, cb, ctx, lac));
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.WRITE_LAC).setTxnId(txnId);
        BookkeeperProtocol.WriteLacRequest.Builder writeLacBuilder = BookkeeperProtocol.WriteLacRequest.newBuilder().setLedgerId(ledgerId).setLac(lac).setMasterKey(ByteString.copyFrom((byte[])masterKey)).setBody(ByteString.copyFrom((ByteBuffer)toSend.nioBuffer()));
        BookkeeperProtocol.Request writeLacRequest = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setWriteLacRequest(writeLacBuilder).build();
        this.writeAndFlush(this.channel, completionKey, writeLacRequest);
    }

    void addEntry(long ledgerId, byte[] masterKey, long entryId, ByteBuf toSend, BookkeeperInternalCallbacks.WriteCallback cb, Object ctx, int options) {
        Object request = null;
        CompletionKey completionKey = null;
        if (this.useV2WireProtocol) {
            completionKey = this.acquireV2Key(ledgerId, entryId, BookkeeperProtocol.OperationType.ADD_ENTRY);
            request = BookieProtocol.AddRequest.create((byte)2, ledgerId, entryId, (short)options, masterKey, toSend);
        } else {
            long txnId = this.getTxnId();
            completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.ADD_ENTRY);
            BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.ADD_ENTRY).setTxnId(txnId);
            byte[] toSendArray = new byte[toSend.readableBytes()];
            toSend.getBytes(toSend.readerIndex(), toSendArray);
            BookkeeperProtocol.AddRequest.Builder addBuilder = BookkeeperProtocol.AddRequest.newBuilder().setLedgerId(ledgerId).setEntryId(entryId).setMasterKey(ByteString.copyFrom((byte[])masterKey)).setBody(ByteString.copyFrom((byte[])toSendArray));
            if (((short)options & 2) == 2) {
                addBuilder.setFlag(BookkeeperProtocol.AddRequest.Flag.RECOVERY_ADD);
            }
            request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setAddRequest(addBuilder).build();
        }
        this.completionObjects.put(completionKey, this.acquireAddCompletion(completionKey, cb, ctx, ledgerId, entryId));
        Channel c = this.channel;
        if (c == null) {
            this.errorOut(completionKey);
            toSend.release();
            return;
        }
        this.writeAndFlush(c, completionKey, request);
    }

    public void readEntryAndFenceLedger(long ledgerId, byte[] masterKey, long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        Object request = null;
        CompletionKey completionKey = null;
        if (this.useV2WireProtocol) {
            completionKey = this.acquireV2Key(ledgerId, entryId, BookkeeperProtocol.OperationType.READ_ENTRY);
            request = new BookieProtocol.ReadRequest(2, ledgerId, entryId, 1, masterKey);
        } else {
            long txnId = this.getTxnId();
            completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.READ_ENTRY);
            BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.READ_ENTRY).setTxnId(txnId);
            BookkeeperProtocol.ReadRequest.Builder readBuilder = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(ledgerId).setEntryId(entryId).setMasterKey(ByteString.copyFrom((byte[])masterKey)).setFlag(BookkeeperProtocol.ReadRequest.Flag.FENCE_LEDGER);
            request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setReadRequest(readBuilder).build();
        }
        ReadCompletion completion = new ReadCompletion(completionKey, cb, ctx, ledgerId, entryId);
        if (this.completionObjects.putIfAbsent(completionKey, completion) != null) {
            ((CompletionValue)completion).errorOut(-8);
            return;
        }
        this.writeAndFlush(this.channel, completionKey, request);
    }

    public void readLac(long ledgerId, BookkeeperInternalCallbacks.ReadLacCallback cb, Object ctx) {
        Object request = null;
        CompletionKey completionKey = null;
        if (this.useV2WireProtocol) {
            request = new BookieProtocol.ReadRequest(2, ledgerId, 0L, 0);
            completionKey = this.acquireV2Key(ledgerId, 0L, BookkeeperProtocol.OperationType.READ_LAC);
        } else {
            long txnId = this.getTxnId();
            completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.READ_LAC);
            BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.READ_LAC).setTxnId(txnId);
            BookkeeperProtocol.ReadLacRequest.Builder readLacBuilder = BookkeeperProtocol.ReadLacRequest.newBuilder().setLedgerId(ledgerId);
            request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setReadLacRequest(readLacBuilder).build();
        }
        this.completionObjects.put(completionKey, new ReadLacCompletion(completionKey, cb, ctx, ledgerId));
        this.writeAndFlush(this.channel, completionKey, request);
    }

    public void readEntryWaitForLACUpdate(long ledgerId, long entryId, long previousLAC, long timeOutInMillis, boolean piggyBackEntry, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        this.readEntryInternal(ledgerId, entryId, previousLAC, timeOutInMillis, piggyBackEntry, cb, ctx);
    }

    public void readEntry(long ledgerId, long entryId, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        this.readEntryInternal(ledgerId, entryId, null, null, false, cb, ctx);
    }

    private void readEntryInternal(long ledgerId, long entryId, Long previousLAC, Long timeOutInMillis, boolean piggyBackEntry, BookkeeperInternalCallbacks.ReadEntryCallback cb, Object ctx) {
        Object request = null;
        CompletionKey completionKey = null;
        if (this.useV2WireProtocol) {
            request = new BookieProtocol.ReadRequest(2, ledgerId, entryId, 0);
            completionKey = this.acquireV2Key(ledgerId, entryId, BookkeeperProtocol.OperationType.READ_ENTRY);
        } else {
            long txnId = this.getTxnId();
            completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.READ_ENTRY);
            BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.READ_ENTRY).setTxnId(txnId);
            BookkeeperProtocol.ReadRequest.Builder readBuilder = BookkeeperProtocol.ReadRequest.newBuilder().setLedgerId(ledgerId).setEntryId(entryId);
            if (null != previousLAC) {
                readBuilder = readBuilder.setPreviousLAC(previousLAC);
            }
            if (null != timeOutInMillis) {
                if (null == previousLAC) {
                    cb.readEntryComplete(-14, ledgerId, entryId, null, ctx);
                    return;
                }
                readBuilder = readBuilder.setTimeOut(timeOutInMillis);
            }
            if (piggyBackEntry) {
                if (null == previousLAC) {
                    cb.readEntryComplete(-14, ledgerId, entryId, null, ctx);
                    return;
                }
                readBuilder = readBuilder.setFlag(BookkeeperProtocol.ReadRequest.Flag.ENTRY_PIGGYBACK);
            }
            request = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setReadRequest(readBuilder).build();
        }
        ReadCompletion completion = new ReadCompletion(completionKey, cb, ctx, ledgerId, entryId);
        CompletionValue existingValue = this.completionObjects.putIfAbsent(completionKey, completion);
        if (existingValue != null) {
            LOG.warn("Failing concurrent request to read at ledger: {} entry: {}", (Object)ledgerId, (Object)entryId);
            ((CompletionValue)completion).errorOut(-999);
            return;
        }
        this.writeAndFlush(this.channel, completionKey, request);
    }

    public void getBookieInfo(long requested, BookkeeperInternalCallbacks.GetBookieInfoCallback cb, Object ctx) {
        long txnId = this.getTxnId();
        V3CompletionKey completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.GET_BOOKIE_INFO);
        this.completionObjects.put(completionKey, new GetBookieInfoCompletion(completionKey, cb, ctx));
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.GET_BOOKIE_INFO).setTxnId(txnId);
        BookkeeperProtocol.GetBookieInfoRequest.Builder getBookieInfoBuilder = BookkeeperProtocol.GetBookieInfoRequest.newBuilder().setRequested(requested);
        BookkeeperProtocol.Request getBookieInfoRequest = BookkeeperProtocol.Request.newBuilder().setHeader(headerBuilder).setGetBookieInfoRequest(getBookieInfoBuilder).build();
        this.writeAndFlush(this.channel, completionKey, getBookieInfoRequest);
    }

    public void disconnect() {
        this.disconnect(true);
    }

    public void disconnect(boolean wait) {
        LOG.info("Disconnecting the per channel bookie client for {}", (Object)this.addr);
        this.closeInternal(false, wait);
    }

    public void close() {
        this.close(true);
    }

    public void close(boolean wait) {
        LOG.info("Closing the per channel bookie client for {}", (Object)this.addr);
        this.closeLock.writeLock().lock();
        try {
            if (ConnectionState.CLOSED == this.state) {
                return;
            }
            this.state = ConnectionState.CLOSED;
            this.errorOutOutstandingEntries(-19);
        }
        finally {
            this.closeLock.writeLock().unlock();
        }
        this.closeInternal(true, wait);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeInternal(boolean permanent, boolean wait) {
        Channel toClose = null;
        PerChannelBookieClient perChannelBookieClient = this;
        synchronized (perChannelBookieClient) {
            if (permanent) {
                this.state = ConnectionState.CLOSED;
            } else if (this.state != ConnectionState.CLOSED) {
                this.state = ConnectionState.DISCONNECTED;
            }
            toClose = this.channel;
            this.channel = null;
        }
        if (toClose != null) {
            ChannelFuture cf = this.closeChannel(toClose);
            if (wait) {
                cf.awaitUninterruptibly();
            }
        }
    }

    private ChannelFuture closeChannel(Channel c) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Closing channel {}", (Object)c);
        }
        return c.close();
    }

    private void writeAndFlush(Channel channel, CompletionKey key, Object request) {
        if (channel == null) {
            this.errorOut(key);
            return;
        }
        try {
            channel.writeAndFlush(request, channel.voidPromise());
        }
        catch (Throwable e) {
            LOG.warn("Operation {} failed", (Object)PerChannelBookieClient.requestToString(request), (Object)e);
            this.errorOut(key);
        }
    }

    private static String requestToString(Object request) {
        if (request instanceof BookkeeperProtocol.Request) {
            BookkeeperProtocol.BKPacketHeader header = ((BookkeeperProtocol.Request)request).getHeader();
            return String.format("Req(txnId=%d,op=%s,version=%s)", new Object[]{header.getTxnId(), header.getOperation(), header.getVersion()});
        }
        return request.toString();
    }

    void errorOut(CompletionKey key) {
        CompletionValue completion;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing completion key: {}", (Object)key);
        }
        if ((completion = this.completionObjects.remove(key)) != null) {
            completion.errorOut();
        }
    }

    void errorOut(CompletionKey key, int rc) {
        CompletionValue completion;
        if (LOG.isDebugEnabled()) {
            LOG.debug("Removing completion key: {}", (Object)key);
        }
        if ((completion = this.completionObjects.remove(key)) != null) {
            completion.errorOut(rc);
        }
    }

    void errorOutOutstandingEntries(int rc) {
        for (CompletionKey key : this.completionObjects.keySet()) {
            this.errorOut(key, rc);
        }
    }

    void recordError() {
        if (this.pcbcPool != null) {
            this.pcbcPool.recordError();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        LOG.info("Disconnected from bookie channel {}", (Object)ctx.channel());
        if (ctx.channel() != null) {
            this.closeChannel(ctx.channel());
        }
        this.errorOutOutstandingEntries(-8);
        PerChannelBookieClient perChannelBookieClient = this;
        synchronized (perChannelBookieClient) {
            if (this.channel == ctx.channel() && this.state != ConnectionState.CLOSED) {
                this.state = ConnectionState.DISCONNECTED;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof CorruptedFrameException || cause instanceof TooLongFrameException) {
            LOG.error("Corrupted frame received from bookie: {}", (Object)ctx.channel().remoteAddress());
            ctx.close();
            return;
        }
        if (cause instanceof AuthHandler.AuthenticationException) {
            LOG.error("Error authenticating connection", cause);
            this.errorOutOutstandingEntries(-102);
            Channel c = ctx.channel();
            if (c != null) {
                this.closeChannel(c);
            }
            return;
        }
        if (cause instanceof IOException) {
            ctx.close();
            return;
        }
        PerChannelBookieClient perChannelBookieClient = this;
        synchronized (perChannelBookieClient) {
            if (this.state == ConnectionState.CLOSED) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Unexpected exception caught by bookie client channel handler, but the client is closed, so it isn't important", cause);
                }
            } else {
                LOG.error("Unexpected exception caught by bookie client channel handler", cause);
            }
        }
        ctx.close();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof BookieProtocol.Response) {
            BookieProtocol.Response response = (BookieProtocol.Response)msg;
            this.readV2Response(response);
        } else if (msg instanceof BookkeeperProtocol.Response) {
            BookkeeperProtocol.Response response = (BookkeeperProtocol.Response)msg;
            this.readV3Response(response);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private void readV2Response(final BookieProtocol.Response response) {
        final long ledgerId = response.ledgerId;
        final long entryId = response.entryId;
        BookkeeperProtocol.OperationType operationType = this.getOperationType(response.getOpCode());
        final BookkeeperProtocol.StatusCode status = this.getStatusCodeFromErrorCode(response.errorCode);
        V2CompletionKey key = this.acquireV2Key(ledgerId, entryId, operationType);
        final CompletionValue completionValue = this.completionObjects.remove(key);
        ((CompletionKey)key).release();
        if (null == completionValue) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unexpected response received from bookie : " + this.addr + " for type : " + (Object)((Object)operationType) + " and ledger:entry : " + ledgerId + ":" + entryId);
            }
        } else {
            long orderingKey = completionValue.ledgerId;
            this.executor.submitOrdered(orderingKey, new SafeRunnable(){

                public void safeRun() {
                    completionValue.handleV2Response(ledgerId, entryId, status, response);
                    response.recycle();
                }
            });
        }
    }

    private BookkeeperProtocol.StatusCode getStatusCodeFromErrorCode(int errorCode) {
        switch (errorCode) {
            case 0: {
                return BookkeeperProtocol.StatusCode.EOK;
            }
            case 1: {
                return BookkeeperProtocol.StatusCode.ENOLEDGER;
            }
            case 2: {
                return BookkeeperProtocol.StatusCode.ENOENTRY;
            }
            case 100: {
                return BookkeeperProtocol.StatusCode.EBADREQ;
            }
            case 101: {
                return BookkeeperProtocol.StatusCode.EIO;
            }
            case 102: {
                return BookkeeperProtocol.StatusCode.EUA;
            }
            case 103: {
                return BookkeeperProtocol.StatusCode.EBADVERSION;
            }
            case 104: {
                return BookkeeperProtocol.StatusCode.EFENCED;
            }
            case 105: {
                return BookkeeperProtocol.StatusCode.EREADONLY;
            }
            case 106: {
                return BookkeeperProtocol.StatusCode.ETOOMANYREQUESTS;
            }
        }
        throw new IllegalArgumentException("Invalid error code: " + errorCode);
    }

    private BookkeeperProtocol.OperationType getOperationType(byte opCode) {
        switch (opCode) {
            case 1: {
                return BookkeeperProtocol.OperationType.ADD_ENTRY;
            }
            case 2: {
                return BookkeeperProtocol.OperationType.READ_ENTRY;
            }
            case 3: {
                return BookkeeperProtocol.OperationType.AUTH;
            }
            case 4: {
                return BookkeeperProtocol.OperationType.READ_LAC;
            }
            case 5: {
                return BookkeeperProtocol.OperationType.WRITE_LAC;
            }
            case 6: {
                return BookkeeperProtocol.OperationType.GET_BOOKIE_INFO;
            }
        }
        throw new IllegalArgumentException("Invalid operation type");
    }

    private void readV3Response(final BookkeeperProtocol.Response response) {
        final BookkeeperProtocol.BKPacketHeader header = response.getHeader();
        final CompletionValue completionValue = this.completionObjects.remove(this.newCompletionKey(header.getTxnId(), header.getOperation()));
        if (null == completionValue) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Unexpected response received from bookie : " + this.addr + " for type : " + (Object)((Object)header.getOperation()) + " and txnId : " + header.getTxnId());
            }
        } else {
            long orderingKey = completionValue.ledgerId;
            this.executor.submitOrdered(orderingKey, new SafeRunnable(){

                public void safeRun() {
                    completionValue.handleV3Response(response);
                }

                public String toString() {
                    return String.format("HandleResponse(Txn=%d, Type=%s, Entry=(%d, %d))", new Object[]{header.getTxnId(), header.getOperation(), completionValue.ledgerId, completionValue.entryId});
                }
            });
        }
    }

    void initTLSHandshake() {
        PerChannelBookieClient parentObj = this;
        SslHandler handler = parentObj.shFactory.newTLSHandler();
        this.channel.pipeline().addFirst(parentObj.shFactory.getHandlerName(), (ChannelHandler)handler);
        handler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void operationComplete(Future<Channel> future) throws Exception {
                Queue oldPendingOps;
                int rc;
                PerChannelBookieClient perChannelBookieClient = PerChannelBookieClient.this;
                synchronized (perChannelBookieClient) {
                    if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.CONNECTING) {
                        LOG.error("Connection state changed before TLS handshake completed {}/{}", (Object)PerChannelBookieClient.this.addr, (Object)PerChannelBookieClient.this.state);
                        rc = -8;
                        PerChannelBookieClient.this.closeChannel((Channel)future.get());
                        PerChannelBookieClient.this.channel = null;
                        if (PerChannelBookieClient.this.state != ConnectionState.CLOSED) {
                            PerChannelBookieClient.this.state = ConnectionState.DISCONNECTED;
                        }
                    } else if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.START_TLS) {
                        rc = 0;
                        LOG.info("Successfully connected to bookie using TLS: " + PerChannelBookieClient.this.addr);
                        PerChannelBookieClient.this.state = ConnectionState.CONNECTED;
                        AuthHandler.ClientSideHandler authHandler = (AuthHandler.ClientSideHandler)((Channel)future.get()).pipeline().get(AuthHandler.ClientSideHandler.class);
                        authHandler.authProvider.onProtocolUpgrade();
                    } else if (future.isSuccess() && (PerChannelBookieClient.this.state == ConnectionState.CLOSED || PerChannelBookieClient.this.state == ConnectionState.DISCONNECTED)) {
                        LOG.warn("Closed before TLS handshake completed, clean up: {}, current state {}", future.get(), (Object)PerChannelBookieClient.this.state);
                        PerChannelBookieClient.this.closeChannel((Channel)future.get());
                        rc = -8;
                        PerChannelBookieClient.this.channel = null;
                    } else {
                        if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.CONNECTED) {
                            LOG.debug("Already connected with another channel({}), so close the new channel({})", (Object)PerChannelBookieClient.this.channel, future.get());
                            PerChannelBookieClient.this.closeChannel((Channel)future.get());
                            return;
                        }
                        LOG.error("TLS handshake failed with bookie: {}/{}, current state {} : ", new Object[]{future.get(), PerChannelBookieClient.this.addr, PerChannelBookieClient.this.state, future.cause()});
                        rc = -24;
                        PerChannelBookieClient.this.closeChannel((Channel)future.get());
                        PerChannelBookieClient.this.channel = null;
                        if (PerChannelBookieClient.this.state != ConnectionState.CLOSED) {
                            PerChannelBookieClient.this.state = ConnectionState.DISCONNECTED;
                        }
                    }
                    oldPendingOps = PerChannelBookieClient.this.pendingOps;
                    PerChannelBookieClient.this.pendingOps = new ArrayDeque();
                }
                for (BookkeeperInternalCallbacks.GenericCallback pendingOp : oldPendingOps) {
                    pendingOp.operationComplete(rc, PerChannelBookieClient.this);
                }
            }
        });
    }

    AddCompletion acquireAddCompletion(CompletionKey key, BookkeeperInternalCallbacks.WriteCallback originalCallback, Object originalCtx, long ledgerId, long entryId) {
        AddCompletion completion = (AddCompletion)this.ADD_COMPLETION_RECYCLER.get();
        completion.reset(key, originalCallback, originalCtx, ledgerId, entryId);
        return completion;
    }

    CompletionKey newCompletionKey(long txnId, BookkeeperProtocol.OperationType operationType) {
        return new V3CompletionKey(txnId, operationType);
    }

    Timeout scheduleTimeout(CompletionKey key, long timeout) {
        if (null != this.requestTimer) {
            return this.requestTimer.newTimeout((TimerTask)key, timeout, TimeUnit.SECONDS);
        }
        return null;
    }

    private Integer statusCodeToExceptionCode(BookkeeperProtocol.StatusCode status) {
        Integer rcToRet = null;
        switch (status) {
            case EOK: {
                rcToRet = 0;
                break;
            }
            case ENOENTRY: {
                rcToRet = -13;
                break;
            }
            case ENOLEDGER: {
                rcToRet = -7;
                break;
            }
            case EBADVERSION: {
                rcToRet = -16;
                break;
            }
            case EUA: {
                rcToRet = -102;
                break;
            }
            case EFENCED: {
                rcToRet = -101;
                break;
            }
            case EREADONLY: {
                rcToRet = -104;
                break;
            }
            case ETOOMANYREQUESTS: {
                rcToRet = -105;
                break;
            }
        }
        return rcToRet;
    }

    private long getTxnId() {
        return txnIdGenerator.incrementAndGet();
    }

    V2CompletionKey acquireV2Key(long ledgerId, long entryId, BookkeeperProtocol.OperationType operationType) {
        V2CompletionKey key = (V2CompletionKey)this.V2_KEY_RECYCLER.get();
        key.reset(ledgerId, entryId, operationType);
        return key;
    }

    private void initiateTLS() {
        LOG.info("Initializing TLS to {}", (Object)this.channel);
        assert (this.state == ConnectionState.CONNECTING);
        long txnId = this.getTxnId();
        V3CompletionKey completionKey = new V3CompletionKey(txnId, BookkeeperProtocol.OperationType.START_TLS);
        this.completionObjects.put(completionKey, new StartTLSCompletion(completionKey));
        BookkeeperProtocol.Request.Builder h = BookkeeperProtocol.Request.newBuilder();
        BookkeeperProtocol.BKPacketHeader.Builder headerBuilder = BookkeeperProtocol.BKPacketHeader.newBuilder().setVersion(BookkeeperProtocol.ProtocolVersion.VERSION_THREE).setOperation(BookkeeperProtocol.OperationType.START_TLS).setTxnId(txnId);
        h.setHeader(headerBuilder.build());
        h.setStartTLSRequest(BookkeeperProtocol.StartTLSRequest.newBuilder().build());
        this.state = ConnectionState.START_TLS;
        this.writeAndFlush(this.channel, completionKey, h.build());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void failTLS(int rc) {
        Queue<BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>> oldPendingOps;
        LOG.error("TLS failure on: {}, rc: {}", (Object)this.channel, (Object)rc);
        PerChannelBookieClient perChannelBookieClient = this;
        synchronized (perChannelBookieClient) {
            this.disconnect();
            oldPendingOps = this.pendingOps;
            this.pendingOps = new ArrayDeque<BookkeeperInternalCallbacks.GenericCallback<PerChannelBookieClient>>();
        }
        for (BookkeeperInternalCallbacks.GenericCallback genericCallback : oldPendingOps) {
            genericCallback.operationComplete(rc, null);
        }
    }

    public class ConnectionFutureListener
    implements ChannelFutureListener {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void operationComplete(ChannelFuture future) throws Exception {
            Queue oldPendingOps;
            int rc;
            LOG.debug("Channel connected ({}) {}", (Object)future.isSuccess(), (Object)future.channel());
            PerChannelBookieClient perChannelBookieClient = PerChannelBookieClient.this;
            synchronized (perChannelBookieClient) {
                if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.CONNECTING && future.channel().isActive()) {
                    LOG.info("Successfully connected to bookie: {}", (Object)future.channel());
                    rc = 0;
                    PerChannelBookieClient.this.channel = future.channel();
                    if (PerChannelBookieClient.this.shFactory != null) {
                        PerChannelBookieClient.this.initiateTLS();
                        return;
                    }
                    LOG.info("Successfully connected to bookie: " + PerChannelBookieClient.this.addr);
                    PerChannelBookieClient.this.state = ConnectionState.CONNECTED;
                } else if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.START_TLS) {
                    rc = 0;
                    LOG.info("Successfully connected to bookie using TLS: " + PerChannelBookieClient.this.addr);
                    PerChannelBookieClient.this.state = ConnectionState.CONNECTED;
                    AuthHandler.ClientSideHandler authHandler = (AuthHandler.ClientSideHandler)future.channel().pipeline().get(AuthHandler.ClientSideHandler.class);
                    authHandler.authProvider.onProtocolUpgrade();
                } else if (future.isSuccess() && (PerChannelBookieClient.this.state == ConnectionState.CLOSED || PerChannelBookieClient.this.state == ConnectionState.DISCONNECTED)) {
                    LOG.warn("Closed before connection completed, clean up: {}, current state {}", (Object)future.channel(), (Object)PerChannelBookieClient.this.state);
                    PerChannelBookieClient.this.closeChannel(future.channel());
                    rc = -8;
                    PerChannelBookieClient.this.channel = null;
                } else {
                    if (future.isSuccess() && PerChannelBookieClient.this.state == ConnectionState.CONNECTED) {
                        LOG.debug("Already connected with another channel({}), so close the new channel({})", (Object)PerChannelBookieClient.this.channel, (Object)future.channel());
                        PerChannelBookieClient.this.closeChannel(future.channel());
                        return;
                    }
                    LOG.error("Could not connect to bookie: {}/{}, current state {} : ", new Object[]{future.channel(), PerChannelBookieClient.this.addr, PerChannelBookieClient.this.state, future.cause()});
                    rc = -8;
                    PerChannelBookieClient.this.closeChannel(future.channel());
                    PerChannelBookieClient.this.channel = null;
                    if (PerChannelBookieClient.this.state != ConnectionState.CLOSED) {
                        PerChannelBookieClient.this.state = ConnectionState.DISCONNECTED;
                    }
                }
                oldPendingOps = PerChannelBookieClient.this.pendingOps;
                PerChannelBookieClient.this.pendingOps = new ArrayDeque();
            }
            for (BookkeeperInternalCallbacks.GenericCallback pendingOp : oldPendingOps) {
                pendingOp.operationComplete(rc, PerChannelBookieClient.this);
            }
        }
    }

    private class V2CompletionKey
    extends CompletionKey {
        private final Recycler.Handle<V2CompletionKey> recyclerHandle;
        long ledgerId;
        long entryId;

        private V2CompletionKey(Recycler.Handle<V2CompletionKey> handle) {
            super(-1L, null);
            this.recyclerHandle = handle;
        }

        void reset(long ledgerId, long entryId, BookkeeperProtocol.OperationType operationType) {
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.operationType = operationType;
        }

        public boolean equals(Object object) {
            if (!(object instanceof V2CompletionKey)) {
                return false;
            }
            V2CompletionKey that = (V2CompletionKey)object;
            return this.entryId == that.entryId && this.ledgerId == that.ledgerId && this.operationType == that.operationType;
        }

        public int hashCode() {
            return Long.hashCode(this.ledgerId) * 31 + Long.hashCode(this.entryId);
        }

        public String toString() {
            return String.format("%d:%d %s", new Object[]{this.ledgerId, this.entryId, this.operationType});
        }

        @Override
        public void release() {
            this.recyclerHandle.recycle((Object)this);
        }
    }

    abstract class CompletionKey
    implements TimerTask {
        final long txnId;
        BookkeeperProtocol.OperationType operationType;

        CompletionKey(long txnId, BookkeeperProtocol.OperationType operationType) {
            this.txnId = txnId;
            this.operationType = operationType;
        }

        public void run(Timeout timeout) throws Exception {
            if (timeout.isCancelled()) {
                return;
            }
            CompletionValue completion = (CompletionValue)PerChannelBookieClient.this.completionObjects.remove(this);
            if (completion != null) {
                completion.timeout();
            }
        }

        public void release() {
        }
    }

    class V3CompletionKey
    extends CompletionKey {
        public V3CompletionKey(long txnId, BookkeeperProtocol.OperationType operationType) {
            super(txnId, operationType);
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof V3CompletionKey)) {
                return false;
            }
            V3CompletionKey that = (V3CompletionKey)obj;
            return this.txnId == that.txnId && this.operationType == that.operationType;
        }

        public int hashCode() {
            return (int)this.txnId;
        }

        public String toString() {
            return String.format("TxnId(%d), OperationType(%s)", new Object[]{this.txnId, this.operationType});
        }
    }

    class AddCompletion
    extends CompletionValue
    implements BookkeeperInternalCallbacks.WriteCallback {
        final Recycler.Handle<AddCompletion> handle;
        CompletionKey key;
        BookkeeperInternalCallbacks.WriteCallback originalCallback;

        AddCompletion(Recycler.Handle<AddCompletion> handle) {
            super("Add", null, -1L, -1L, PerChannelBookieClient.this.addEntryOpLogger, PerChannelBookieClient.this.addTimeoutOpLogger, null);
            this.key = null;
            this.originalCallback = null;
            this.handle = handle;
        }

        void reset(CompletionKey key, BookkeeperInternalCallbacks.WriteCallback originalCallback, Object originalCtx, long ledgerId, long entryId) {
            this.key = key;
            this.originalCallback = originalCallback;
            this.ctx = originalCtx;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.startTime = MathUtils.nowInNano();
            this.timeout = PerChannelBookieClient.this.scheduleTimeout(key, PerChannelBookieClient.this.addEntryTimeout);
        }

        @Override
        public void writeComplete(int rc, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx) {
            this.cancelTimeoutAndLogOp(rc);
            this.originalCallback.writeComplete(rc, ledgerId, entryId, addr, ctx);
            this.key.release();
            this.handle.recycle((Object)this);
        }

        @Override
        public void errorOut() {
            this.errorOut(-8);
        }

        @Override
        public void errorOut(int rc) {
            this.errorOutAndRunCallback(() -> this.writeComplete(rc, this.ledgerId, this.entryId, PerChannelBookieClient.this.addr, this.ctx));
        }

        @Override
        public void handleV2Response(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, BookieProtocol.Response response) {
            this.handleResponse(ledgerId, entryId, status);
        }

        @Override
        public void handleV3Response(BookkeeperProtocol.Response response) {
            BookkeeperProtocol.AddResponse addResponse = response.getAddResponse();
            BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? addResponse.getStatus() : response.getStatus();
            this.handleResponse(addResponse.getLedgerId(), addResponse.getEntryId(), status);
        }

        private void handleResponse(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status) {
            int rc = this.logAndConvertStatus(status, -12, "ledger", ledgerId, "entry", entryId);
            this.writeComplete(rc, ledgerId, entryId, PerChannelBookieClient.this.addr, this.ctx);
        }
    }

    class GetBookieInfoCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.GetBookieInfoCallback cb;

        public GetBookieInfoCompletion(final CompletionKey key, final BookkeeperInternalCallbacks.GetBookieInfoCallback origCallback, final Object origCtx) {
            super("GetBookieInfo", origCtx, 0L, 0L, PerChannelBookieClient.this.getBookieInfoOpLogger, PerChannelBookieClient.this.getBookieInfoTimeoutOpLogger, PerChannelBookieClient.this.scheduleTimeout(key, PerChannelBookieClient.this.getBookieInfoTimeout));
            this.cb = new BookkeeperInternalCallbacks.GetBookieInfoCallback(){

                @Override
                public void getBookieInfoComplete(int rc, BookieInfoReader.BookieInfo bInfo, Object ctx) {
                    GetBookieInfoCompletion.this.cancelTimeoutAndLogOp(rc);
                    origCallback.getBookieInfoComplete(rc, bInfo, origCtx);
                    key.release();
                }
            };
        }

        @Override
        public void errorOut() {
            this.errorOut(-8);
        }

        @Override
        public void errorOut(int rc) {
            this.errorOutAndRunCallback(() -> this.cb.getBookieInfoComplete(rc, new BookieInfoReader.BookieInfo(), this.ctx));
        }

        @Override
        public void handleV3Response(BookkeeperProtocol.Response response) {
            BookkeeperProtocol.GetBookieInfoResponse getBookieInfoResponse = response.getGetBookieInfoResponse();
            BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? getBookieInfoResponse.getStatus() : response.getStatus();
            long freeDiskSpace = getBookieInfoResponse.getFreeDiskSpace();
            long totalDiskSpace = getBookieInfoResponse.getTotalDiskCapacity();
            int rc = this.logAndConvertStatus(status, -1, "freeDisk", freeDiskSpace, "totalDisk", totalDiskSpace);
            this.cb.getBookieInfoComplete(rc, new BookieInfoReader.BookieInfo(totalDiskSpace, freeDiskSpace), this.ctx);
        }
    }

    class StartTLSCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.StartTLSCallback cb;

        public StartTLSCompletion(final CompletionKey key) {
            super("StartTLS", null, -1L, -1L, PerChannelBookieClient.this.startTLSOpLogger, PerChannelBookieClient.this.startTLSTimeoutOpLogger, PerChannelBookieClient.this.scheduleTimeout(key, PerChannelBookieClient.this.startTLSTimeout));
            this.cb = new BookkeeperInternalCallbacks.StartTLSCallback(){

                @Override
                public void startTLSComplete(int rc, Object ctx) {
                    StartTLSCompletion.this.cancelTimeoutAndLogOp(rc);
                    key.release();
                }
            };
        }

        @Override
        public void errorOut() {
            this.errorOut(-8);
        }

        @Override
        public void errorOut(int rc) {
            PerChannelBookieClient.this.failTLS(rc);
        }

        @Override
        public void handleV3Response(BookkeeperProtocol.Response response) {
            BookkeeperProtocol.StatusCode status = response.getStatus();
            int rc = this.logAndConvertStatus(status, -24, new Object[0]);
            this.cb.startTLSComplete(rc, null);
            if (PerChannelBookieClient.this.state != ConnectionState.START_TLS) {
                LOG.error("Connection state changed before TLS response received");
                PerChannelBookieClient.this.failTLS(-8);
            } else if (status != BookkeeperProtocol.StatusCode.EOK) {
                LOG.error("Client received error {} during TLS negotiation", (Object)status);
                PerChannelBookieClient.this.failTLS(-24);
            } else {
                PerChannelBookieClient.this.initTLSHandshake();
            }
        }
    }

    class ReadCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.ReadEntryCallback cb;

        public ReadCompletion(final CompletionKey key, final BookkeeperInternalCallbacks.ReadEntryCallback originalCallback, final Object originalCtx, long ledgerId, long entryId) {
            super("Read", originalCtx, ledgerId, entryId, PerChannelBookieClient.this.readEntryOpLogger, PerChannelBookieClient.this.readTimeoutOpLogger, PerChannelBookieClient.this.scheduleTimeout(key, PerChannelBookieClient.this.readEntryTimeout));
            this.cb = new BookkeeperInternalCallbacks.ReadEntryCallback(){

                @Override
                public void readEntryComplete(int rc, long ledgerId, long entryId, ByteBuf buffer, Object ctx) {
                    ReadCompletion.this.cancelTimeoutAndLogOp(rc);
                    originalCallback.readEntryComplete(rc, ledgerId, entryId, buffer, originalCtx);
                    key.release();
                }
            };
        }

        @Override
        public void errorOut() {
            this.errorOut(-8);
        }

        @Override
        public void errorOut(int rc) {
            this.errorOutAndRunCallback(() -> this.cb.readEntryComplete(rc, this.ledgerId, this.entryId, null, this.ctx));
        }

        @Override
        public void handleV2Response(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, BookieProtocol.Response response) {
            if (!(response instanceof BookieProtocol.ReadResponse)) {
                return;
            }
            BookieProtocol.ReadResponse readResponse = (BookieProtocol.ReadResponse)response;
            ByteBuf data = null;
            if (readResponse.hasData()) {
                data = readResponse.getData();
            }
            this.handleReadResponse(ledgerId, entryId, status, data, -1L, -1L);
        }

        @Override
        public void handleV3Response(BookkeeperProtocol.Response response) {
            BookkeeperProtocol.ReadResponse readResponse = response.getReadResponse();
            BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? readResponse.getStatus() : response.getStatus();
            ByteBuf buffer = Unpooled.EMPTY_BUFFER;
            if (readResponse.hasBody()) {
                buffer = Unpooled.wrappedBuffer((ByteBuffer)readResponse.getBody().asReadOnlyByteBuffer());
            }
            long maxLAC = -1L;
            if (readResponse.hasMaxLAC()) {
                maxLAC = readResponse.getMaxLAC();
            }
            long lacUpdateTimestamp = -1L;
            if (readResponse.hasLacUpdateTimestamp()) {
                lacUpdateTimestamp = readResponse.getLacUpdateTimestamp();
            }
            this.handleReadResponse(readResponse.getLedgerId(), readResponse.getEntryId(), status, buffer, maxLAC, lacUpdateTimestamp);
        }

        private void handleReadResponse(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, ByteBuf buffer, long maxLAC, long lacUpdateTimestamp) {
            int readableBytes = buffer == null ? 0 : buffer.readableBytes();
            int rc = this.logAndConvertStatus(status, -1, "ledger", ledgerId, "entry", entryId, "entryLength", readableBytes);
            if (buffer != null) {
                buffer = buffer.slice();
            }
            if (maxLAC > -1L && this.ctx instanceof BookkeeperInternalCallbacks.ReadEntryCallbackCtx) {
                ((BookkeeperInternalCallbacks.ReadEntryCallbackCtx)this.ctx).setLastAddConfirmed(maxLAC);
            }
            if (lacUpdateTimestamp > -1L && this.ctx instanceof ReadLastConfirmedAndEntryContext) {
                ((ReadLastConfirmedAndEntryContext)this.ctx).setLacUpdateTimestamp(lacUpdateTimestamp);
            }
            this.cb.readEntryComplete(rc, ledgerId, entryId, buffer, this.ctx);
        }
    }

    class ReadLacCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.ReadLacCallback cb;

        public ReadLacCompletion(final CompletionKey key, final BookkeeperInternalCallbacks.ReadLacCallback originalCallback, Object ctx, long ledgerId) {
            super("ReadLAC", ctx, ledgerId, -1L, PerChannelBookieClient.this.readLacOpLogger, PerChannelBookieClient.this.readLacTimeoutOpLogger, PerChannelBookieClient.this.scheduleTimeout(key, PerChannelBookieClient.this.readEntryTimeout));
            this.cb = new BookkeeperInternalCallbacks.ReadLacCallback(){

                @Override
                public void readLacComplete(int rc, long ledgerId, ByteBuf lacBuffer, ByteBuf lastEntryBuffer, Object ctx) {
                    ReadLacCompletion.this.cancelTimeoutAndLogOp(rc);
                    originalCallback.readLacComplete(rc, ledgerId, lacBuffer, lastEntryBuffer, ctx);
                    key.release();
                }
            };
        }

        @Override
        public void errorOut() {
            this.errorOut(-8);
        }

        @Override
        public void errorOut(int rc) {
            this.errorOutAndRunCallback(() -> this.cb.readLacComplete(rc, this.ledgerId, null, null, this.ctx));
        }

        @Override
        public void handleV3Response(BookkeeperProtocol.Response response) {
            BookkeeperProtocol.StatusCode status;
            BookkeeperProtocol.ReadLacResponse readLacResponse = response.getReadLacResponse();
            ByteBuf lacBuffer = Unpooled.EMPTY_BUFFER;
            ByteBuf lastEntryBuffer = Unpooled.EMPTY_BUFFER;
            BookkeeperProtocol.StatusCode statusCode = status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? readLacResponse.getStatus() : response.getStatus();
            if (readLacResponse.hasLacBody()) {
                lacBuffer = Unpooled.wrappedBuffer((ByteBuffer)readLacResponse.getLacBody().asReadOnlyByteBuffer());
            }
            if (readLacResponse.hasLastEntryBody()) {
                lastEntryBuffer = Unpooled.wrappedBuffer((ByteBuffer)readLacResponse.getLastEntryBody().asReadOnlyByteBuffer());
            }
            int rc = this.logAndConvertStatus(status, -1, "ledger", this.ledgerId);
            this.cb.readLacComplete(rc, this.ledgerId, lacBuffer.slice(), lastEntryBuffer.slice(), this.ctx);
        }
    }

    class WriteLacCompletion
    extends CompletionValue {
        final BookkeeperInternalCallbacks.WriteLacCallback cb;

        public WriteLacCompletion(final CompletionKey key, final BookkeeperInternalCallbacks.WriteLacCallback originalCallback, final Object originalCtx, long ledgerId) {
            super("WriteLAC", originalCtx, ledgerId, -1L, PerChannelBookieClient.this.writeLacOpLogger, PerChannelBookieClient.this.writeLacTimeoutOpLogger, PerChannelBookieClient.this.scheduleTimeout(key, PerChannelBookieClient.this.addEntryTimeout));
            this.cb = new BookkeeperInternalCallbacks.WriteLacCallback(){

                @Override
                public void writeLacComplete(int rc, long ledgerId, BookieSocketAddress addr, Object ctx) {
                    WriteLacCompletion.this.cancelTimeoutAndLogOp(rc);
                    originalCallback.writeLacComplete(rc, ledgerId, addr, originalCtx);
                    key.release();
                }
            };
        }

        @Override
        public void errorOut() {
            this.errorOut(-8);
        }

        @Override
        public void errorOut(int rc) {
            this.errorOutAndRunCallback(() -> this.cb.writeLacComplete(rc, this.ledgerId, PerChannelBookieClient.this.addr, this.ctx));
        }

        @Override
        public void handleV3Response(BookkeeperProtocol.Response response) {
            BookkeeperProtocol.WriteLacResponse writeLacResponse = response.getWriteLacResponse();
            BookkeeperProtocol.StatusCode status = response.getStatus() == BookkeeperProtocol.StatusCode.EOK ? writeLacResponse.getStatus() : response.getStatus();
            long ledgerId = writeLacResponse.getLedgerId();
            int rc = this.logAndConvertStatus(status, -12, "ledger", ledgerId);
            this.cb.writeLacComplete(rc, ledgerId, PerChannelBookieClient.this.addr, this.ctx);
        }
    }

    abstract class CompletionValue {
        private final OpStatsLogger opLogger;
        private final OpStatsLogger timeoutOpLogger;
        private final String operationName;
        protected Object ctx;
        protected long ledgerId;
        protected long entryId;
        protected long startTime;
        protected Timeout timeout;

        public CompletionValue(String operationName, Object ctx, long ledgerId, long entryId, OpStatsLogger opLogger, OpStatsLogger timeoutOpLogger, Timeout timeout) {
            this.operationName = operationName;
            this.ctx = ctx;
            this.ledgerId = ledgerId;
            this.entryId = entryId;
            this.startTime = MathUtils.nowInNano();
            this.opLogger = opLogger;
            this.timeoutOpLogger = timeoutOpLogger;
            this.timeout = timeout;
        }

        private long latency() {
            return MathUtils.elapsedNanos((long)this.startTime);
        }

        void cancelTimeoutAndLogOp(int rc) {
            Timeout t = this.timeout;
            if (null != t) {
                t.cancel();
            }
            if (rc != 0) {
                this.opLogger.registerFailedEvent(this.latency(), TimeUnit.NANOSECONDS);
            } else {
                this.opLogger.registerSuccessfulEvent(this.latency(), TimeUnit.NANOSECONDS);
            }
            if (rc != 0 && !expectedBkOperationErrors.contains(rc)) {
                PerChannelBookieClient.this.recordError();
            }
        }

        void timeout() {
            this.errorOut(-23);
            this.timeoutOpLogger.registerSuccessfulEvent(this.latency(), TimeUnit.NANOSECONDS);
        }

        protected int logAndConvertStatus(BookkeeperProtocol.StatusCode status, int defaultStatus, Object ... extraInfo) {
            Integer rcToRet;
            if (LOG.isDebugEnabled()) {
                LOG.debug("Got {} response from bookie:{} rc:{}, {}", new Object[]{this.operationName, PerChannelBookieClient.this.addr, status, Joiner.on((String)":").join(extraInfo)});
            }
            if (null == (rcToRet = PerChannelBookieClient.this.statusCodeToExceptionCode(status))) {
                LOG.error("{} for failed on bookie {} code {}", new Object[]{this.operationName, PerChannelBookieClient.this.addr, status});
                return defaultStatus;
            }
            return rcToRet;
        }

        public abstract void errorOut();

        public abstract void errorOut(int var1);

        protected void errorOutAndRunCallback(final Runnable callback) {
            PerChannelBookieClient.this.executor.submitOrdered(this.ledgerId, new SafeRunnable(){

                public void safeRun() {
                    String bAddress = "null";
                    Channel c = PerChannelBookieClient.this.channel;
                    if (c != null && c.remoteAddress() != null) {
                        bAddress = c.remoteAddress().toString();
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Could not write {} request to bookie {} for ledger {}, entry {}", new Object[]{CompletionValue.this.operationName, bAddress, CompletionValue.this.ledgerId, CompletionValue.this.entryId});
                    }
                    callback.run();
                }
            });
        }

        public void handleV2Response(long ledgerId, long entryId, BookkeeperProtocol.StatusCode status, BookieProtocol.Response response) {
            LOG.warn("Unhandled V2 response {}", (Object)response);
        }

        public abstract void handleV3Response(BookkeeperProtocol.Response var1);
    }

    static enum ConnectionState {
        DISCONNECTED,
        CONNECTING,
        CONNECTED,
        CLOSED,
        START_TLS;

    }
}

