/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.util.Recycler;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieProtocol;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.PacketProcessorBase;
import org.apache.bookkeeper.proto.ResponseBuilder;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteEntryProcessor
extends PacketProcessorBase
implements BookkeeperInternalCallbacks.WriteCallback {
    private static final Logger LOG = LoggerFactory.getLogger(WriteEntryProcessor.class);
    long startTimeNanos;
    private final Recycler.Handle<WriteEntryProcessor> recyclerHandle;
    private static final Recycler<WriteEntryProcessor> RECYCLER = new Recycler<WriteEntryProcessor>(){

        protected WriteEntryProcessor newObject(Recycler.Handle<WriteEntryProcessor> handle) {
            return new WriteEntryProcessor(handle);
        }
    };

    @Override
    protected void reset() {
        super.reset();
        this.startTimeNanos = -1L;
    }

    public static WriteEntryProcessor create(BookieProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        WriteEntryProcessor wep = (WriteEntryProcessor)RECYCLER.get();
        wep.init(request, channel, requestProcessor);
        return wep;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPacket() {
        assert (this.request instanceof BookieProtocol.AddRequest);
        BookieProtocol.AddRequest add = (BookieProtocol.AddRequest)this.request;
        if (this.requestProcessor.bookie.isReadOnly()) {
            LOG.warn("BookieServer is running in readonly mode, so rejecting the request from the client!");
            this.sendResponse(105, ResponseBuilder.buildErrorResponse(105, add), this.requestProcessor.addRequestStats);
            add.release();
            return;
        }
        this.startTimeNanos = MathUtils.nowInNano();
        int rc = 0;
        ByteBuf addData = add.getData();
        try {
            if (add.isRecoveryAdd()) {
                this.requestProcessor.bookie.recoveryAddEntry(addData, this, this.channel, add.getMasterKey());
            } else {
                this.requestProcessor.bookie.addEntry(addData, this, this.channel, add.getMasterKey());
            }
        }
        catch (IOException e) {
            LOG.error("Error writing " + add, (Throwable)e);
            rc = 101;
        }
        catch (BookieException.LedgerFencedException lfe) {
            LOG.error("Attempt to write to fenced ledger", (Throwable)lfe);
            rc = 104;
        }
        catch (BookieException e) {
            LOG.error("Unauthorized access to ledger " + add.getLedgerId(), (Throwable)e);
            rc = 102;
        }
        finally {
            addData.release();
        }
        if (rc != 0) {
            this.requestProcessor.addEntryStats.registerFailedEvent(MathUtils.elapsedNanos((long)this.startTimeNanos), TimeUnit.NANOSECONDS);
            this.sendResponse(rc, ResponseBuilder.buildErrorResponse(rc, add), this.requestProcessor.addRequestStats);
            add.recycle();
        }
    }

    @Override
    public void writeComplete(int rc, long ledgerId, long entryId, BookieSocketAddress addr, Object ctx) {
        if (0 == rc) {
            this.requestProcessor.addEntryStats.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.startTimeNanos), TimeUnit.NANOSECONDS);
        } else {
            this.requestProcessor.addEntryStats.registerFailedEvent(MathUtils.elapsedNanos((long)this.startTimeNanos), TimeUnit.NANOSECONDS);
        }
        this.sendResponse(rc, ResponseBuilder.buildAddResponse(this.request), this.requestProcessor.addRequestStats);
        this.request.recycle();
        this.recycle();
    }

    public String toString() {
        return String.format("WriteEntry(%d, %d)", this.request.getLedgerId(), this.request.getEntryId());
    }

    private void recycle() {
        this.reset();
        this.recyclerHandle.recycle((Object)this);
    }

    private WriteEntryProcessor(Recycler.Handle<WriteEntryProcessor> recyclerHandle) {
        this.recyclerHandle = recyclerHandle;
    }
}

