/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.component;

import com.google.common.collect.Lists;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.List;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.common.component.AbstractLifecycleComponent;
import org.apache.bookkeeper.common.conf.ComponentConfiguration;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.ReflectionUtils;

@InterfaceStability.Evolving
public abstract class ServerLifecycleComponent
extends AbstractLifecycleComponent<BookieConfiguration> {
    public static List<ServerLifecycleComponent> loadServerComponents(String[] componentClassNames, BookieConfiguration conf, StatsLogger statsLogger) {
        ArrayList componentClasses = Lists.newArrayListWithExpectedSize((int)componentClassNames.length);
        for (String componentClsName : componentClassNames) {
            componentClasses.add(ReflectionUtils.forName(componentClsName, ServerLifecycleComponent.class));
        }
        return Lists.transform((List)componentClasses, cls -> ServerLifecycleComponent.newComponent(cls, conf, statsLogger));
    }

    static ServerLifecycleComponent newComponent(Class<? extends ServerLifecycleComponent> theCls, BookieConfiguration conf, StatsLogger statsLogger) {
        try {
            Constructor<? extends ServerLifecycleComponent> constructor = theCls.getConstructor(BookieConfiguration.class, StatsLogger.class);
            constructor.setAccessible(true);
            return constructor.newInstance(new Object[]{conf, statsLogger});
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected ServerLifecycleComponent(String componentName, BookieConfiguration conf, StatsLogger statsLogger) {
        super(componentName, (ComponentConfiguration)conf, statsLogger);
    }
}

