/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.HttpServiceProvider;
import org.apache.bookkeeper.http.service.ErrorHttpService;
import org.apache.bookkeeper.http.service.HeartbeatService;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.Auditor;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.server.http.service.ConfigurationService;
import org.apache.bookkeeper.server.http.service.DecommissionService;
import org.apache.bookkeeper.server.http.service.DeleteLedgerService;
import org.apache.bookkeeper.server.http.service.ExpandStorageService;
import org.apache.bookkeeper.server.http.service.GetLastLogMarkService;
import org.apache.bookkeeper.server.http.service.GetLedgerMetaService;
import org.apache.bookkeeper.server.http.service.ListBookieInfoService;
import org.apache.bookkeeper.server.http.service.ListBookiesService;
import org.apache.bookkeeper.server.http.service.ListDiskFilesService;
import org.apache.bookkeeper.server.http.service.ListLedgerService;
import org.apache.bookkeeper.server.http.service.ListUnderReplicatedLedgerService;
import org.apache.bookkeeper.server.http.service.LostBookieRecoveryDelayService;
import org.apache.bookkeeper.server.http.service.ReadLedgerEntryService;
import org.apache.bookkeeper.server.http.service.RecoveryBookieService;
import org.apache.bookkeeper.server.http.service.TriggerAuditService;
import org.apache.bookkeeper.server.http.service.WhoIsAuditorService;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BKHttpServiceProvider
implements HttpServiceProvider {
    private static final Logger log = LoggerFactory.getLogger(BKHttpServiceProvider.class);
    private final BookieServer bookieServer;
    private final AutoRecoveryMain autoRecovery;
    private final ServerConfiguration serverConf;
    private final ZooKeeper zk;
    private final BookKeeperAdmin bka;
    private final ExecutorService executor;

    private BKHttpServiceProvider(BookieServer bookieServer, AutoRecoveryMain autoRecovery, ServerConfiguration serverConf) throws IOException, KeeperException, InterruptedException, BKException {
        this.bookieServer = bookieServer;
        this.autoRecovery = autoRecovery;
        this.serverConf = serverConf;
        this.zk = ZooKeeperClient.newBuilder().connectString(serverConf.getZkServers()).sessionTimeoutMs(serverConf.getZkTimeout()).build();
        ClientConfiguration clientConfiguration = new ClientConfiguration(serverConf).setZkServers(serverConf.getZkServers());
        this.bka = new BookKeeperAdmin(clientConfiguration);
        this.executor = Executors.newSingleThreadExecutor(new ThreadFactoryBuilder().setNameFormat("BKHttpServiceThread").setDaemon(true).build());
    }

    public void close() throws IOException {
        try {
            this.executor.shutdown();
            if (this.bka != null) {
                this.bka.close();
            }
            if (this.zk != null) {
                this.zk.close();
            }
        }
        catch (InterruptedException | BKException e) {
            log.error("Error while close BKHttpServiceProvider", (Throwable)e);
            throw new IOException("Error while close BKHttpServiceProvider", e);
        }
    }

    private ServerConfiguration getServerConf() {
        return this.serverConf;
    }

    private Auditor getAuditor() {
        return this.autoRecovery == null ? null : this.autoRecovery.getAuditor();
    }

    private Bookie getBookie() {
        return this.bookieServer == null ? null : this.bookieServer.getBookie();
    }

    public HttpEndpointService provideHttpEndpointService(HttpServer.ApiType type) {
        ServerConfiguration configuration = this.getServerConf();
        if (configuration == null) {
            return new ErrorHttpService();
        }
        switch (type) {
            case HEARTBEAT: {
                return new HeartbeatService();
            }
            case SERVER_CONFIG: {
                return new ConfigurationService(configuration);
            }
            case DELETE_LEDGER: {
                return new DeleteLedgerService(configuration);
            }
            case LIST_LEDGER: {
                return new ListLedgerService(configuration, this.zk);
            }
            case GET_LEDGER_META: {
                return new GetLedgerMetaService(configuration, this.zk);
            }
            case READ_LEDGER_ENTRY: {
                return new ReadLedgerEntryService(configuration, this.bka);
            }
            case LIST_BOOKIES: {
                return new ListBookiesService(configuration, this.bka);
            }
            case LIST_BOOKIE_INFO: {
                return new ListBookieInfoService(configuration);
            }
            case LAST_LOG_MARK: {
                return new GetLastLogMarkService(configuration);
            }
            case LIST_DISK_FILE: {
                return new ListDiskFilesService(configuration);
            }
            case EXPAND_STORAGE: {
                return new ExpandStorageService(configuration, this.zk);
            }
            case RECOVERY_BOOKIE: {
                return new RecoveryBookieService(configuration, this.bka, this.executor);
            }
            case LIST_UNDER_REPLICATED_LEDGER: {
                return new ListUnderReplicatedLedgerService(configuration, this.zk);
            }
            case WHO_IS_AUDITOR: {
                return new WhoIsAuditorService(configuration, this.zk);
            }
            case TRIGGER_AUDIT: {
                return new TriggerAuditService(configuration, this.bka);
            }
            case LOST_BOOKIE_RECOVERY_DELAY: {
                return new LostBookieRecoveryDelayService(configuration, this.bka);
            }
            case DECOMMISSION: {
                return new DecommissionService(configuration, this.bka, this.executor);
            }
        }
        return new ConfigurationService(configuration);
    }

    public static class Builder {
        BookieServer bookieServer = null;
        AutoRecoveryMain autoRecovery = null;
        ServerConfiguration serverConf = null;

        public Builder setBookieServer(BookieServer bookieServer) {
            this.bookieServer = bookieServer;
            return this;
        }

        public Builder setAutoRecovery(AutoRecoveryMain autoRecovery) {
            this.autoRecovery = autoRecovery;
            return this;
        }

        public Builder setServerConfiguration(ServerConfiguration conf) {
            this.serverConf = conf;
            return this;
        }

        public BKHttpServiceProvider build() throws IOException, KeeperException, InterruptedException, BKException {
            return new BKHttpServiceProvider(this.bookieServer, this.autoRecovery, this.serverConf);
        }
    }
}

