/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.AbstractFuture;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.util.JsonUtil;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListLedgerService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListLedgerService.class);
    protected ServerConfiguration conf;
    protected ZooKeeper zk;
    static final int LIST_LEDGER_BATCH_SIZE = 100;

    public ListLedgerService(ServerConfiguration conf, ZooKeeper zk) {
        Preconditions.checkNotNull((Object)((Object)conf));
        this.conf = conf;
        this.zk = zk;
    }

    static void keepLedgerMetadata(ReadLedgerMetadataCallback cb, LinkedHashMap<String, String> output) throws Exception {
        LedgerMetadata md = (LedgerMetadata)cb.get();
        output.put(Long.valueOf(cb.getLedgerId()).toString(), new String(md.serialize(), Charsets.UTF_8));
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        if (HttpServer.Method.GET == request.getMethod()) {
            Map params = request.getParams();
            boolean printMeta = params != null && params.containsKey("print_metadata") && ((String)params.get("print_metadata")).equals("true");
            int pageIndex = printMeta && params.containsKey("page") ? Integer.parseInt((String)params.get("page")) : -1;
            LedgerManagerFactory mFactory = LedgerManagerFactory.newLedgerManagerFactory(this.conf, this.zk);
            LedgerManager manager = mFactory.newLedgerManager();
            LedgerManager.LedgerRangeIterator iter = manager.getLedgerRanges();
            LinkedHashMap output = Maps.newLinkedHashMap();
            ArrayList futures = Lists.newArrayListWithExpectedSize((int)100);
            if (printMeta) {
                int ledgerIndex = 0;
                int startLedgerIndex = 0;
                int endLedgerIndex = 0;
                if (pageIndex > 0) {
                    startLedgerIndex = (pageIndex - 1) * 100;
                    endLedgerIndex = startLedgerIndex + 100 - 1;
                }
                while (iter.hasNext()) {
                    LedgerManager.LedgerRange r = iter.next();
                    for (Long lid : r.getLedgers()) {
                        if (endLedgerIndex != 0 && (++ledgerIndex < startLedgerIndex || ledgerIndex > endLedgerIndex)) continue;
                        ReadLedgerMetadataCallback cb = new ReadLedgerMetadataCallback(lid);
                        manager.readLedgerMetadata(lid, cb);
                        futures.add(cb);
                    }
                    if (futures.size() < 100) continue;
                    while (futures.size() > 0) {
                        ReadLedgerMetadataCallback cb = (ReadLedgerMetadataCallback)futures.remove(0);
                        ListLedgerService.keepLedgerMetadata(cb, output);
                    }
                }
                while (futures.size() > 0) {
                    ReadLedgerMetadataCallback cb = (ReadLedgerMetadataCallback)futures.remove(0);
                    ListLedgerService.keepLedgerMetadata(cb, output);
                }
            } else {
                while (iter.hasNext()) {
                    LedgerManager.LedgerRange r = iter.next();
                    for (Long lid : r.getLedgers()) {
                        output.put(lid.toString(), null);
                    }
                }
            }
            manager.close();
            mFactory.uninitialize();
            String jsonResponse = JsonUtil.toJson(output);
            LOG.debug("output body:" + jsonResponse);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }

    public static class ReadLedgerMetadataCallback
    extends AbstractFuture<LedgerMetadata>
    implements BookkeeperInternalCallbacks.GenericCallback<LedgerMetadata> {
        final long ledgerId;

        ReadLedgerMetadataCallback(long ledgerId) {
            this.ledgerId = ledgerId;
        }

        long getLedgerId() {
            return this.ledgerId;
        }

        @Override
        public void operationComplete(int rc, LedgerMetadata result) {
            if (rc != 0) {
                this.setException(BKException.create(rc));
            } else {
                this.set(result);
            }
        }
    }
}

