/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.meta.LedgerUnderreplicationManager;
import org.apache.bookkeeper.util.JsonUtil;
import org.apache.commons.lang.StringUtils;
import org.apache.zookeeper.ZooKeeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListUnderReplicatedLedgerService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(ListUnderReplicatedLedgerService.class);
    protected ServerConfiguration conf;
    protected ZooKeeper zk;

    public ListUnderReplicatedLedgerService(ServerConfiguration conf, ZooKeeper zk) {
        Preconditions.checkNotNull((Object)((Object)conf));
        this.conf = conf;
        this.zk = zk;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        Map params = request.getParams();
        if (HttpServer.Method.GET == request.getMethod()) {
            String includingBookieId = params != null && params.containsKey("missingreplica") ? (String)params.get("missingreplica") : null;
            String excludingBookieId = params != null && params.containsKey("excludingmissingreplica") ? (String)params.get("excludingmissingreplica") : null;
            Predicate<List<String>> predicate = null;
            if (!StringUtils.isBlank((String)includingBookieId) && !StringUtils.isBlank((String)excludingBookieId)) {
                predicate = replicasList -> replicasList.contains(includingBookieId) && !replicasList.contains(excludingBookieId);
            } else if (!StringUtils.isBlank((String)includingBookieId)) {
                predicate = replicasList -> replicasList.contains(includingBookieId);
            } else if (!StringUtils.isBlank((String)excludingBookieId)) {
                predicate = replicasList -> !replicasList.contains(excludingBookieId);
            }
            try {
                ArrayList outputLedgers = Lists.newArrayList();
                LedgerManagerFactory mFactory = LedgerManagerFactory.newLedgerManagerFactory(this.conf, this.zk);
                LedgerUnderreplicationManager underreplicationManager = mFactory.newLedgerUnderreplicationManager();
                Iterator<Long> iter = underreplicationManager.listLedgersToRereplicate(predicate);
                while (iter.hasNext()) {
                    outputLedgers.add(iter.next());
                }
                if (outputLedgers.isEmpty()) {
                    response.setCode(HttpServer.StatusCode.NOT_FOUND);
                    response.setBody("No under replicated ledgers found");
                    return response;
                }
                response.setCode(HttpServer.StatusCode.OK);
                String jsonResponse = JsonUtil.toJson(outputLedgers);
                LOG.debug("output body: " + jsonResponse);
                response.setBody(jsonResponse);
                return response;
            }
            catch (Exception e) {
                LOG.error("Exception occurred while listing under replicated ledgers", (Throwable)e);
                response.setCode(HttpServer.StatusCode.NOT_FOUND);
                response.setBody("Exception when get." + e.getMessage());
                return response;
            }
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

