/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Preconditions;
import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.bookkeeper.bookie.Cookie;
import org.apache.bookkeeper.client.BookKeeperAdmin;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationManager;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.JsonUtil;
import org.apache.bookkeeper.util.ReflectionUtils;
import org.apache.bookkeeper.versioning.Versioned;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RecoveryBookieService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(RecoveryBookieService.class);
    protected ServerConfiguration conf;
    protected BookKeeperAdmin bka;
    protected ExecutorService executor;

    public RecoveryBookieService(ServerConfiguration conf, BookKeeperAdmin bka, ExecutorService executor) {
        Preconditions.checkNotNull((Object)((Object)conf));
        this.conf = conf;
        this.bka = bka;
        this.executor = executor;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        RecoveryRequestJsonBody requestJsonBody;
        HttpServiceResponse response = new HttpServiceResponse();
        String requestBody = request.getBody();
        if (requestBody == null) {
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("No request body provide.");
            return response;
        }
        try {
            requestJsonBody = JsonUtil.fromJson(requestBody, RecoveryRequestJsonBody.class);
            LOG.debug("bookie_src: [" + requestJsonBody.bookie_src.get(0) + "],  delete_cookie: [" + requestJsonBody.delete_cookie + "]");
        }
        catch (JsonUtil.ParseJsonException e) {
            LOG.error("Meet Exception: ", (Throwable)e);
            response.setCode(HttpServer.StatusCode.NOT_FOUND);
            response.setBody("ERROR parameters: " + e.getMessage());
            return response;
        }
        if (HttpServer.Method.PUT == request.getMethod() && !requestJsonBody.bookie_src.isEmpty()) {
            Class<? extends RegistrationManager> rmClass = this.conf.getRegistrationManagerClass();
            RegistrationManager rm = ReflectionUtils.newInstance(rmClass);
            rm.initialize(this.conf, () -> {}, (StatsLogger)NullStatsLogger.INSTANCE);
            String[] bookieSrcString = requestJsonBody.bookie_src.get(0).split(":");
            BookieSocketAddress bookieSrc = new BookieSocketAddress(bookieSrcString[0], Integer.parseInt(bookieSrcString[1]));
            boolean deleteCookie = requestJsonBody.delete_cookie;
            this.executor.execute(() -> {
                try {
                    LOG.info("Start recovering bookie.");
                    this.bka.recoverBookieData(bookieSrc);
                    if (deleteCookie) {
                        Versioned<Cookie> cookie = Cookie.readFromRegistrationManager(rm, bookieSrc);
                        cookie.getValue().deleteFromRegistrationManager(rm, bookieSrc, cookie.getVersion());
                    }
                    LOG.info("Complete recovering bookie");
                }
                catch (Exception e) {
                    LOG.error("Exception occurred while recovering bookie", (Throwable)e);
                }
            });
            response.setCode(HttpServer.StatusCode.OK);
            response.setBody("Success send recovery request command.");
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be PUT method");
        return response;
    }

    static class RecoveryRequestJsonBody {
        public List<String> bookie_src;
        public boolean delete_cookie;

        RecoveryRequestJsonBody() {
        }
    }
}

