/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.service;

import java.io.IOException;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;

public class BookieService
extends ServerLifecycleComponent {
    public static final String NAME = "bookie-server";
    private final BookieServer server;

    public BookieService(BookieConfiguration conf, StatsLogger statsLogger) throws Exception {
        super(NAME, conf, statsLogger);
        this.server = new BookieServer(conf.getServerConf(), statsLogger);
    }

    public BookieServer getServer() {
        return this.server;
    }

    protected void doStart() {
        try {
            this.server.start();
        }
        catch (IOException | InterruptedException | BKException | ReplicationException.UnavailableException e) {
            throw new RuntimeException("Failed to start bookie server", e);
        }
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        this.server.shutdown();
    }
}

