/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import io.netty.buffer.AbstractReferenceCountedByteBuf;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.util.Recycler;
import io.netty.util.ResourceLeakDetector;
import io.netty.util.ResourceLeakDetectorFactory;
import io.netty.util.ResourceLeakTracker;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DoubleByteBuf
extends AbstractReferenceCountedByteBuf {
    private ByteBuf b1;
    private ByteBuf b2;
    private final Recycler.Handle<DoubleByteBuf> recyclerHandle;
    private static final Recycler<DoubleByteBuf> RECYCLER = new Recycler<DoubleByteBuf>(){

        protected DoubleByteBuf newObject(Recycler.Handle<DoubleByteBuf> handle) {
            return new DoubleByteBuf(handle);
        }
    };
    private static final Logger log = LoggerFactory.getLogger(DoubleByteBuf.class);
    private static final ResourceLeakDetector<DoubleByteBuf> leakDetector = ResourceLeakDetectorFactory.instance().newResourceLeakDetector(DoubleByteBuf.class);
    private static final Constructor<ByteBuf> simpleLeakAwareByteBufConstructor;
    private static final Constructor<ByteBuf> advancedLeakAwareByteBufConstructor;

    private DoubleByteBuf(Recycler.Handle<DoubleByteBuf> recyclerHandle) {
        super(Integer.MAX_VALUE);
        this.recyclerHandle = recyclerHandle;
    }

    public static ByteBuf get(ByteBuf b1, ByteBuf b2) {
        DoubleByteBuf buf = (DoubleByteBuf)((Object)RECYCLER.get());
        buf.setRefCnt(1);
        buf.b1 = b1.retain();
        buf.b2 = b2.retain();
        buf.setIndex(0, b1.readableBytes() + b2.readableBytes());
        return DoubleByteBuf.toLeakAwareBuffer(buf);
    }

    public ByteBuf getFirst() {
        return this.b1;
    }

    public ByteBuf getSecond() {
        return this.b2;
    }

    public boolean isDirect() {
        return this.b1.isDirect() && this.b2.isDirect();
    }

    public boolean hasArray() {
        return false;
    }

    public byte[] array() {
        throw new UnsupportedOperationException();
    }

    public int arrayOffset() {
        throw new UnsupportedOperationException();
    }

    public boolean hasMemoryAddress() {
        return false;
    }

    public long memoryAddress() {
        throw new UnsupportedOperationException();
    }

    public int capacity() {
        return this.b1.capacity() + this.b2.capacity();
    }

    public int writableBytes() {
        return 0;
    }

    public DoubleByteBuf capacity(int newCapacity) {
        throw new UnsupportedOperationException();
    }

    public ByteBufAllocator alloc() {
        return PooledByteBufAllocator.DEFAULT;
    }

    @Deprecated
    public ByteOrder order() {
        return ByteOrder.BIG_ENDIAN;
    }

    public byte getByte(int index) {
        if (index < this.b1.writerIndex()) {
            return this.b1.getByte(index);
        }
        return this.b2.getByte(index - this.b1.writerIndex());
    }

    protected byte _getByte(int index) {
        throw new UnsupportedOperationException();
    }

    protected short _getShort(int index) {
        throw new UnsupportedOperationException();
    }

    protected short _getShortLE(int index) {
        throw new UnsupportedOperationException();
    }

    protected int _getUnsignedMediumLE(int index) {
        throw new UnsupportedOperationException();
    }

    protected int _getIntLE(int index) {
        throw new UnsupportedOperationException();
    }

    protected long _getLongLE(int index) {
        throw new UnsupportedOperationException();
    }

    protected void _setShortLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setMediumLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setIntLE(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setLongLE(int index, long value) {
        throw new UnsupportedOperationException();
    }

    public int getBytes(int index, FileChannel out, long position, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, FileChannel in, long position, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    protected int _getUnsignedMedium(int index) {
        throw new UnsupportedOperationException();
    }

    protected int _getInt(int index) {
        throw new UnsupportedOperationException();
    }

    protected long _getLong(int index) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf getBytes(int index, byte[] dst, int dstIndex, int length) {
        return this.getBytes(index, Unpooled.wrappedBuffer((byte[])dst), dstIndex, length);
    }

    public ByteBuf getBytes(int index, ByteBuffer dst) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.checkDstIndex(index, length, dstIndex, dst.capacity());
        if (length == 0) {
            return this;
        }
        int b1Length = Math.min(length, this.b1.readableBytes() - index);
        if (b1Length > 0) {
            this.b1.getBytes(this.b1.readerIndex() + index, dst, dstIndex, b1Length);
            dstIndex += b1Length;
            length -= b1Length;
            index = 0;
        } else {
            index -= this.b1.readableBytes();
        }
        if (length > 0) {
            int b2Length = Math.min(length, this.b2.readableBytes() - index);
            this.b2.getBytes(this.b2.readerIndex() + index, dst, dstIndex, b2Length);
        }
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf getBytes(int index, OutputStream out, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf setByte(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setByte(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf setShort(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setShort(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf setMedium(int index, int value) {
        throw new UnsupportedOperationException();
    }

    protected void _setMedium(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf setInt(int index, int value) {
        return (DoubleByteBuf)super.setInt(index, value);
    }

    protected void _setInt(int index, int value) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf setLong(int index, long value) {
        throw new UnsupportedOperationException();
    }

    protected void _setLong(int index, long value) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf setBytes(int index, byte[] src, int srcIndex, int length) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf setBytes(int index, ByteBuffer src) {
        throw new UnsupportedOperationException();
    }

    public DoubleByteBuf setBytes(int index, ByteBuf src, int srcIndex, int length) {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        throw new UnsupportedOperationException();
    }

    public ByteBuf copy(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public int nioBufferCount() {
        return this.b1.nioBufferCount() + this.b2.nioBufferCount();
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        throw new UnsupportedOperationException();
    }

    public ByteBuffer nioBuffer(int index, int length) {
        ByteBuffer dst = this.isDirect() ? ByteBuffer.allocateDirect(length) : ByteBuffer.allocate(length);
        ByteBuf b = Unpooled.wrappedBuffer((ByteBuffer)dst);
        b.writerIndex(0);
        this.getBytes(index, b, length);
        return dst;
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return new ByteBuffer[]{this.nioBuffer(index, length)};
    }

    public DoubleByteBuf discardReadBytes() {
        throw new UnsupportedOperationException();
    }

    public String toString() {
        String result = super.toString();
        result = result.substring(0, result.length() - 1);
        return result + ", components=2)";
    }

    public ByteBuffer[] nioBuffers() {
        return this.nioBuffers(this.readerIndex(), this.readableBytes());
    }

    protected void deallocate() {
        this.b1.release(2);
        this.b2.release(2);
        this.b2 = null;
        this.b1 = null;
        this.recyclerHandle.recycle((Object)this);
    }

    public ByteBuf unwrap() {
        return null;
    }

    private static ByteBuf toLeakAwareBuffer(DoubleByteBuf buf) {
        try {
            switch (ResourceLeakDetector.getLevel()) {
                case DISABLED: {
                    break;
                }
                case SIMPLE: {
                    ResourceLeakTracker leak = leakDetector.track((Object)buf);
                    if (leak == null) break;
                    return simpleLeakAwareByteBufConstructor.newInstance(new Object[]{buf, leak});
                }
                case ADVANCED: 
                case PARANOID: {
                    ResourceLeakTracker leak = leakDetector.track((Object)buf);
                    if (leak == null) break;
                    return advancedLeakAwareByteBufConstructor.newInstance(new Object[]{buf, leak});
                }
            }
            return buf;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Constructor<?> tmpSimpleLeakAwareByteBufConstructor = null;
        Constructor<?> tmpAdvancedLeakAwareByteBufConstructor = null;
        try {
            Class<?> simpleLeakAwareByteBufClass = Class.forName("io.netty.buffer.SimpleLeakAwareByteBuf");
            tmpSimpleLeakAwareByteBufConstructor = simpleLeakAwareByteBufClass.getDeclaredConstructor(ByteBuf.class, ResourceLeakTracker.class);
            tmpSimpleLeakAwareByteBufConstructor.setAccessible(true);
            Class<?> advancedLeakAwareByteBufClass = Class.forName("io.netty.buffer.AdvancedLeakAwareByteBuf");
            tmpAdvancedLeakAwareByteBufConstructor = advancedLeakAwareByteBufClass.getDeclaredConstructor(ByteBuf.class, ResourceLeakTracker.class);
            tmpAdvancedLeakAwareByteBufConstructor.setAccessible(true);
        }
        catch (Throwable t) {
            log.error("Failed to use reflection to enable leak detection", t);
        }
        finally {
            simpleLeakAwareByteBufConstructor = tmpSimpleLeakAwareByteBufConstructor;
            advancedLeakAwareByteBufConstructor = tmpAdvancedLeakAwareByteBufConstructor;
        }
    }
}

