/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.util;

import com.google.common.util.concurrent.ListenableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.SafeRunnable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderedSafeExecutor
extends OrderedScheduler {
    public static Builder newBuilder() {
        return new Builder();
    }

    private OrderedSafeExecutor(String baseName, int numThreads, ThreadFactory threadFactory, StatsLogger statsLogger, boolean traceTaskExecution, long warnTimeMicroSec, int maxTasksInQueue) {
        super(baseName, numThreads, threadFactory, statsLogger, traceTaskExecution, warnTimeMicroSec, maxTasksInQueue);
    }

    public void submit(SafeRunnable r) {
        super.submit((org.apache.bookkeeper.common.util.SafeRunnable)r);
    }

    public ListenableFuture<?> submitOrdered(Object orderingKey, SafeRunnable r) {
        return super.submitOrdered(orderingKey, (org.apache.bookkeeper.common.util.SafeRunnable)r);
    }

    public void submitOrdered(long orderingKey, SafeRunnable r) {
        super.submitOrdered(orderingKey, (org.apache.bookkeeper.common.util.SafeRunnable)r);
    }

    public void submitOrdered(int orderingKey, SafeRunnable r) {
        super.submitOrdered(orderingKey, (org.apache.bookkeeper.common.util.SafeRunnable)r);
    }

    public ScheduledFuture<?> schedule(SafeRunnable command, long delay, TimeUnit unit) {
        return super.schedule((org.apache.bookkeeper.common.util.SafeRunnable)command, delay, unit);
    }

    public ScheduledFuture<?> scheduleOrdered(Object orderingKey, SafeRunnable command, long delay, TimeUnit unit) {
        return super.scheduleOrdered(orderingKey, (org.apache.bookkeeper.common.util.SafeRunnable)command, delay, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRate(SafeRunnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRate((org.apache.bookkeeper.common.util.SafeRunnable)command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleAtFixedRateOrdered(Object orderingKey, SafeRunnable command, long initialDelay, long period, TimeUnit unit) {
        return super.scheduleAtFixedRateOrdered(orderingKey, (org.apache.bookkeeper.common.util.SafeRunnable)command, initialDelay, period, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelay(SafeRunnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelay((org.apache.bookkeeper.common.util.SafeRunnable)command, initialDelay, delay, unit);
    }

    public ScheduledFuture<?> scheduleWithFixedDelayOrdered(Object orderingKey, SafeRunnable command, long initialDelay, long delay, TimeUnit unit) {
        return super.scheduleWithFixedDelayOrdered(orderingKey, (org.apache.bookkeeper.common.util.SafeRunnable)command, initialDelay, delay, unit);
    }

    public static abstract class OrderedSafeGenericCallback<T>
    implements BookkeeperInternalCallbacks.GenericCallback<T> {
        private static final Logger LOG = LoggerFactory.getLogger(OrderedSafeGenericCallback.class);
        private final OrderedSafeExecutor executor;
        private final long orderingKey;

        public OrderedSafeGenericCallback(OrderedSafeExecutor executor, long orderingKey) {
            this.executor = executor;
            this.orderingKey = orderingKey;
        }

        @Override
        public final void operationComplete(final int rc, final T result) {
            if (Thread.currentThread().getId() == this.executor.getThreadID(this.orderingKey)) {
                this.safeOperationComplete(rc, result);
            } else {
                try {
                    this.executor.submitOrdered(this.orderingKey, new SafeRunnable(){

                        public void safeRun() {
                            this.safeOperationComplete(rc, result);
                        }

                        public String toString() {
                            return String.format("Callback(key=%s, name=%s)", orderingKey, this);
                        }
                    });
                }
                catch (RejectedExecutionException re) {
                    LOG.warn("Failed to submit callback for {} : ", (Object)this.orderingKey, (Object)re);
                }
            }
        }

        public abstract void safeOperationComplete(int var1, T var2);
    }

    public static class Builder
    extends OrderedScheduler.AbstractBuilder<OrderedSafeExecutor> {
        public OrderedSafeExecutor build() {
            if (null == this.threadFactory) {
                this.threadFactory = Executors.defaultThreadFactory();
            }
            return new OrderedSafeExecutor(this.name, this.numThreads, this.threadFactory, this.statsLogger, this.traceTaskExecution, this.warnTimeMicroSec, this.maxTasksInQueue);
        }
    }
}

