/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client.api;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.apache.bookkeeper.client.api.BKException;
import org.apache.bookkeeper.client.api.ReadHandle;
import org.apache.bookkeeper.common.annotation.InterfaceAudience;
import org.apache.bookkeeper.common.annotation.InterfaceStability;
import org.apache.bookkeeper.common.concurrent.FutureUtils;

@InterfaceAudience.Public
@InterfaceStability.Unstable
public interface WriteAdvHandle
extends ReadHandle {
    default public CompletableFuture<Long> writeAsync(long entryId, ByteBuffer data) {
        return this.writeAsync(entryId, Unpooled.wrappedBuffer((ByteBuffer)data));
    }

    default public long write(long entryId, ByteBuffer data) throws BKException, InterruptedException {
        return this.write(entryId, Unpooled.wrappedBuffer((ByteBuffer)data));
    }

    default public CompletableFuture<Long> writeAsync(long entryId, byte[] data) {
        return this.writeAsync(entryId, Unpooled.wrappedBuffer((byte[])data));
    }

    default public long write(long entryId, byte[] data) throws BKException, InterruptedException {
        return this.write(entryId, Unpooled.wrappedBuffer((byte[])data));
    }

    default public CompletableFuture<Long> writeAsync(long entryId, byte[] data, int offset, int length) {
        return this.writeAsync(entryId, Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length));
    }

    default public long write(long entryId, byte[] data, int offset, int length) throws BKException, InterruptedException {
        return this.write(entryId, Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)length));
    }

    public CompletableFuture<Long> writeAsync(long var1, ByteBuf var3);

    default public long write(long entryId, ByteBuf data) throws BKException, InterruptedException {
        return (Long)FutureUtils.result(this.writeAsync(entryId, data), BKException.HANDLER);
    }
}

