/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.service;

import java.io.IOException;
import org.apache.bookkeeper.replication.AutoRecoveryMain;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.server.component.ServerLifecycleComponent;
import org.apache.bookkeeper.server.conf.BookieConfiguration;
import org.apache.bookkeeper.stats.StatsLogger;

public class AutoRecoveryService
extends ServerLifecycleComponent {
    public static final String NAME = "autorecovery";
    private final AutoRecoveryMain main;

    public AutoRecoveryService(BookieConfiguration conf, StatsLogger statsLogger) throws Exception {
        super(NAME, conf, statsLogger);
        this.main = new AutoRecoveryMain(conf.getServerConf(), statsLogger);
    }

    protected void doStart() {
        try {
            this.main.start();
        }
        catch (ReplicationException.UnavailableException e) {
            throw new RuntimeException("Can't not start 'autorecovery' component.", e);
        }
    }

    protected void doStop() {
    }

    protected void doClose() throws IOException {
        this.main.shutdown();
    }
}

