/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.util.concurrent.RateLimiter;
import org.apache.bookkeeper.bookie.EntryLogMetadata;
import org.apache.bookkeeper.bookie.GarbageCollectorThread;
import org.apache.bookkeeper.conf.ServerConfiguration;

public abstract class AbstractLogCompactor {
    protected final ServerConfiguration conf;
    protected final Throttler throttler;
    protected final GarbageCollectorThread gcThread;

    public AbstractLogCompactor(GarbageCollectorThread gcThread) {
        this.gcThread = gcThread;
        this.conf = gcThread.conf;
        this.throttler = new Throttler(this.conf);
    }

    public abstract boolean compact(EntryLogMetadata var1);

    public void cleanUpAndRecover() {
    }

    static class Throttler {
        private final RateLimiter rateLimiter;
        private final boolean isThrottleByBytes;

        Throttler(ServerConfiguration conf) {
            this.isThrottleByBytes = conf.getIsThrottleByBytes();
            this.rateLimiter = RateLimiter.create((double)(this.isThrottleByBytes ? (double)conf.getCompactionRateByBytes() : (double)conf.getCompactionRateByEntries()));
        }

        void acquire(int permits) {
            this.rateLimiter.acquire(this.isThrottleByBytes ? permits : 1);
        }
    }
}

