/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieStateManager;
import org.apache.bookkeeper.bookie.CacheCallback;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.EntryKeyValue;
import org.apache.bookkeeper.bookie.EntryMemTable;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.SkipListFlusher;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SortedLedgerStorage
extends InterleavedLedgerStorage
implements LedgerStorage,
CacheCallback,
SkipListFlusher {
    private static final Logger LOG = LoggerFactory.getLogger(SortedLedgerStorage.class);
    EntryMemTable memTable;
    private ScheduledExecutorService scheduler;
    private StateManager stateManager;

    @Override
    public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger) throws IOException {
        super.initialize(conf, ledgerManager, ledgerDirsManager, indexDirsManager, stateManager, checkpointSource, checkpointer, statsLogger);
        this.memTable = new EntryMemTable(conf, checkpointSource, statsLogger);
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setNameFormat("SortedLedgerStorage-%d").setPriority(7).build());
        this.stateManager = stateManager;
    }

    @VisibleForTesting
    ScheduledExecutorService getScheduler() {
        return this.scheduler;
    }

    @Override
    public void start() {
        try {
            this.flush();
        }
        catch (IOException e) {
            LOG.error("Exception thrown while flushing ledger cache.", (Throwable)e);
        }
        super.start();
    }

    @Override
    public void shutdown() throws InterruptedException {
        this.scheduler.shutdown();
        if (!this.scheduler.awaitTermination(3L, TimeUnit.SECONDS)) {
            this.scheduler.shutdownNow();
        }
        super.shutdown();
    }

    @Override
    public boolean ledgerExists(long ledgerId) throws IOException {
        EntryKeyValue kv;
        if (!super.ledgerExists(ledgerId) && null == (kv = this.memTable.getLastEntry(ledgerId))) {
            return super.ledgerExists(ledgerId);
        }
        return true;
    }

    @Override
    public long addEntry(ByteBuf entry) throws IOException {
        long ledgerId = entry.getLong(entry.readerIndex() + 0);
        long entryId = entry.getLong(entry.readerIndex() + 8);
        long lac = entry.getLong(entry.readerIndex() + 16);
        this.memTable.addEntry(ledgerId, entryId, entry.nioBuffer(), this);
        this.ledgerCache.updateLastAddConfirmed(ledgerId, lac);
        return entryId;
    }

    private ByteBuf getLastEntryId(long ledgerId) throws IOException {
        EntryKeyValue kv = this.memTable.getLastEntry(ledgerId);
        if (null != kv) {
            return kv.getValueAsByteBuffer();
        }
        return super.getEntry(ledgerId, -1L);
    }

    @Override
    public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
        ByteBuf buffToRet;
        if (entryId == -1L) {
            return this.getLastEntryId(ledgerId);
        }
        try {
            buffToRet = super.getEntry(ledgerId, entryId);
        }
        catch (Bookie.NoEntryException nee) {
            EntryKeyValue kv = this.memTable.getEntry(ledgerId, entryId);
            buffToRet = null == kv ? super.getEntry(ledgerId, entryId) : kv.getValueAsByteBuffer();
        }
        return buffToRet;
    }

    @Override
    public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        long numBytesFlushed = this.memTable.flush(this, checkpoint);
        if (numBytesFlushed > 0L) {
            this.entryLogger.rollLog();
        }
        super.checkpoint(checkpoint);
    }

    @Override
    public void process(long ledgerId, long entryId, ByteBuf buffer) throws IOException {
        this.processEntry(ledgerId, entryId, buffer, false);
    }

    @Override
    public void flush() throws IOException {
        this.memTable.flush(this, CheckpointSource.Checkpoint.MAX);
        super.flush();
    }

    @Override
    public void onSizeLimitReached(final CheckpointSource.Checkpoint cp) throws IOException {
        LOG.info("Reached size {}", (Object)cp);
        this.scheduler.execute(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.info("Started flushing mem table.");
                    long logIdBeforeFlush = SortedLedgerStorage.this.entryLogger.getCurrentLogId();
                    SortedLedgerStorage.this.memTable.flush(SortedLedgerStorage.this);
                    long logIdAfterFlush = SortedLedgerStorage.this.entryLogger.getCurrentLogId();
                    if (SortedLedgerStorage.this.entryLogger.reachEntryLogLimit(0L) || logIdAfterFlush != logIdBeforeFlush) {
                        LOG.info("Rolling entry logger since it reached size limitation");
                        SortedLedgerStorage.this.entryLogger.rollLog();
                        SortedLedgerStorage.this.checkpointer.startCheckpoint(cp);
                    }
                }
                catch (IOException e) {
                    SortedLedgerStorage.this.stateManager.transitionToReadOnlyMode();
                    LOG.error("Exception thrown while flushing skip list cache.", (Throwable)e);
                }
            }
        });
    }

    @Override
    public void onRotateEntryLog() {
    }

    BookieStateManager getStateManager() {
        return (BookieStateManager)this.stateManager;
    }
}

