/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.AsyncCallback;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.client.LedgerHandleAdv;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.SyncCallbackUtils;
import org.apache.bookkeeper.client.api.CreateAdvBuilder;
import org.apache.bookkeeper.client.api.CreateBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.WriteAdvHandle;
import org.apache.bookkeeper.client.api.WriteFlag;
import org.apache.bookkeeper.client.api.WriteHandle;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.stats.OpStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class LedgerCreateOp
implements BookkeeperInternalCallbacks.GenericCallback<Void> {
    static final Logger LOG = LoggerFactory.getLogger(LedgerCreateOp.class);
    final AsyncCallback.CreateCallback cb;
    final LedgerMetadata metadata;
    LedgerHandle lh;
    long ledgerId = -1L;
    final Object ctx;
    final byte[] passwd;
    final BookKeeper bk;
    final BookKeeper.DigestType digestType;
    final EnumSet<WriteFlag> writeFlags;
    final long startTime;
    final OpStatsLogger createOpLogger;
    boolean adv = false;
    boolean generateLedgerId = true;
    private final StatsLogger statsLogger;

    LedgerCreateOp(BookKeeper bk, int ensembleSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] passwd, AsyncCallback.CreateCallback cb, Object ctx, Map<String, byte[]> customMetadata, EnumSet<WriteFlag> writeFlags, StatsLogger statsLogger) {
        this.bk = bk;
        this.metadata = new LedgerMetadata(ensembleSize, writeQuorumSize, ackQuorumSize, digestType, passwd, customMetadata, bk.getConf().getStoreSystemtimeAsLedgerCreationTime());
        this.digestType = digestType;
        this.writeFlags = writeFlags;
        this.passwd = passwd;
        this.cb = cb;
        this.ctx = ctx;
        this.startTime = MathUtils.nowInNano();
        this.createOpLogger = bk.getCreateOpLogger();
        this.statsLogger = statsLogger;
    }

    public void initiate() {
        ArrayList<BookieSocketAddress> ensemble;
        try {
            ensemble = this.bk.getBookieWatcher().newEnsemble(this.metadata.getEnsembleSize(), this.metadata.getWriteQuorumSize(), this.metadata.getAckQuorumSize(), this.metadata.getCustomMetadata());
        }
        catch (BKException.BKNotEnoughBookiesException e) {
            LOG.error("Not enough bookies to create ledger");
            this.createComplete(e.getCode(), null);
            return;
        }
        this.metadata.addEnsemble(0L, ensemble);
        if (this.generateLedgerId) {
            this.generateLedgerIdAndCreateLedger();
        } else {
            this.bk.getLedgerManager().createLedgerMetadata(this.ledgerId, this.metadata, this);
        }
    }

    void generateLedgerIdAndCreateLedger() {
        LedgerIdGenerator ledgerIdGenerator = this.bk.getLedgerIdGenerator();
        ledgerIdGenerator.generateLedgerId(new BookkeeperInternalCallbacks.GenericCallback<Long>(){

            @Override
            public void operationComplete(int rc, Long ledgerId) {
                if (0 != rc) {
                    LedgerCreateOp.this.createComplete(rc, null);
                    return;
                }
                LedgerCreateOp.this.ledgerId = ledgerId;
                LedgerCreateOp.this.bk.getLedgerManager().createLedgerMetadata(ledgerId, LedgerCreateOp.this.metadata, LedgerCreateOp.this);
            }
        });
    }

    public void initiateAdv(long ledgerId) {
        this.adv = true;
        this.ledgerId = ledgerId;
        if (this.ledgerId != -1L) {
            this.generateLedgerId = false;
        }
        this.initiate();
    }

    @Override
    public void operationComplete(int rc, Void result) {
        if (this.generateLedgerId && -20 == rc) {
            this.generateLedgerIdAndCreateLedger();
            return;
        }
        if (0 != rc) {
            this.createComplete(rc, null);
            return;
        }
        try {
            this.lh = this.adv ? new LedgerHandleAdv(this.bk, this.ledgerId, this.metadata, this.digestType, this.passwd, this.writeFlags) : new LedgerHandle(this.bk, this.ledgerId, this.metadata, this.digestType, this.passwd, this.writeFlags);
        }
        catch (GeneralSecurityException e) {
            LOG.error("Security exception while creating ledger: " + this.ledgerId, (Throwable)e);
            this.createComplete(-4, null);
            return;
        }
        catch (NumberFormatException e) {
            LOG.error("Incorrectly entered parameter throttle: " + this.bk.getConf().getThrottleValue(), (Throwable)e);
            this.createComplete(-14, null);
            return;
        }
        ArrayList<BookieSocketAddress> curEns = this.lh.getLedgerMetadata().getEnsemble(0L);
        LOG.info("Ensemble: {} for ledger: {}", curEns, (Object)this.lh.getId());
        for (BookieSocketAddress bsa : curEns) {
            String ensSpread = "LEDGER_ENSEMBLE_BOOKIE_DISTRIBUTION-" + bsa;
            this.statsLogger.getCounter(ensSpread).inc();
        }
        this.createComplete(0, this.lh);
    }

    private void createComplete(int rc, LedgerHandle lh) {
        if (0 != rc) {
            this.createOpLogger.registerFailedEvent(MathUtils.elapsedNanos((long)this.startTime), TimeUnit.NANOSECONDS);
        } else {
            this.createOpLogger.registerSuccessfulEvent(MathUtils.elapsedNanos((long)this.startTime), TimeUnit.NANOSECONDS);
        }
        this.cb.createComplete(rc, lh, this.ctx);
    }

    private static class CreateAdvBuilderImpl
    implements CreateAdvBuilder {
        private Long builderLedgerId;
        private final CreateBuilderImpl parent;

        private CreateAdvBuilderImpl(CreateBuilderImpl parent) {
            this.parent = parent;
        }

        @Override
        public CreateAdvBuilder withLedgerId(long ledgerId) {
            this.builderLedgerId = ledgerId;
            return this;
        }

        @Override
        public CompletableFuture<WriteAdvHandle> execute() {
            CompletableFuture<WriteAdvHandle> future = new CompletableFuture<WriteAdvHandle>();
            SyncCallbackUtils.SyncCreateAdvCallback callback = new SyncCallbackUtils.SyncCreateAdvCallback(future);
            this.create(callback);
            return future;
        }

        private boolean validate() {
            if (!this.parent.validate()) {
                return false;
            }
            if (this.builderLedgerId != null && this.builderLedgerId < 0L) {
                LOG.error("invalid ledgerId {} < 0. Do not set en explicit value if you want automatic generation", (Object)this.builderLedgerId);
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create(AsyncCallback.CreateCallback cb) {
            if (!this.validate()) {
                cb.createComplete(-14, null, null);
                return;
            }
            LedgerCreateOp op = new LedgerCreateOp(this.parent.bk, this.parent.builderEnsembleSize, this.parent.builderWriteQuorumSize, this.parent.builderAckQuorumSize, BookKeeper.DigestType.fromApiDigestType(this.parent.builderDigestType), this.parent.builderPassword, cb, null, this.parent.builderCustomMetadata, this.parent.builderWriteFlags, this.parent.bk.getStatsLogger());
            ReentrantReadWriteLock closeLock = this.parent.bk.getCloseLock();
            closeLock.readLock().lock();
            try {
                if (this.parent.bk.isClosed()) {
                    cb.createComplete(-19, null, null);
                    return;
                }
                op.initiateAdv(this.builderLedgerId == null ? -1L : this.builderLedgerId);
            }
            finally {
                closeLock.readLock().unlock();
            }
        }
    }

    public static class CreateBuilderImpl
    implements CreateBuilder {
        private final BookKeeper bk;
        private int builderEnsembleSize = 3;
        private int builderAckQuorumSize = 2;
        private int builderWriteQuorumSize = 2;
        private byte[] builderPassword;
        private EnumSet<WriteFlag> builderWriteFlags = EnumSet.noneOf(WriteFlag.class);
        private DigestType builderDigestType = DigestType.CRC32;
        private Map<String, byte[]> builderCustomMetadata = Collections.emptyMap();

        CreateBuilderImpl(BookKeeper bk) {
            this.bk = bk;
        }

        @Override
        public CreateBuilder withEnsembleSize(int ensembleSize) {
            this.builderEnsembleSize = ensembleSize;
            return this;
        }

        public CreateBuilder withWriteFlags(EnumSet<WriteFlag> writeFlags) {
            this.builderWriteFlags = writeFlags;
            return this;
        }

        public CreateBuilder withWriteFlags(WriteFlag ... writeFlags) {
            return this.withWriteFlags(EnumSet.copyOf(Arrays.asList(writeFlags)));
        }

        @Override
        public CreateBuilder withWriteQuorumSize(int writeQuorumSize) {
            this.builderWriteQuorumSize = writeQuorumSize;
            return this;
        }

        @Override
        public CreateBuilder withAckQuorumSize(int ackQuorumSize) {
            this.builderAckQuorumSize = ackQuorumSize;
            return this;
        }

        @Override
        @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
        public CreateBuilder withPassword(byte[] password) {
            this.builderPassword = password;
            return this;
        }

        @Override
        public CreateBuilder withCustomMetadata(Map<String, byte[]> customMetadata) {
            this.builderCustomMetadata = customMetadata;
            return this;
        }

        @Override
        public CreateBuilder withDigestType(DigestType digestType) {
            this.builderDigestType = digestType;
            return this;
        }

        @Override
        public CreateAdvBuilder makeAdv() {
            return new CreateAdvBuilderImpl(this);
        }

        private boolean validate() {
            if (this.builderWriteFlags == null) {
                LOG.error("invalid null writeFlags");
                return false;
            }
            if (this.builderWriteQuorumSize > this.builderEnsembleSize) {
                LOG.error("invalid writeQuorumSize {} > ensembleSize {}", (Object)this.builderWriteQuorumSize, (Object)this.builderEnsembleSize);
                return false;
            }
            if (this.builderAckQuorumSize > this.builderWriteQuorumSize) {
                LOG.error("invalid ackQuorumSize {} > writeQuorumSize {}", (Object)this.builderAckQuorumSize, (Object)this.builderWriteQuorumSize);
                return false;
            }
            if (this.builderAckQuorumSize <= 0) {
                LOG.error("invalid ackQuorumSize {} <= 0", (Object)this.builderAckQuorumSize);
                return false;
            }
            if (this.builderPassword == null) {
                LOG.error("invalid null password");
                return false;
            }
            if (this.builderDigestType == null) {
                LOG.error("invalid null digestType");
                return false;
            }
            if (this.builderCustomMetadata == null) {
                LOG.error("invalid null customMetadata");
                return false;
            }
            return true;
        }

        @Override
        public CompletableFuture<WriteHandle> execute() {
            CompletableFuture<WriteHandle> future = new CompletableFuture<WriteHandle>();
            SyncCallbackUtils.SyncCreateCallback callback = new SyncCallbackUtils.SyncCreateCallback(future);
            this.create(callback);
            return future;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void create(AsyncCallback.CreateCallback cb) {
            if (!this.validate()) {
                cb.createComplete(-14, null, null);
                return;
            }
            LedgerCreateOp op = new LedgerCreateOp(this.bk, this.builderEnsembleSize, this.builderWriteQuorumSize, this.builderAckQuorumSize, BookKeeper.DigestType.fromApiDigestType(this.builderDigestType), this.builderPassword, cb, null, this.builderCustomMetadata, this.builderWriteFlags, this.bk.getStatsLogger());
            ReentrantReadWriteLock closeLock = this.bk.getCloseLock();
            closeLock.readLock().lock();
            try {
                if (this.bk.isClosed()) {
                    cb.createComplete(-19, null, null);
                    return;
                }
                op.initiate();
            }
            finally {
                closeLock.readLock().unlock();
            }
        }
    }
}

