/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Charsets;
import com.google.common.base.Optional;
import com.google.common.collect.Maps;
import com.google.protobuf.ByteString;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.StringReader;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.versioning.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LedgerMetadata
implements org.apache.bookkeeper.client.api.LedgerMetadata {
    static final Logger LOG = LoggerFactory.getLogger(LedgerMetadata.class);
    private static final String closed = "CLOSED";
    private static final String lSplitter = "\n";
    private static final String tSplitter = "\t";
    private static final int NOTCLOSED = -101;
    private static final int IN_RECOVERY = -102;
    public static final int LOWEST_COMPAT_METADATA_FORMAT_VERSION = 0;
    public static final int CURRENT_METADATA_FORMAT_VERSION = 2;
    public static final String VERSION_KEY = "BookieMetadataFormatVersion";
    private int metadataFormatVersion = 0;
    private int ensembleSize;
    private int writeQuorumSize;
    private int ackQuorumSize;
    private long length;
    private long lastEntryId;
    private long ctime;
    private boolean storeSystemtimeAsLedgerCreationTime;
    private DataFormats.LedgerMetadataFormat.State state;
    private TreeMap<Long, ArrayList<BookieSocketAddress>> ensembles = new TreeMap();
    ArrayList<BookieSocketAddress> currentEnsemble;
    volatile Version version = Version.NEW;
    private boolean hasPassword = false;
    private DataFormats.LedgerMetadataFormat.DigestType digestType;
    private byte[] password;
    private Map<String, byte[]> customMetadata = Maps.newHashMap();

    public LedgerMetadata(int ensembleSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] password, Map<String, byte[]> customMetadata, boolean storeSystemtimeAsLedgerCreationTime) {
        this.ensembleSize = ensembleSize;
        this.writeQuorumSize = writeQuorumSize;
        this.ackQuorumSize = ackQuorumSize;
        this.ctime = storeSystemtimeAsLedgerCreationTime ? System.currentTimeMillis() : -1L;
        this.storeSystemtimeAsLedgerCreationTime = storeSystemtimeAsLedgerCreationTime;
        this.length = 0L;
        this.state = DataFormats.LedgerMetadataFormat.State.OPEN;
        this.lastEntryId = -1L;
        this.metadataFormatVersion = 2;
        this.digestType = digestType.equals((Object)BookKeeper.DigestType.MAC) ? DataFormats.LedgerMetadataFormat.DigestType.HMAC : DataFormats.LedgerMetadataFormat.DigestType.valueOf((String)digestType.toString());
        this.password = Arrays.copyOf(password, password.length);
        this.hasPassword = true;
        if (customMetadata != null) {
            this.customMetadata = customMetadata;
        }
    }

    @VisibleForTesting
    public LedgerMetadata(int ensembleSize, int writeQuorumSize, int ackQuorumSize, BookKeeper.DigestType digestType, byte[] password) {
        this(ensembleSize, writeQuorumSize, ackQuorumSize, digestType, password, null, false);
    }

    LedgerMetadata(LedgerMetadata other) {
        this.ensembleSize = other.ensembleSize;
        this.writeQuorumSize = other.writeQuorumSize;
        this.ackQuorumSize = other.ackQuorumSize;
        this.length = other.length;
        this.lastEntryId = other.lastEntryId;
        this.metadataFormatVersion = other.metadataFormatVersion;
        this.state = other.state;
        this.version = other.version;
        this.hasPassword = other.hasPassword;
        this.digestType = other.digestType;
        this.ctime = other.ctime;
        this.storeSystemtimeAsLedgerCreationTime = other.storeSystemtimeAsLedgerCreationTime;
        this.password = new byte[other.password.length];
        System.arraycopy(other.password, 0, this.password, 0, other.password.length);
        for (Map.Entry<Long, ArrayList<BookieSocketAddress>> entry : other.ensembles.entrySet()) {
            long startEntryId = entry.getKey();
            ArrayList<BookieSocketAddress> newEnsemble = new ArrayList<BookieSocketAddress>((Collection)entry.getValue());
            this.addEnsemble(startEntryId, newEnsemble);
        }
        this.customMetadata = other.customMetadata;
    }

    private LedgerMetadata() {
        this(0, 0, 0, BookKeeper.DigestType.MAC, new byte[0]);
        this.hasPassword = false;
    }

    public TreeMap<Long, ArrayList<BookieSocketAddress>> getEnsembles() {
        return this.ensembles;
    }

    @Override
    public NavigableMap<Long, ? extends List<BookieSocketAddress>> getAllEnsembles() {
        return this.ensembles;
    }

    void setEnsembles(TreeMap<Long, ArrayList<BookieSocketAddress>> ensembles) {
        this.ensembles = ensembles;
    }

    @Override
    public int getEnsembleSize() {
        return this.ensembleSize;
    }

    @Override
    public int getWriteQuorumSize() {
        return this.writeQuorumSize;
    }

    @Override
    public int getAckQuorumSize() {
        return this.ackQuorumSize;
    }

    @Override
    public long getCtime() {
        return this.ctime;
    }

    @VisibleForTesting
    void setCtime(long ctime) {
        this.ctime = ctime;
    }

    boolean hasPassword() {
        return this.hasPassword;
    }

    @VisibleForTesting
    public byte[] getPassword() {
        return Arrays.copyOf(this.password, this.password.length);
    }

    @Override
    public DigestType getDigestType() {
        switch (this.digestType) {
            case HMAC: {
                return DigestType.MAC;
            }
            case CRC32: {
                return DigestType.CRC32;
            }
            case CRC32C: {
                return DigestType.CRC32C;
            }
            case DUMMY: {
                return DigestType.DUMMY;
            }
        }
        throw new IllegalArgumentException("Unable to convert digest type " + this.digestType);
    }

    @Override
    public long getLastEntryId() {
        return this.lastEntryId;
    }

    @Override
    public long getLength() {
        return this.length;
    }

    void setLength(long length) {
        this.length = length;
    }

    @Override
    public boolean isClosed() {
        return this.state == DataFormats.LedgerMetadataFormat.State.CLOSED;
    }

    public boolean isInRecovery() {
        return this.state == DataFormats.LedgerMetadataFormat.State.IN_RECOVERY;
    }

    public DataFormats.LedgerMetadataFormat.State getState() {
        return this.state;
    }

    void setState(DataFormats.LedgerMetadataFormat.State state) {
        this.state = state;
    }

    void markLedgerInRecovery() {
        this.state = DataFormats.LedgerMetadataFormat.State.IN_RECOVERY;
    }

    void close(long entryId) {
        this.lastEntryId = entryId;
        this.state = DataFormats.LedgerMetadataFormat.State.CLOSED;
    }

    public void addEnsemble(long startEntryId, ArrayList<BookieSocketAddress> ensemble) {
        assert (this.ensembles.isEmpty() || startEntryId >= this.ensembles.lastKey());
        this.ensembles.put(startEntryId, ensemble);
        this.currentEnsemble = ensemble;
    }

    ArrayList<BookieSocketAddress> getEnsemble(long entryId) {
        return this.ensembles.get(this.ensembles.headMap(entryId + 1L).lastKey());
    }

    @Override
    public List<BookieSocketAddress> getEnsembleAt(long entryId) {
        return this.getEnsemble(entryId);
    }

    long getNextEnsembleChange(long entryId) {
        SortedMap<Long, ArrayList<BookieSocketAddress>> tailMap = this.ensembles.tailMap(entryId + 1L);
        if (tailMap.isEmpty()) {
            return -1L;
        }
        return tailMap.firstKey();
    }

    @Override
    public Map<String, byte[]> getCustomMetadata() {
        return this.customMetadata;
    }

    void setCustomMetadata(Map<String, byte[]> customMetadata) {
        this.customMetadata = customMetadata;
    }

    DataFormats.LedgerMetadataFormat buildProtoFormat() {
        return this.buildProtoFormat(true);
    }

    DataFormats.LedgerMetadataFormat buildProtoFormat(boolean withPassword) {
        DataFormats.LedgerMetadataFormat.Builder builder = DataFormats.LedgerMetadataFormat.newBuilder();
        builder.setQuorumSize(this.writeQuorumSize).setAckQuorumSize(this.ackQuorumSize).setEnsembleSize(this.ensembleSize).setLength(this.length).setState(this.state).setLastEntryId(this.lastEntryId);
        if (this.storeSystemtimeAsLedgerCreationTime) {
            builder.setCtime(this.ctime);
        }
        if (this.hasPassword) {
            builder.setDigestType(this.digestType);
            if (withPassword) {
                builder.setPassword(ByteString.copyFrom((byte[])this.password));
            }
        }
        if (this.customMetadata != null) {
            DataFormats.LedgerMetadataFormat.cMetadataMapEntry.Builder cMetadataBuilder = DataFormats.LedgerMetadataFormat.cMetadataMapEntry.newBuilder();
            for (Map.Entry<String, byte[]> entry : this.customMetadata.entrySet()) {
                cMetadataBuilder.setKey(entry.getKey()).setValue(ByteString.copyFrom((byte[])entry.getValue()));
                builder.addCustomMetadata(cMetadataBuilder.build());
            }
        }
        for (Map.Entry<Long, ArrayList<BookieSocketAddress>> entry : this.ensembles.entrySet()) {
            DataFormats.LedgerMetadataFormat.Segment.Builder segmentBuilder = DataFormats.LedgerMetadataFormat.Segment.newBuilder();
            segmentBuilder.setFirstEntryId(entry.getKey().longValue());
            for (BookieSocketAddress addr : entry.getValue()) {
                segmentBuilder.addEnsembleMember(addr.toString());
            }
            builder.addSegment(segmentBuilder.build());
        }
        return builder.build();
    }

    public byte[] serialize() {
        return this.serialize(true);
    }

    public byte[] serialize(boolean withPassword) {
        if (this.metadataFormatVersion == 1) {
            return this.serializeVersion1();
        }
        StringBuilder s = new StringBuilder();
        s.append(VERSION_KEY).append(tSplitter).append(2).append(lSplitter);
        s.append(TextFormat.printToString((MessageOrBuilder)this.buildProtoFormat(withPassword)));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialized config: {}", (Object)s);
        }
        return s.toString().getBytes(Charsets.UTF_8);
    }

    private byte[] serializeVersion1() {
        StringBuilder s = new StringBuilder();
        s.append(VERSION_KEY).append(tSplitter).append(this.metadataFormatVersion).append(lSplitter);
        s.append(this.writeQuorumSize).append(lSplitter).append(this.ensembleSize).append(lSplitter).append(this.length);
        for (Map.Entry<Long, ArrayList<BookieSocketAddress>> entry : this.ensembles.entrySet()) {
            s.append(lSplitter).append(entry.getKey());
            for (BookieSocketAddress addr : entry.getValue()) {
                s.append(tSplitter);
                s.append(addr.toString());
            }
        }
        if (this.state == DataFormats.LedgerMetadataFormat.State.IN_RECOVERY) {
            s.append(lSplitter).append(-102).append(tSplitter).append(closed);
        } else if (this.state == DataFormats.LedgerMetadataFormat.State.CLOSED) {
            s.append(lSplitter).append(this.getLastEntryId()).append(tSplitter).append(closed);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Serialized config: {}", (Object)s);
        }
        return s.toString().getBytes(Charsets.UTF_8);
    }

    public static LedgerMetadata parseConfig(byte[] bytes, Version version, Optional<Long> msCtime) throws IOException {
        BufferedReader reader;
        String versionLine;
        LedgerMetadata lc = new LedgerMetadata();
        lc.version = version;
        String config = new String(bytes, Charsets.UTF_8);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Parsing Config: {}", (Object)config);
        }
        if ((versionLine = (reader = new BufferedReader(new StringReader(config))).readLine()) == null) {
            throw new IOException("Invalid metadata. Content missing");
        }
        if (versionLine.startsWith(VERSION_KEY)) {
            String[] parts = versionLine.split(tSplitter);
            lc.metadataFormatVersion = Integer.parseInt(parts[1]);
        } else {
            lc.metadataFormatVersion = 1;
            reader.close();
            reader = new BufferedReader(new StringReader(config));
        }
        if (lc.metadataFormatVersion < 0 || lc.metadataFormatVersion > 2) {
            throw new IOException("Metadata version not compatible. Expected between 0 and 2, but got " + lc.metadataFormatVersion);
        }
        if (lc.metadataFormatVersion == 1) {
            return LedgerMetadata.parseVersion1Config(lc, reader);
        }
        char[] configBuffer = new char[config.length() - (versionLine.length() + 1)];
        if (configBuffer.length != reader.read(configBuffer, 0, configBuffer.length)) {
            throw new IOException("Invalid metadata buffer");
        }
        DataFormats.LedgerMetadataFormat.Builder builder = DataFormats.LedgerMetadataFormat.newBuilder();
        TextFormat.merge((CharSequence)CharBuffer.wrap(configBuffer), (Message.Builder)builder);
        DataFormats.LedgerMetadataFormat data = builder.build();
        lc.writeQuorumSize = data.getQuorumSize();
        if (data.hasCtime()) {
            lc.ctime = data.getCtime();
            lc.storeSystemtimeAsLedgerCreationTime = true;
        } else if (msCtime.isPresent()) {
            lc.ctime = (Long)msCtime.get();
            lc.storeSystemtimeAsLedgerCreationTime = false;
        }
        lc.ackQuorumSize = data.hasAckQuorumSize() ? data.getAckQuorumSize() : lc.writeQuorumSize;
        lc.ensembleSize = data.getEnsembleSize();
        lc.length = data.getLength();
        lc.state = data.getState();
        lc.lastEntryId = data.getLastEntryId();
        if (data.hasPassword()) {
            lc.digestType = data.getDigestType();
            lc.password = data.getPassword().toByteArray();
            lc.hasPassword = true;
        }
        for (DataFormats.LedgerMetadataFormat.Segment s : data.getSegmentList()) {
            ArrayList<BookieSocketAddress> addrs = new ArrayList<BookieSocketAddress>();
            for (String member : s.getEnsembleMemberList()) {
                addrs.add(new BookieSocketAddress(member));
            }
            lc.addEnsemble(s.getFirstEntryId(), addrs);
        }
        if (data.getCustomMetadataCount() > 0) {
            List cMetadataList = data.getCustomMetadataList();
            lc.customMetadata = Maps.newHashMap();
            for (DataFormats.LedgerMetadataFormat.cMetadataMapEntry ent : cMetadataList) {
                lc.customMetadata.put(ent.getKey(), ent.getValue().toByteArray());
            }
        }
        return lc;
    }

    static LedgerMetadata parseVersion1Config(LedgerMetadata lc, BufferedReader reader) throws IOException {
        try {
            lc.writeQuorumSize = lc.ackQuorumSize = Integer.parseInt(reader.readLine());
            lc.ensembleSize = Integer.parseInt(reader.readLine());
            lc.length = Long.parseLong(reader.readLine());
            String line = reader.readLine();
            while (line != null) {
                String[] parts = line.split(tSplitter);
                if (parts[1].equals(closed)) {
                    Long l = Long.parseLong(parts[0]);
                    if (l == -102L) {
                        lc.state = DataFormats.LedgerMetadataFormat.State.IN_RECOVERY;
                    } else {
                        lc.state = DataFormats.LedgerMetadataFormat.State.CLOSED;
                        lc.lastEntryId = l;
                    }
                    break;
                }
                lc.state = DataFormats.LedgerMetadataFormat.State.OPEN;
                ArrayList<BookieSocketAddress> addrs = new ArrayList<BookieSocketAddress>();
                for (int j = 1; j < parts.length; ++j) {
                    addrs.add(new BookieSocketAddress(parts[j]));
                }
                lc.addEnsemble(Long.parseLong(parts[0]), addrs);
                line = reader.readLine();
            }
        }
        catch (NumberFormatException e) {
            throw new IOException(e);
        }
        return lc;
    }

    public void setVersion(Version v) {
        this.version = v;
    }

    public Version getVersion() {
        return this.version;
    }

    boolean isNewerThan(LedgerMetadata newMeta) {
        if (null == this.version) {
            return false;
        }
        return Version.Occurred.AFTER == this.version.compare(newMeta.version);
    }

    public static boolean areByteArrayValMapsEqual(Map<String, byte[]> first, Map<String, byte[]> second) {
        if (first == null && second == null) {
            return true;
        }
        if (first == null || second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        for (Map.Entry<String, byte[]> entry : first.entrySet()) {
            if (Arrays.equals(entry.getValue(), second.get(entry.getKey()))) continue;
            return false;
        }
        return true;
    }

    boolean isConflictWith(LedgerMetadata newMeta) {
        if (!(this.metadataFormatVersion == newMeta.metadataFormatVersion && this.ensembleSize == newMeta.ensembleSize && this.writeQuorumSize == newMeta.writeQuorumSize && this.ackQuorumSize == newMeta.ackQuorumSize && this.length == newMeta.length && this.state == newMeta.state && this.digestType.equals((Object)newMeta.digestType) && Arrays.equals(this.password, newMeta.password) && LedgerMetadata.areByteArrayValMapsEqual(this.customMetadata, newMeta.customMetadata))) {
            return true;
        }
        if (this.storeSystemtimeAsLedgerCreationTime != newMeta.storeSystemtimeAsLedgerCreationTime) {
            return true;
        }
        if (this.storeSystemtimeAsLedgerCreationTime) {
            return this.ctime != newMeta.ctime;
        }
        if (this.state == DataFormats.LedgerMetadataFormat.State.CLOSED && this.lastEntryId != newMeta.lastEntryId) {
            return true;
        }
        if (newMeta.state != DataFormats.LedgerMetadataFormat.State.CLOSED) {
            int diff = this.ensembles.size() - newMeta.ensembles.size();
            if (0 != diff && 1 != diff) {
                return true;
            }
            Iterator<Long> keyIter = this.ensembles.keySet().iterator();
            Iterator<Long> newMetaKeyIter = newMeta.ensembles.keySet().iterator();
            for (int i = 0; i < newMeta.ensembles.size(); ++i) {
                Long newMetaKey;
                Long curKey = keyIter.next();
                if (curKey.equals(newMetaKey = newMetaKeyIter.next())) continue;
                return true;
            }
        }
        return false;
    }

    public String toString() {
        return this.toStringRepresentation(true);
    }

    public String toSafeString() {
        return this.toStringRepresentation(false);
    }

    private String toStringRepresentation(boolean withPassword) {
        StringBuilder sb = new StringBuilder();
        sb.append("(meta:").append(new String(this.serialize(withPassword), Charsets.UTF_8)).append(", version:").append(this.version).append(")");
        return sb.toString();
    }

    void mergeEnsembles(SortedMap<Long, ArrayList<BookieSocketAddress>> newEnsembles) {
        int diff = this.ensembles.size() - newEnsembles.size();
        if (0 != diff && 1 != diff) {
            return;
        }
        int i = 0;
        for (Map.Entry<Long, ArrayList<BookieSocketAddress>> entry : newEnsembles.entrySet()) {
            if (this.ensembles.size() == ++i) continue;
            long key = entry.getKey();
            ArrayList<BookieSocketAddress> ensemble = entry.getValue();
            this.ensembles.put(key, ensemble);
        }
    }

    Set<BookieSocketAddress> getBookiesInThisLedger() {
        HashSet<BookieSocketAddress> bookies = new HashSet<BookieSocketAddress>();
        for (ArrayList<BookieSocketAddress> ensemble : this.ensembles.values()) {
            bookies.addAll(ensemble);
        }
        return bookies;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof LedgerMetadata)) {
            return false;
        }
        LedgerMetadata other = (LedgerMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.metadataFormatVersion != other.metadataFormatVersion) {
            return false;
        }
        if (this.getEnsembleSize() != other.getEnsembleSize()) {
            return false;
        }
        if (this.getWriteQuorumSize() != other.getWriteQuorumSize()) {
            return false;
        }
        if (this.getAckQuorumSize() != other.getAckQuorumSize()) {
            return false;
        }
        if (this.getLength() != other.getLength()) {
            return false;
        }
        if (this.getLastEntryId() != other.getLastEntryId()) {
            return false;
        }
        if (this.getCtime() != other.getCtime()) {
            return false;
        }
        if (this.storeSystemtimeAsLedgerCreationTime != other.storeSystemtimeAsLedgerCreationTime) {
            return false;
        }
        DataFormats.LedgerMetadataFormat.State this$state = this.getState();
        DataFormats.LedgerMetadataFormat.State other$state = other.getState();
        if (this$state == null ? other$state != null : !this$state.equals(other$state)) {
            return false;
        }
        TreeMap<Long, ArrayList<BookieSocketAddress>> this$ensembles = this.getEnsembles();
        TreeMap<Long, ArrayList<BookieSocketAddress>> other$ensembles = other.getEnsembles();
        if (this$ensembles == null ? other$ensembles != null : !((Object)this$ensembles).equals(other$ensembles)) {
            return false;
        }
        ArrayList<BookieSocketAddress> this$currentEnsemble = this.currentEnsemble;
        ArrayList<BookieSocketAddress> other$currentEnsemble = other.currentEnsemble;
        if (this$currentEnsemble == null ? other$currentEnsemble != null : !((Object)this$currentEnsemble).equals(other$currentEnsemble)) {
            return false;
        }
        Version this$version = this.getVersion();
        Version other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        if (this.hasPassword != other.hasPassword) {
            return false;
        }
        DigestType this$digestType = this.getDigestType();
        DigestType other$digestType = other.getDigestType();
        if (this$digestType == null ? other$digestType != null : !((Object)((Object)this$digestType)).equals((Object)other$digestType)) {
            return false;
        }
        if (!Arrays.equals(this.getPassword(), other.getPassword())) {
            return false;
        }
        Map<String, byte[]> this$customMetadata = this.getCustomMetadata();
        Map<String, byte[]> other$customMetadata = other.getCustomMetadata();
        return !(this$customMetadata == null ? other$customMetadata != null : !((Object)this$customMetadata).equals(other$customMetadata));
    }

    protected boolean canEqual(Object other) {
        return other instanceof LedgerMetadata;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.metadataFormatVersion;
        result = result * 59 + this.getEnsembleSize();
        result = result * 59 + this.getWriteQuorumSize();
        result = result * 59 + this.getAckQuorumSize();
        long $length = this.getLength();
        result = result * 59 + (int)($length >>> 32 ^ $length);
        long $lastEntryId = this.getLastEntryId();
        result = result * 59 + (int)($lastEntryId >>> 32 ^ $lastEntryId);
        long $ctime = this.getCtime();
        result = result * 59 + (int)($ctime >>> 32 ^ $ctime);
        result = result * 59 + (this.storeSystemtimeAsLedgerCreationTime ? 79 : 97);
        DataFormats.LedgerMetadataFormat.State $state = this.getState();
        result = result * 59 + ($state == null ? 43 : $state.hashCode());
        TreeMap<Long, ArrayList<BookieSocketAddress>> $ensembles = this.getEnsembles();
        result = result * 59 + ($ensembles == null ? 43 : ((Object)$ensembles).hashCode());
        ArrayList<BookieSocketAddress> $currentEnsemble = this.currentEnsemble;
        result = result * 59 + ($currentEnsemble == null ? 43 : ((Object)$currentEnsemble).hashCode());
        Version $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        result = result * 59 + (this.hasPassword ? 79 : 97);
        DigestType $digestType = this.getDigestType();
        result = result * 59 + ($digestType == null ? 43 : ((Object)((Object)$digestType)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPassword());
        Map<String, byte[]> $customMetadata = this.getCustomMetadata();
        result = result * 59 + ($customMetadata == null ? 43 : ((Object)$customMetadata).hashCode());
        return result;
    }
}

