/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.util.HashedWheelTimer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookiesHealthInfo;
import org.apache.bookkeeper.client.DistributionSchedule;
import org.apache.bookkeeper.client.ITopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicy;
import org.apache.bookkeeper.client.RackawareEnsemblePlacementPolicyImpl;
import org.apache.bookkeeper.client.TopologyAwareEnsemblePlacementPolicy;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.feature.FeatureProvider;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.net.DNSToSwitchMapping;
import org.apache.bookkeeper.net.Node;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionAwareEnsemblePlacementPolicy
extends RackawareEnsemblePlacementPolicy {
    static final Logger LOG = LoggerFactory.getLogger(RegionAwareEnsemblePlacementPolicy.class);
    public static final String REPP_REGIONS_TO_WRITE = "reppRegionsToWrite";
    public static final String REPP_MINIMUM_REGIONS_FOR_DURABILITY = "reppMinimumRegionsForDurability";
    public static final String REPP_ENABLE_DURABILITY_ENFORCEMENT_IN_REPLACE = "reppEnableDurabilityEnforcementInReplace";
    public static final String REPP_DISABLE_DURABILITY_FEATURE_NAME = "reppDisableDurabilityFeatureName";
    public static final String REPP_DISALLOW_BOOKIE_PLACEMENT_IN_REGION_FEATURE_NAME = "reppDisallowBookiePlacementInRegionFeatureName";
    public static final String REPP_DISABLE_DURABILITY_ENFORCEMENT_FEATURE = "reppDisableDurabilityEnforcementFeature";
    public static final String REPP_ENABLE_VALIDATION = "reppEnableValidation";
    public static final String REGION_AWARE_ANOMALOUS_ENSEMBLE = "region_aware_anomalous_ensemble";
    static final int MINIMUM_REGIONS_FOR_DURABILITY_DEFAULT = 2;
    static final int REGIONID_DISTANCE_FROM_LEAVES = 2;
    static final String UNKNOWN_REGION = "UnknownRegion";
    static final int REMOTE_NODE_IN_REORDER_SEQUENCE = 2;
    protected final Map<String, TopologyAwareEnsemblePlacementPolicy> perRegionPlacement = new HashMap<String, TopologyAwareEnsemblePlacementPolicy>();
    protected final ConcurrentMap<BookieSocketAddress, String> address2Region = new ConcurrentHashMap<BookieSocketAddress, String>();
    protected FeatureProvider featureProvider;
    protected String disallowBookiePlacementInRegionFeatureName;
    protected String myRegion = null;
    protected int minRegionsForDurability = 0;
    protected boolean enableValidation = true;
    protected boolean enforceDurabilityInReplace = false;
    protected Feature disableDurabilityFeature;

    RegionAwareEnsemblePlacementPolicy() {
    }

    protected String getRegion(BookieSocketAddress addr) {
        String region = (String)this.address2Region.get(addr);
        if (null == region) {
            String[] parts;
            String networkLocation = this.resolveNetworkLocation(addr);
            region = "/default-region/default-rack".equals(networkLocation) ? UNKNOWN_REGION : ((parts = networkLocation.split("/")).length <= 1 ? UNKNOWN_REGION : parts[1]);
            this.address2Region.putIfAbsent(addr, region);
        }
        return region;
    }

    protected String getLocalRegion(TopologyAwareEnsemblePlacementPolicy.BookieNode node) {
        if (null == node || null == node.getAddr()) {
            return UNKNOWN_REGION;
        }
        return this.getRegion(node.getAddr());
    }

    @Override
    public void handleBookiesThatLeft(Set<BookieSocketAddress> leftBookies) {
        super.handleBookiesThatLeft(leftBookies);
        for (TopologyAwareEnsemblePlacementPolicy policy : this.perRegionPlacement.values()) {
            policy.handleBookiesThatLeft(leftBookies);
        }
    }

    @Override
    public void handleBookiesThatJoined(Set<BookieSocketAddress> joinedBookies) {
        HashMap<String, HashSet<BookieSocketAddress>> perRegionClusterChange = new HashMap<String, HashSet<BookieSocketAddress>>();
        for (BookieSocketAddress bookieSocketAddress : joinedBookies) {
            HashSet<BookieSocketAddress> regionSet;
            TopologyAwareEnsemblePlacementPolicy.BookieNode node = this.createBookieNode(bookieSocketAddress);
            this.topology.add(node);
            this.knownBookies.put(bookieSocketAddress, node);
            String region = this.getLocalRegion(node);
            if (null == this.perRegionPlacement.get(region)) {
                this.perRegionPlacement.put(region, new RackawareEnsemblePlacementPolicy().initialize(this.dnsResolver, this.timer, this.reorderReadsRandom, this.stabilizePeriodSeconds, this.isWeighted, this.maxWeightMultiple, this.statsLogger).withDefaultRack("/default-region/default-rack"));
            }
            if (null == (regionSet = (HashSet<BookieSocketAddress>)perRegionClusterChange.get(region))) {
                regionSet = new HashSet<BookieSocketAddress>();
                regionSet.add(bookieSocketAddress);
                perRegionClusterChange.put(region, regionSet);
            } else {
                regionSet.add(bookieSocketAddress);
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug("Cluster changed : bookie {} joined the cluster.", (Object)bookieSocketAddress);
        }
        for (Map.Entry entry : this.perRegionPlacement.entrySet()) {
            HashSet<BookieSocketAddress> regionSet = (HashSet<BookieSocketAddress>)perRegionClusterChange.get(entry.getKey());
            if (null == regionSet) {
                regionSet = new HashSet<BookieSocketAddress>();
            }
            ((TopologyAwareEnsemblePlacementPolicy)entry.getValue()).handleBookiesThatJoined(regionSet);
        }
    }

    @Override
    public RegionAwareEnsemblePlacementPolicy initialize(ClientConfiguration conf, Optional<DNSToSwitchMapping> optionalDnsResolver, HashedWheelTimer timer, FeatureProvider featureProvider, StatsLogger statsLogger) {
        ((RackawareEnsemblePlacementPolicyImpl)super.initialize(conf, (Optional)optionalDnsResolver, timer, featureProvider, statsLogger)).withDefaultRack("/default-region/default-rack");
        this.myRegion = this.getLocalRegion(this.localNode);
        this.enableValidation = conf.getBoolean(REPP_ENABLE_VALIDATION, true);
        String regionsString = conf.getString(REPP_REGIONS_TO_WRITE, null);
        if (null != regionsString) {
            String[] regions;
            for (String region : regions = regionsString.split(";")) {
                this.perRegionPlacement.put(region, new RackawareEnsemblePlacementPolicy(true).initialize(this.dnsResolver, timer, this.reorderReadsRandom, this.stabilizePeriodSeconds, this.isWeighted, this.maxWeightMultiple, statsLogger).withDefaultRack("/default-region/default-rack"));
            }
            this.minRegionsForDurability = conf.getInt(REPP_MINIMUM_REGIONS_FOR_DURABILITY, 2);
            if (this.minRegionsForDurability > 0) {
                this.enforceDurability = true;
                this.enforceDurabilityInReplace = conf.getBoolean(REPP_ENABLE_DURABILITY_ENFORCEMENT_IN_REPLACE, true);
            }
            if (regions.length < this.minRegionsForDurability) {
                throw new IllegalArgumentException("Regions provided are insufficient to meet the durability constraints");
            }
        }
        this.featureProvider = featureProvider;
        this.disallowBookiePlacementInRegionFeatureName = conf.getString(REPP_DISALLOW_BOOKIE_PLACEMENT_IN_REGION_FEATURE_NAME);
        this.disableDurabilityFeature = conf.getFeature(REPP_DISABLE_DURABILITY_ENFORCEMENT_FEATURE, null);
        if (null == this.disableDurabilityFeature) {
            this.disableDurabilityFeature = featureProvider.getFeature(conf.getString(REPP_DISABLE_DURABILITY_FEATURE_NAME, "repp_disable_durability_enforcement"));
        }
        return this;
    }

    protected List<TopologyAwareEnsemblePlacementPolicy.BookieNode> selectRandomFromRegions(Set<String> availableRegions, int numBookies, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble) throws BKException.BKNotEnoughBookiesException {
        ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode> availableBookies = new ArrayList<TopologyAwareEnsemblePlacementPolicy.BookieNode>();
        for (TopologyAwareEnsemblePlacementPolicy.BookieNode bookieNode : this.knownBookies.values()) {
            if (!availableRegions.contains(this.getLocalRegion(bookieNode))) continue;
            availableBookies.add(bookieNode);
        }
        return this.selectRandomInternal(availableBookies, numBookies, excludeBookies, predicate, ensemble);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ArrayList<BookieSocketAddress> newEnsemble(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        int effectiveMinRegionsForDurability;
        int n = effectiveMinRegionsForDurability = this.disableDurabilityFeature.isAvailable() ? 1 : this.minRegionsForDurability;
        if (ackQuorumSize < effectiveMinRegionsForDurability) {
            throw new IllegalArgumentException("Ack Quorum size provided are insufficient to meet the durability constraints");
        }
        if (ensembleSize < writeQuorumSize) {
            throw new IllegalArgumentException("write quorum (" + writeQuorumSize + ") cannot exceed ensemble size (" + ensembleSize + ")");
        }
        if (writeQuorumSize < ackQuorumSize) {
            throw new IllegalArgumentException("ack quorum (" + ackQuorumSize + ") cannot exceed write quorum size (" + writeQuorumSize + ")");
        }
        if (effectiveMinRegionsForDurability > 0 && ackQuorumSize <= writeQuorumSize - writeQuorumSize / effectiveMinRegionsForDurability) {
            throw new IllegalArgumentException("ack quorum (" + ackQuorumSize + ") violates the requirement to satisfy durability constraints when running in degraded mode");
        }
        this.rwLock.readLock().lock();
        try {
            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble;
            int remainingEnsembleBeforeIteration;
            Set<Node> excludeNodes = this.convertBookiesToNodes(excludeBookies);
            HashSet<String> availableRegions = new HashSet<String>();
            for (String region : this.perRegionPlacement.keySet()) {
                if (null != this.disallowBookiePlacementInRegionFeatureName && this.featureProvider.scope(region).getFeature(this.disallowBookiePlacementInRegionFeatureName).isAvailable()) continue;
                availableRegions.add(region);
            }
            int numRegionsAvailable = availableRegions.size();
            if (numRegionsAvailable < 1) {
                if (this.perRegionPlacement.keySet().size() >= 1) {
                    LOG.error("No regions available, invalid configuration");
                }
                List<TopologyAwareEnsemblePlacementPolicy.BookieNode> bns = this.selectRandom(ensembleSize, excludeNodes, TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE);
                ArrayList<BookieSocketAddress> addrs = new ArrayList<BookieSocketAddress>(ensembleSize);
                for (TopologyAwareEnsemblePlacementPolicy.BookieNode bn : bns) {
                    addrs.add(bn.getAddr());
                }
                ArrayList<BookieSocketAddress> arrayList = addrs;
                return arrayList;
            }
            if (numRegionsAvailable < 2) {
                TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble2 = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 2, (Set<String>)(effectiveMinRegionsForDurability > 0 ? new HashSet<String>(this.perRegionPlacement.keySet()) : null), effectiveMinRegionsForDurability);
                TopologyAwareEnsemblePlacementPolicy nextPolicy = this.perRegionPlacement.get(availableRegions.iterator().next());
                ArrayList<BookieSocketAddress> arrayList = nextPolicy.newEnsemble(ensembleSize, writeQuorumSize, writeQuorumSize, excludeBookies, ensemble2, ensemble2);
                return arrayList;
            }
            int remainingEnsemble = ensembleSize;
            int remainingWriteQuorum = writeQuorumSize;
            HashMap<String, Pair> regionsWiseAllocation = new HashMap<String, Pair>();
            for (String region : availableRegions) {
                regionsWiseAllocation.put(region, Pair.of((Object)0, (Object)0));
            }
            HashSet<String> regionsReachedMaxAllocation = new HashSet<String>();
            do {
                int numRemainingRegions = numRegionsAvailable - regionsReachedMaxAllocation.size();
                ensemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 2, (Set<String>)(effectiveMinRegionsForDurability > 0 ? new HashSet<String>(this.perRegionPlacement.keySet()) : null), effectiveMinRegionsForDurability);
                remainingEnsembleBeforeIteration = remainingEnsemble;
                int regionsToAllocate = numRemainingRegions;
                for (Map.Entry regionEntry : regionsWiseAllocation.entrySet()) {
                    String region = (String)regionEntry.getKey();
                    Pair currentAllocation = (Pair)regionEntry.getValue();
                    TopologyAwareEnsemblePlacementPolicy policyWithinRegion = this.perRegionPlacement.get(region);
                    if (!regionsReachedMaxAllocation.contains(region)) {
                        if (numRemainingRegions <= 0) {
                            LOG.error("Inconsistent State: This should never happen");
                            throw new BKException.BKNotEnoughBookiesException();
                        }
                        boolean success = false;
                        for (int addToEnsembleSize = Math.min(remainingEnsemble, remainingEnsemble / regionsToAllocate + (remainingEnsemble % regionsToAllocate == 0 ? 0 : 1)); addToEnsembleSize > 0; --addToEnsembleSize) {
                            int addToWriteQuorum = Math.max(1, Math.min(remainingWriteQuorum, Math.round(1.0f * (float)writeQuorumSize * (float)addToEnsembleSize / (float)ensembleSize)));
                            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble tempEnsemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensemble);
                            int newEnsembleSize = (Integer)currentAllocation.getLeft() + addToEnsembleSize;
                            int newWriteQuorumSize = (Integer)currentAllocation.getRight() + addToWriteQuorum;
                            try {
                                ArrayList<BookieSocketAddress> allocated = policyWithinRegion.newEnsemble(newEnsembleSize, newWriteQuorumSize, newWriteQuorumSize, excludeBookies, tempEnsemble, tempEnsemble);
                                ensemble = tempEnsemble;
                                remainingEnsemble -= addToEnsembleSize;
                                remainingWriteQuorum -= addToWriteQuorum;
                                regionsWiseAllocation.put(region, Pair.of((Object)newEnsembleSize, (Object)newWriteQuorumSize));
                                success = true;
                                --regionsToAllocate;
                                LOG.info("Region {} allocating bookies with ensemble size {} and write quorum size {} : {}", new Object[]{region, newEnsembleSize, newWriteQuorumSize, allocated});
                                break;
                            }
                            catch (BKException.BKNotEnoughBookiesException exc) {
                                LOG.warn("Could not allocate {} bookies in region {}, try allocating {} bookies", new Object[]{newEnsembleSize, region, newEnsembleSize - 1});
                                continue;
                            }
                        }
                        if (!success) {
                            regionsReachedMaxAllocation.add(region);
                        }
                    }
                    if (!regionsReachedMaxAllocation.contains(region) || (Integer)currentAllocation.getLeft() <= 0) continue;
                    LOG.info("Allocating {} bookies in region {} : ensemble {} exclude {}", new Object[]{currentAllocation.getLeft(), region, excludeBookies, ensemble});
                    policyWithinRegion.newEnsemble((Integer)currentAllocation.getLeft(), (Integer)currentAllocation.getRight(), (Integer)currentAllocation.getRight(), excludeBookies, ensemble, ensemble);
                    LOG.info("Allocated {} bookies in region {} : {}", new Object[]{currentAllocation.getLeft(), region, ensemble});
                }
            } while (!regionsReachedMaxAllocation.containsAll(regionsWiseAllocation.keySet()) && remainingEnsemble > 0 && remainingEnsemble < remainingEnsembleBeforeIteration);
            ArrayList<BookieSocketAddress> bookieList = ensemble.toList();
            if (ensembleSize != bookieList.size()) {
                LOG.error("Not enough {} bookies are available to form an ensemble : {}.", (Object)ensembleSize, bookieList);
                throw new BKException.BKNotEnoughBookiesException();
            }
            if (this.enableValidation && !ensemble.validate()) {
                LOG.error("Not enough {} bookies are available to form a valid ensemble : {}.", (Object)ensembleSize, bookieList);
                throw new BKException.BKNotEnoughBookiesException();
            }
            LOG.info("Bookies allocated successfully {}", (Object)ensemble);
            ArrayList<BookieSocketAddress> arrayList = ensemble.toList();
            return arrayList;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BookieSocketAddress replaceBookie(int ensembleSize, int writeQuorumSize, int ackQuorumSize, Map<String, byte[]> customMetadata, Set<BookieSocketAddress> currentEnsemble, BookieSocketAddress bookieToReplace, Set<BookieSocketAddress> excludeBookies) throws BKException.BKNotEnoughBookiesException {
        this.rwLock.readLock().lock();
        try {
            boolean enforceDurability = this.enforceDurabilityInReplace && !this.disableDurabilityFeature.isAvailable();
            int effectiveMinRegionsForDurability = enforceDurability ? this.minRegionsForDurability : 1;
            Set<Node> excludeNodes = this.convertBookiesToNodes(excludeBookies);
            TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble ensemble = new TopologyAwareEnsemblePlacementPolicy.RRTopologyAwareCoverageEnsemble(ensembleSize, writeQuorumSize, ackQuorumSize, 2, (Set<String>)(effectiveMinRegionsForDurability > 0 ? new HashSet<String>(this.perRegionPlacement.keySet()) : null), effectiveMinRegionsForDurability);
            TopologyAwareEnsemblePlacementPolicy.BookieNode bookieNodeToReplace = (TopologyAwareEnsemblePlacementPolicy.BookieNode)this.knownBookies.get(bookieToReplace);
            if (null == bookieNodeToReplace) {
                bookieNodeToReplace = this.createBookieNode(bookieToReplace);
            }
            excludeNodes.add(bookieNodeToReplace);
            for (BookieSocketAddress bookieAddress : currentEnsemble) {
                if (bookieAddress.equals(bookieToReplace)) continue;
                TopologyAwareEnsemblePlacementPolicy.BookieNode bn = (TopologyAwareEnsemblePlacementPolicy.BookieNode)this.knownBookies.get(bookieAddress);
                if (null == bn) {
                    bn = this.createBookieNode(bookieAddress);
                }
                excludeNodes.add(bn);
                if (!ensemble.apply(bn, (ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode>)ensemble)) {
                    LOG.warn("Anomalous ensemble detected");
                    if (null != this.statsLogger) {
                        this.statsLogger.getCounter(REGION_AWARE_ANOMALOUS_ENSEMBLE).inc();
                    }
                    enforceDurability = false;
                }
                ensemble.addNode(bn);
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("Try to choose a new bookie to replace {}, excluding {}.", (Object)bookieToReplace, excludeNodes);
            }
            TopologyAwareEnsemblePlacementPolicy.BookieNode candidate = this.replaceFromRack(bookieNodeToReplace, excludeNodes, ensemble, ensemble, enforceDurability);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Bookie {} is chosen to replace bookie {}.", (Object)candidate, (Object)bookieNodeToReplace);
            }
            BookieSocketAddress bookieSocketAddress = candidate.getAddr();
            return bookieSocketAddress;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    protected TopologyAwareEnsemblePlacementPolicy.BookieNode replaceFromRack(TopologyAwareEnsemblePlacementPolicy.BookieNode bookieNodeToReplace, Set<Node> excludeBookies, ITopologyAwareEnsemblePlacementPolicy.Predicate<TopologyAwareEnsemblePlacementPolicy.BookieNode> predicate, ITopologyAwareEnsemblePlacementPolicy.Ensemble<TopologyAwareEnsemblePlacementPolicy.BookieNode> ensemble, boolean enforceDurability) throws BKException.BKNotEnoughBookiesException {
        TopologyAwareEnsemblePlacementPolicy regionPolicy;
        HashSet<String> availableRegions = new HashSet<String>();
        for (String region : this.perRegionPlacement.keySet()) {
            if (null != this.disallowBookiePlacementInRegionFeatureName && this.featureProvider.scope(region).getFeature(this.disallowBookiePlacementInRegionFeatureName).isAvailable()) continue;
            availableRegions.add(region);
        }
        String regionForBookieToReplace = this.getLocalRegion(bookieNodeToReplace);
        if (availableRegions.contains(regionForBookieToReplace) && null != (regionPolicy = this.perRegionPlacement.get(regionForBookieToReplace))) {
            try {
                return regionPolicy.selectFromNetworkLocation(bookieNodeToReplace.getNetworkLocation(), excludeBookies, TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE);
            }
            catch (BKException.BKNotEnoughBookiesException e) {
                LOG.warn("Failed to choose a bookie from {} : excluded {}, fallback to choose bookie randomly from the cluster.", (Object)bookieNodeToReplace.getNetworkLocation(), excludeBookies);
            }
        }
        return this.selectRandomFromRegions(availableRegions, 1, excludeBookies, enforceDurability ? predicate : TopologyAwareEnsemblePlacementPolicy.TruePredicate.INSTANCE, enforceDurability ? ensemble : TopologyAwareEnsemblePlacementPolicy.EnsembleForReplacementWithNoConstraints.INSTANCE).get(0);
    }

    @Override
    public final DistributionSchedule.WriteSet reorderReadSequence(ArrayList<BookieSocketAddress> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        if (UNKNOWN_REGION.equals(this.myRegion)) {
            return super.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
        }
        HashMap<Integer, String> writeSetWithRegion = new HashMap<Integer, String>();
        for (int i = 0; i < writeSet.size(); ++i) {
            int idx = writeSet.get(i);
            writeSetWithRegion.put(idx, this.getRegion(ensemble.get(idx)));
        }
        return super.reorderReadSequenceWithRegion(ensemble, writeSet, writeSetWithRegion, bookiesHealthInfo, true, this.myRegion, 2);
    }

    @Override
    public final DistributionSchedule.WriteSet reorderReadLACSequence(ArrayList<BookieSocketAddress> ensemble, BookiesHealthInfo bookiesHealthInfo, DistributionSchedule.WriteSet writeSet) {
        if (UNKNOWN_REGION.equals(this.myRegion)) {
            return super.reorderReadLACSequence(ensemble, bookiesHealthInfo, writeSet);
        }
        DistributionSchedule.WriteSet finalList = this.reorderReadSequence(ensemble, bookiesHealthInfo, writeSet);
        finalList.addMissingIndices(ensemble.size());
        return finalList;
    }
}

