/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.meta.zk;

import java.util.Optional;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.discover.ZKRegistrationClient;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.meta.exceptions.MetadataException;
import org.apache.bookkeeper.meta.zk.ZKMetadataDriverBase;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.zookeeper.BoundExponentialBackoffRetryPolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZKMetadataClientDriver
extends ZKMetadataDriverBase
implements MetadataClientDriver {
    private static final Logger log = LoggerFactory.getLogger(ZKMetadataClientDriver.class);
    ClientConfiguration clientConf;
    ScheduledExecutorService scheduler;
    RegistrationClient regClient;

    @Override
    public synchronized MetadataClientDriver initialize(ClientConfiguration conf, ScheduledExecutorService scheduler, StatsLogger statsLogger, Optional<Object> optionalCtx) throws MetadataException {
        super.initialize(conf, statsLogger, new BoundExponentialBackoffRetryPolicy(conf.getZkTimeout(), conf.getZkTimeout(), 0), optionalCtx);
        this.statsLogger = statsLogger;
        this.clientConf = conf;
        this.scheduler = scheduler;
        return this;
    }

    @Override
    public synchronized RegistrationClient getRegistrationClient() {
        if (null == this.regClient) {
            this.regClient = new ZKRegistrationClient(this.zk, this.ledgersRootPath, this.scheduler);
        }
        return this.regClient;
    }

    @Override
    public synchronized void close() {
        if (null != this.regClient) {
            this.regClient.close();
            this.regClient = null;
        }
        super.close();
    }

    static {
        MetadataDrivers.registerClientDriver("zk", ZKMetadataClientDriver.class);
    }
}

