/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import com.google.common.annotations.VisibleForTesting;
import java.io.IOException;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.Arrays;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieCriticalThread;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.ReadOnlyBookie;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.processor.RequestProcessor;
import org.apache.bookkeeper.proto.BookieNettyServer;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.replication.ReplicationException;
import org.apache.bookkeeper.server.Main;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tls.SecurityException;
import org.apache.bookkeeper.tls.SecurityHandlerFactory;
import org.apache.bookkeeper.tls.SecurityProviderFactoryFactory;
import org.apache.bookkeeper.util.JsonUtil;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookieServer {
    final ServerConfiguration conf;
    BookieNettyServer nettyServer;
    private volatile boolean running = false;
    Bookie bookie;
    DeathWatcher deathWatcher;
    private static final Logger LOG = LoggerFactory.getLogger(BookieServer.class);
    int exitCode = 0;
    private final RequestProcessor requestProcessor;
    private final StatsLogger statsLogger;
    private volatile Thread.UncaughtExceptionHandler uncaughtExceptionHandler = null;

    public BookieServer(ServerConfiguration conf) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException, SecurityException {
        this(conf, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    public BookieServer(ServerConfiguration conf, StatsLogger statsLogger) throws IOException, KeeperException, InterruptedException, BookieException, ReplicationException.UnavailableException, ReplicationException.CompatibilityException, SecurityException {
        this.conf = conf;
        this.validateUser(conf);
        try {
            String configAsString = conf.asJson();
            LOG.info(configAsString);
        }
        catch (JsonUtil.ParseJsonException pe) {
            LOG.error("Got ParseJsonException while converting Config to JSONString", (Throwable)pe);
        }
        this.statsLogger = statsLogger;
        this.nettyServer = new BookieNettyServer(this.conf, null);
        try {
            this.bookie = this.newBookie(conf);
        }
        catch (IOException | InterruptedException | BookieException | KeeperException e) {
            this.nettyServer.shutdown();
            throw e;
        }
        SecurityHandlerFactory shFactory = SecurityProviderFactoryFactory.getSecurityProviderFactory(conf.getTLSProviderFactoryClass());
        this.requestProcessor = new BookieRequestProcessor(conf, this.bookie, statsLogger.scope("bookkeeper_server"), shFactory);
        this.nettyServer.setRequestProcessor(this.requestProcessor);
    }

    public void setExceptionHandler(Thread.UncaughtExceptionHandler exceptionHandler) {
        this.uncaughtExceptionHandler = exceptionHandler;
    }

    protected Bookie newBookie(ServerConfiguration conf) throws IOException, KeeperException, InterruptedException, BookieException {
        return conf.isForceReadOnlyBookie() ? new ReadOnlyBookie(conf, this.statsLogger.scope("bookie")) : new Bookie(conf, this.statsLogger.scope("bookie"));
    }

    public void start() throws IOException, ReplicationException.UnavailableException, InterruptedException, BKException {
        this.bookie.start();
        if (!this.bookie.isRunning()) {
            this.exitCode = this.bookie.getExitCode();
            return;
        }
        this.nettyServer.start();
        this.running = true;
        this.deathWatcher = new DeathWatcher(this.conf);
        if (null != this.uncaughtExceptionHandler) {
            this.deathWatcher.setUncaughtExceptionHandler(this.uncaughtExceptionHandler);
        }
        this.deathWatcher.start();
    }

    @VisibleForTesting
    public BookieSocketAddress getLocalAddress() throws UnknownHostException {
        return Bookie.getBookieAddress(this.conf);
    }

    @VisibleForTesting
    public Bookie getBookie() {
        return this.bookie;
    }

    @VisibleForTesting
    public void suspendProcessing() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Suspending bookie server, port is {}", (Object)this.conf.getBookiePort());
        }
        this.nettyServer.suspendProcessing();
    }

    @VisibleForTesting
    public void resumeProcessing() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Resuming bookie server, port is {}", (Object)this.conf.getBookiePort());
        }
        this.nettyServer.resumeProcessing();
    }

    public synchronized void shutdown() {
        LOG.info("Shutting down BookieServer");
        this.nettyServer.shutdown();
        if (!this.running) {
            return;
        }
        this.exitCode = this.bookie.shutdown();
        this.requestProcessor.close();
        this.running = false;
    }

    private void validateUser(ServerConfiguration conf) throws AccessControlException {
        if (conf.containsKey("permittedStartupUsers")) {
            Object[] propertyValue;
            String currentUser = System.getProperty("user.name");
            for (String string : propertyValue = conf.getPermittedStartupUsers()) {
                if (!string.equals(currentUser)) continue;
                return;
            }
            String errorMsg = "System cannot start because current user isn't in permittedStartupUsers. Current user: " + currentUser + " permittedStartupUsers: " + Arrays.toString(propertyValue);
            LOG.error(errorMsg);
            throw new AccessControlException(errorMsg);
        }
    }

    public boolean isRunning() {
        return this.bookie.isRunning() && this.nettyServer.isRunning() && this.running;
    }

    public boolean isBookieRunning() {
        return this.bookie.isRunning();
    }

    public void join() throws InterruptedException {
        this.bookie.join();
    }

    public int getExitCode() {
        return this.exitCode;
    }

    public static void main(String[] args) {
        Main.main(args);
    }

    public String toString() {
        String id = "UNKNOWN";
        try {
            id = Bookie.getBookieAddress(this.conf).toString();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "Bookie Server listening on " + id;
    }

    private class DeathWatcher
    extends BookieCriticalThread {
        private final int watchInterval;

        DeathWatcher(ServerConfiguration conf) {
            super("BookieDeathWatcher-" + conf.getBookiePort());
            this.watchInterval = conf.getDeathWatchInterval();
            this.setUncaughtExceptionHandler((thread, cause) -> {
                LOG.info("BookieDeathWatcher exited loop due to uncaught exception from thread {}", (Object)thread.getName(), (Object)cause);
                BookieServer.this.shutdown();
            });
        }

        public void run() {
            do {
                try {
                    Thread.sleep(this.watchInterval);
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                }
            } while (BookieServer.this.isBookieRunning());
            LOG.info("BookieDeathWatcher noticed the bookie is not running any more, exiting the watch loop!");
            throw new RuntimeException("Bookie is not running any more");
        }
    }
}

