/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.proto;

import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.TimeUnit;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.proto.BookieRequestProcessor;
import org.apache.bookkeeper.proto.BookkeeperProtocol;
import org.apache.bookkeeper.proto.PacketProcessorBaseV3;
import org.apache.bookkeeper.proto.RequestUtils;
import org.apache.bookkeeper.util.MathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class WriteLacProcessorV3
extends PacketProcessorBaseV3
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(WriteLacProcessorV3.class);

    public WriteLacProcessorV3(BookkeeperProtocol.Request request, Channel channel, BookieRequestProcessor requestProcessor) {
        super(request, channel, requestProcessor);
    }

    private BookkeeperProtocol.WriteLacResponse getWriteLacResponse() {
        long startTimeNanos = MathUtils.nowInNano();
        BookkeeperProtocol.WriteLacRequest writeLacRequest = this.request.getWriteLacRequest();
        long lac = writeLacRequest.getLac();
        long ledgerId = writeLacRequest.getLedgerId();
        BookkeeperProtocol.WriteLacResponse.Builder writeLacResponse = BookkeeperProtocol.WriteLacResponse.newBuilder().setLedgerId(ledgerId);
        if (!this.isVersionCompatible()) {
            writeLacResponse.setStatus(BookkeeperProtocol.StatusCode.EBADVERSION);
            return writeLacResponse.build();
        }
        if (this.requestProcessor.bookie.isReadOnly()) {
            logger.warn("BookieServer is running as readonly mode, so rejecting the request from the client!");
            writeLacResponse.setStatus(BookkeeperProtocol.StatusCode.EREADONLY);
            return writeLacResponse.build();
        }
        BookkeeperProtocol.StatusCode status = null;
        ByteBuffer lacToAdd = writeLacRequest.getBody().asReadOnlyByteBuffer();
        byte[] masterKey = writeLacRequest.getMasterKey().toByteArray();
        try {
            this.requestProcessor.bookie.setExplicitLac(Unpooled.wrappedBuffer((ByteBuffer)lacToAdd), this.channel, masterKey);
            status = BookkeeperProtocol.StatusCode.EOK;
        }
        catch (IOException e) {
            logger.error("Error saving lac {} for ledger:{}", new Object[]{lac, ledgerId, e});
            status = BookkeeperProtocol.StatusCode.EIO;
        }
        catch (BookieException e) {
            logger.error("Unauthorized access to ledger:{} while adding lac:{}", new Object[]{ledgerId, lac, e});
            status = BookkeeperProtocol.StatusCode.EUA;
        }
        catch (Throwable t) {
            logger.error("Unexpected exception while writing lac {} for ledger:{}", new Object[]{lac, ledgerId, t});
            status = BookkeeperProtocol.StatusCode.EBADREQ;
        }
        if (status.equals((Object)BookkeeperProtocol.StatusCode.EOK)) {
            this.requestProcessor.writeLacStats.registerSuccessfulEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
        } else {
            this.requestProcessor.writeLacStats.registerFailedEvent(MathUtils.elapsedNanos((long)startTimeNanos), TimeUnit.NANOSECONDS);
        }
        writeLacResponse.setStatus(status);
        return writeLacResponse.build();
    }

    public void safeRun() {
        BookkeeperProtocol.WriteLacResponse writeLacResponse = this.getWriteLacResponse();
        if (null != writeLacResponse) {
            BookkeeperProtocol.Response.Builder response = BookkeeperProtocol.Response.newBuilder().setHeader(this.getHeader()).setStatus(writeLacResponse.getStatus()).setWriteLacResponse(writeLacResponse);
            BookkeeperProtocol.Response resp = response.build();
            this.sendResponse(writeLacResponse.getStatus(), resp, this.requestProcessor.writeLacRequestStats);
        }
    }

    @Override
    public String toString() {
        return RequestUtils.toSafeString(this.request);
    }
}

