/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.server.http.service;

import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.http.HttpServer;
import org.apache.bookkeeper.http.service.HttpEndpointService;
import org.apache.bookkeeper.http.service.HttpServiceRequest;
import org.apache.bookkeeper.http.service.HttpServiceResponse;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.meta.LedgerManagerFactory;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.server.http.service.ListLedgerService;
import org.apache.bookkeeper.util.JsonUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetLedgerMetaService
implements HttpEndpointService {
    static final Logger LOG = LoggerFactory.getLogger(GetLedgerMetaService.class);
    protected ServerConfiguration conf;
    protected BookieServer bookieServer;

    public GetLedgerMetaService(ServerConfiguration conf, BookieServer bookieServer) {
        Preconditions.checkNotNull((Object)((Object)conf));
        this.conf = conf;
        this.bookieServer = bookieServer;
    }

    public HttpServiceResponse handle(HttpServiceRequest request) throws Exception {
        HttpServiceResponse response = new HttpServiceResponse();
        Map params = request.getParams();
        if (HttpServer.Method.GET == request.getMethod() && params != null && params.containsKey("ledger_id")) {
            Long ledgerId = Long.parseLong((String)params.get("ledger_id"));
            LedgerManagerFactory mFactory = this.bookieServer.getBookie().getLedgerManagerFactory();
            LedgerManager manager = mFactory.newLedgerManager();
            HashMap output = Maps.newHashMap();
            ListLedgerService.ReadLedgerMetadataCallback cb = new ListLedgerService.ReadLedgerMetadataCallback(ledgerId);
            manager.readLedgerMetadata(ledgerId, cb);
            LedgerMetadata md = (LedgerMetadata)cb.get();
            output.put(ledgerId.toString(), new String(md.serialize(), Charsets.UTF_8));
            manager.close();
            String jsonResponse = JsonUtil.toJson(output);
            LOG.debug("output body:" + jsonResponse);
            response.setBody(jsonResponse);
            response.setCode(HttpServer.StatusCode.OK);
            return response;
        }
        response.setCode(HttpServer.StatusCode.NOT_FOUND);
        response.setBody("Not found method. Should be GET method");
        return response;
    }
}

