/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.commands.cluster;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import java.util.Collection;
import java.util.Set;
import org.apache.bookkeeper.common.concurrent.FutureUtils;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.tools.cli.helpers.CommandHelpers;
import org.apache.bookkeeper.tools.cli.helpers.DiscoveryCommand;
import org.apache.bookkeeper.versioning.Versioned;

@Parameters(commandDescription="List the bookies, which are running as either readwrite or readonly mode.")
public class ListBookiesCommand
extends DiscoveryCommand {
    @Parameter(names={"-rw", "--readwrite"}, description="Print readwrite bookies")
    private boolean readwrite = false;
    @Parameter(names={"-ro", "--readonly"}, description="Print readonly bookies")
    private boolean readonly = false;

    @Override
    protected void run(RegistrationClient regClient) throws Exception {
        Set bookies;
        if (!this.readwrite && !this.readonly) {
            this.readwrite = true;
            this.readonly = true;
        }
        boolean hasBookies = false;
        if (this.readwrite && !(bookies = (Set)((Versioned)FutureUtils.result(regClient.getWritableBookies())).getValue()).isEmpty()) {
            System.out.println("ReadWrite Bookies :");
            ListBookiesCommand.printBookies(bookies);
            hasBookies = true;
        }
        if (this.readonly && !(bookies = (Set)((Versioned)FutureUtils.result(regClient.getReadOnlyBookies())).getValue()).isEmpty()) {
            System.out.println("Readonly Bookies :");
            ListBookiesCommand.printBookies(bookies);
            hasBookies = true;
        }
        if (!hasBookies) {
            System.err.println("No bookie exists!");
        }
    }

    private static void printBookies(Collection<BookieSocketAddress> bookies) {
        for (BookieSocketAddress b : bookies) {
            System.out.println(CommandHelpers.getBookieSocketAddrStringRepresentation(b));
        }
    }

    @Override
    public String name() {
        return "listbookies";
    }

    public ListBookiesCommand readwrite(boolean readwrite) {
        this.readwrite = readwrite;
        return this;
    }

    public ListBookiesCommand readonly(boolean readonly) {
        this.readonly = readonly;
        return this;
    }
}

