/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.tools.cli.helpers;

import java.net.URI;
import java.util.Collections;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.discover.RegistrationClient;
import org.apache.bookkeeper.meta.MetadataClientDriver;
import org.apache.bookkeeper.meta.MetadataDrivers;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.apache.bookkeeper.tools.cli.helpers.Command;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryCommand
implements Command {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryCommand.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run(ServerConfiguration conf) throws Exception {
        URI metadataServiceUri = URI.create(conf.getMetadataServiceUri());
        ScheduledExecutorService executor = Executors.newSingleThreadScheduledExecutor();
        try (MetadataClientDriver driver = MetadataDrivers.getClientDriver(metadataServiceUri);){
            ClientConfiguration clientConf = new ClientConfiguration(conf);
            driver.initialize(clientConf, executor, (StatsLogger)NullStatsLogger.INSTANCE, Optional.empty());
            this.run(driver.getRegistrationClient());
        }
        finally {
            if (Collections.singletonList(executor).get(0) != null) {
                executor.shutdown();
            }
        }
    }

    protected abstract void run(RegistrationClient var1) throws Exception;
}

