/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.auth;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.bookkeeper.auth.AuthCallbacks;
import org.apache.bookkeeper.auth.AuthToken;
import org.apache.bookkeeper.auth.BookKeeperPrincipal;
import org.apache.bookkeeper.auth.BookieAuthProvider;
import org.apache.bookkeeper.auth.ClientAuthProvider;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerEntry;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieConnectionPeer;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.proto.ClientConnectionPeer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestAuth
extends BookKeeperClusterTestCase {
    static final Logger LOG = LoggerFactory.getLogger(TestAuth.class);
    public static final String TEST_AUTH_PROVIDER_PLUGIN_NAME = "TestAuthProviderPlugin";
    private static final byte[] PASSWD = "testPasswd".getBytes();
    private static final byte[] ENTRY = "TestEntry".getBytes();
    private static final byte[] SUCCESS_RESPONSE = new byte[]{1};
    private static final byte[] FAILURE_RESPONSE = new byte[]{2};
    private static final byte[] PAYLOAD_MESSAGE = new byte[]{3};
    private final ProtocolVersion protocolVersion;
    private static BookieServer crashType2bookieInstance = null;

    @Parameterized.Parameters
    public static Collection<Object[]> configs() {
        return Arrays.asList({ProtocolVersion.ProtocolV2}, {ProtocolVersion.ProtocolV3});
    }

    public TestAuth(ProtocolVersion protocolVersion) {
        super(0);
        this.protocolVersion = protocolVersion;
    }

    @Override
    protected ClientConfiguration newClientConfiguration() {
        ClientConfiguration conf = super.newClientConfiguration();
        conf.setUseV2WireProtocol(this.protocolVersion == ProtocolVersion.ProtocolV2);
        return conf;
    }

    private void connectAndWriteToBookie(ClientConfiguration conf, AtomicLong ledgerWritten) throws Exception {
        LOG.info("Connecting to bookie");
        BookKeeper bkc = new BookKeeper(conf, this.zkc);
        LedgerHandle l = bkc.createLedger(1, 1, BookKeeper.DigestType.CRC32, PASSWD);
        ledgerWritten.set(l.getId());
        l.addEntry(ENTRY);
        l.close();
        bkc.close();
    }

    private int entryCount(long ledgerId, ServerConfiguration bookieConf, ClientConfiguration clientConf) throws Exception {
        LOG.info("Counting entries in {}", (Object)ledgerId);
        for (ServerConfiguration conf : this.bsConfs) {
            conf.setBookieAuthProviderFactoryClass(AlwaysSucceedBookieAuthProviderFactory.class.getName());
        }
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        this.restartBookies();
        BookKeeper bkc = new BookKeeper(clientConf, this.zkc);
        LedgerHandle lh = bkc.openLedger(ledgerId, BookKeeper.DigestType.CRC32, PASSWD);
        if (lh.getLastAddConfirmed() < 0L) {
            return 0;
        }
        Enumeration e = lh.readEntries(0L, lh.getLastAddConfirmed());
        int count = 0;
        while (e.hasMoreElements()) {
            ++count;
            Assert.assertTrue((String)"Should match what we wrote", (boolean)Arrays.equals(((LedgerEntry)e.nextElement()).getEntry(), ENTRY));
        }
        return count;
    }

    @Test
    public void testSingleMessageAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(AlwaysSucceedBookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        this.connectAndWriteToBookie(clientConf, ledgerId);
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have entry", (long)1L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    @Test
    public void testCloseMethodCalledOnAuthProvider() throws Exception {
        LogCloseCallsBookieAuthProviderFactory.closeCountersOnFactory.set(0);
        LogCloseCallsBookieAuthProviderFactory.closeCountersOnConnections.set(0);
        LogCloseCallsBookieAuthProviderFactory.initCountersOnFactory.set(0);
        LogCloseCallsBookieAuthProviderFactory.initCountersOnConnections.set(0);
        LogCloseCallsClientAuthProviderFactory.initCountersOnFactory.set(0);
        LogCloseCallsClientAuthProviderFactory.closeCountersOnFactory.set(0);
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(LogCloseCallsBookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(LogCloseCallsClientAuthProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        this.connectAndWriteToBookie(clientConf, ledgerId);
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have entry", (long)1L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
        for (BookieServer bks : this.bs) {
            bks.shutdown();
        }
        Assert.assertEquals((long)LogCloseCallsBookieAuthProviderFactory.initCountersOnConnections.get(), (long)LogCloseCallsBookieAuthProviderFactory.closeCountersOnConnections.get());
        Assert.assertTrue((LogCloseCallsBookieAuthProviderFactory.initCountersOnConnections.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)LogCloseCallsBookieAuthProviderFactory.initCountersOnFactory.get());
        Assert.assertEquals((long)1L, (long)LogCloseCallsBookieAuthProviderFactory.closeCountersOnFactory.get());
        Assert.assertEquals((long)LogCloseCallsClientAuthProviderFactory.initCountersOnConnections.get(), (long)LogCloseCallsClientAuthProviderFactory.closeCountersOnConnections.get());
        Assert.assertTrue((LogCloseCallsClientAuthProviderFactory.initCountersOnConnections.get() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)LogCloseCallsClientAuthProviderFactory.initCountersOnFactory.get());
        Assert.assertEquals((long)1L, (long)LogCloseCallsClientAuthProviderFactory.closeCountersOnFactory.get());
    }

    @Test
    public void testSingleMessageAuthFailure() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(AlwaysFailBookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        try {
            this.connectAndWriteToBookie(clientConf, ledgerId);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (BKException.BKUnauthorizedAccessException bKUnauthorizedAccessException) {
            // empty catch block
        }
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Shouldn't have entry", (long)0L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    @Test
    public void testMultiMessageAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(SucceedAfter3BookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        AtomicLong ledgerId = new AtomicLong(-1L);
        this.startAndStoreBookie(bookieConf);
        this.connectAndWriteToBookie(clientConf, ledgerId);
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have entry", (long)1L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    @Test
    public void testMultiMessageAuthFailure() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(FailAfter3BookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        try {
            this.connectAndWriteToBookie(clientConf, ledgerId);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (BKException.BKUnauthorizedAccessException bKUnauthorizedAccessException) {
            // empty catch block
        }
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Shouldn't have entry", (long)0L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    @Test
    public void testDifferentPluginFailure() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(DifferentPluginBookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        try {
            this.connectAndWriteToBookie(clientConf, ledgerId);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (BKException.BKUnauthorizedAccessException bke) {
            Assert.assertEquals((Object)((Object)ProtocolVersion.ProtocolV3), (Object)((Object)this.protocolVersion));
        }
        catch (BKException.BKNotEnoughBookiesException nebe) {
            Assert.assertEquals((Object)((Object)ProtocolVersion.ProtocolV2), (Object)((Object)this.protocolVersion));
        }
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Shouldn't have entry", (long)0L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    @Test
    public void testExistantButNotValidPlugin() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass("java.lang.String");
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass("java.lang.String");
        try {
            this.startAndStoreBookie(bookieConf);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)"Wrong exception thrown", (boolean)e.getMessage().contains("not " + BookieAuthProvider.Factory.class.getName()));
        }
        try {
            BookKeeper bkc = new BookKeeper(clientConf, this.zkc);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (RuntimeException e) {
            Assert.assertTrue((String)"Wrong exception thrown", (boolean)e.getMessage().contains("not " + ClientAuthProvider.Factory.class.getName()));
        }
    }

    @Test
    public void testNonExistantPlugin() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass("NonExistantClassNameForTestingAuthPlugins");
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass("NonExistantClassNameForTestingAuthPlugins");
        try {
            this.startAndStoreBookie(bookieConf);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Wrong exception thrown", e.getCause().getClass(), ClassNotFoundException.class);
        }
        try {
            BookKeeper bkc = new BookKeeper(clientConf, this.zkc);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (RuntimeException e) {
            Assert.assertEquals((String)"Wrong exception thrown", e.getCause().getClass(), ClassNotFoundException.class);
        }
    }

    @Test
    public void testCrashDuringAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(CrashAfter3BookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        try {
            this.connectAndWriteToBookie(clientConf, ledgerId);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Shouldn't have entry", (long)0L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    @Test
    public void testCrashType2DuringAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(CrashType2After3BookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        crashType2bookieInstance = this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        try {
            this.connectAndWriteToBookie(clientConf, ledgerId);
            Assert.fail((String)"Shouldn't get this far");
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Shouldn't have entry", (long)0L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    @Test
    public void testClientWithAuthAndBookieWithDisabledAuth() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        Assert.assertNull((Object)bookieConf.getBookieAuthProviderFactoryClass());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        this.connectAndWriteToBookie(clientConf, ledgerId);
        Assert.assertFalse((ledgerId.get() == -1L ? 1 : 0) != 0);
        Assert.assertEquals((String)"Should have entry", (long)1L, (long)this.entryCount(ledgerId.get(), bookieConf, clientConf));
    }

    @Test
    public void testDropConnectionFromBookieAuthPlugin() throws Exception {
        ServerConfiguration bookieConf = this.newServerConfiguration();
        bookieConf.setBookieAuthProviderFactoryClass(DropConnectionBookieAuthProviderFactory.class.getName());
        ClientConfiguration clientConf = this.newClientConfiguration();
        clientConf.setClientAuthProviderFactoryClass(SendUntilCompleteClientAuthProviderFactory.class.getName());
        this.startAndStoreBookie(bookieConf);
        AtomicLong ledgerId = new AtomicLong(-1L);
        try {
            this.connectAndWriteToBookie(clientConf, ledgerId);
            Assert.fail();
        }
        catch (BKException.BKNotEnoughBookiesException bKNotEnoughBookiesException) {
            // empty catch block
        }
    }

    BookieServer startAndStoreBookie(ServerConfiguration conf) throws Exception {
        this.bsConfs.add(conf);
        BookieServer s = this.startBookie(conf);
        this.bs.add(s);
        return s;
    }

    public static class DifferentPluginBookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        public String getPluginName() {
            return "DifferentAuthProviderPlugin";
        }

        public void init(ServerConfiguration conf) {
        }

        public BookieAuthProvider newProvider(BookieConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    cb.operationComplete(0, (Object)AuthToken.wrap((byte[])FAILURE_RESPONSE));
                    completeCb.operationComplete(0, null);
                }
            };
        }
    }

    public static class CrashType2After3BookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        AtomicInteger numMessages = new AtomicInteger(0);

        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ServerConfiguration conf) {
        }

        public BookieAuthProvider newProvider(BookieConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    if (numMessages.incrementAndGet() != 3) {
                        cb.operationComplete(0, (Object)AuthToken.wrap((byte[])PAYLOAD_MESSAGE));
                        return;
                    }
                    crashType2bookieInstance.suspendProcessing();
                }
            };
        }
    }

    public static class CrashAfter3BookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        AtomicInteger numMessages = new AtomicInteger(0);

        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ServerConfiguration conf) {
        }

        public BookieAuthProvider newProvider(final BookieConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    if (numMessages.incrementAndGet() == 3) {
                        throw new RuntimeException("Do bad things to the bookie");
                    }
                    addr.setAuthorizedId(new BookKeeperPrincipal("test-principal"));
                    cb.operationComplete(0, (Object)AuthToken.wrap((byte[])PAYLOAD_MESSAGE));
                }
            };
        }
    }

    public static class FailAfter3BookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        AtomicInteger numMessages = new AtomicInteger(0);

        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ServerConfiguration conf) {
        }

        public BookieAuthProvider newProvider(final BookieConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    if (numMessages.incrementAndGet() == 3) {
                        addr.setAuthorizedId(new BookKeeperPrincipal("test-principal"));
                        cb.operationComplete(0, (Object)AuthToken.wrap((byte[])FAILURE_RESPONSE));
                        completeCb.operationComplete(-102, null);
                    } else {
                        cb.operationComplete(0, (Object)AuthToken.wrap((byte[])PAYLOAD_MESSAGE));
                    }
                }
            };
        }
    }

    public static class SucceedAfter3BookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        AtomicInteger numMessages = new AtomicInteger(0);

        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ServerConfiguration conf) {
        }

        public BookieAuthProvider newProvider(final BookieConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    if (numMessages.incrementAndGet() == 3) {
                        addr.setAuthorizedId(new BookKeeperPrincipal("test-principal"));
                        cb.operationComplete(0, (Object)AuthToken.wrap((byte[])SUCCESS_RESPONSE));
                        completeCb.operationComplete(0, null);
                    } else {
                        cb.operationComplete(0, (Object)AuthToken.wrap((byte[])PAYLOAD_MESSAGE));
                    }
                }
            };
        }
    }

    private static class SendUntilCompleteClientAuthProviderFactory
    implements ClientAuthProvider.Factory {
        private SendUntilCompleteClientAuthProviderFactory() {
        }

        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ClientConfiguration conf) {
        }

        public ClientAuthProvider newProvider(final ClientConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new ClientAuthProvider(){

                public void init(AuthCallbacks.GenericCallback<AuthToken> cb) {
                    cb.operationComplete(0, (Object)AuthToken.wrap((byte[])PAYLOAD_MESSAGE));
                }

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    byte[] type = m.getData();
                    if (Arrays.equals(type, SUCCESS_RESPONSE)) {
                        addr.setAuthorizedId(new BookKeeperPrincipal("test-client-principal"));
                        completeCb.operationComplete(0, null);
                    } else if (Arrays.equals(type, FAILURE_RESPONSE)) {
                        completeCb.operationComplete(-102, null);
                    } else {
                        cb.operationComplete(0, (Object)AuthToken.wrap((byte[])PAYLOAD_MESSAGE));
                    }
                }
            };
        }
    }

    private static class LogCloseCallsClientAuthProviderFactory
    implements ClientAuthProvider.Factory {
        private static AtomicInteger initCountersOnFactory = new AtomicInteger();
        private static AtomicInteger initCountersOnConnections = new AtomicInteger();
        private static AtomicInteger closeCountersOnFactory = new AtomicInteger();
        private static AtomicInteger closeCountersOnConnections = new AtomicInteger();

        private LogCloseCallsClientAuthProviderFactory() {
        }

        public void init(ClientConfiguration conf) throws IOException {
            initCountersOnFactory.incrementAndGet();
        }

        public ClientAuthProvider newProvider(ClientConnectionPeer connection, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new ClientAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                }

                public void close() {
                    closeCountersOnConnections.incrementAndGet();
                }

                public void init(AuthCallbacks.GenericCallback<AuthToken> cb) {
                    initCountersOnConnections.incrementAndGet();
                    completeCb.operationComplete(0, null);
                }
            };
        }

        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void close() {
            closeCountersOnFactory.incrementAndGet();
        }
    }

    public static class AlwaysFailBookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ServerConfiguration conf) {
        }

        public BookieAuthProvider newProvider(final BookieConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    addr.setAuthorizedId(new BookKeeperPrincipal("test-principal"));
                    cb.operationComplete(0, (Object)AuthToken.wrap((byte[])FAILURE_RESPONSE));
                    completeCb.operationComplete(-102, null);
                }
            };
        }
    }

    public static class DropConnectionBookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ServerConfiguration conf) {
        }

        public BookieAuthProvider newProvider(final BookieConnectionPeer addr, AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    addr.disconnect();
                }
            };
        }
    }

    private static class LogCloseCallsBookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        private static AtomicInteger closeCountersOnFactory = new AtomicInteger();
        private static AtomicInteger closeCountersOnConnections = new AtomicInteger();
        private static AtomicInteger initCountersOnFactory = new AtomicInteger();
        private static AtomicInteger initCountersOnConnections = new AtomicInteger();

        private LogCloseCallsBookieAuthProviderFactory() {
        }

        public void init(ServerConfiguration conf) throws IOException {
            initCountersOnFactory.incrementAndGet();
        }

        public void close() {
            closeCountersOnFactory.incrementAndGet();
        }

        public BookieAuthProvider newProvider(BookieConnectionPeer connection, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){
                {
                    completeCb.operationComplete(0, null);
                    initCountersOnConnections.incrementAndGet();
                }

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                }

                public void close() {
                    closeCountersOnConnections.incrementAndGet();
                }
            };
        }

        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }
    }

    public static class AlwaysSucceedBookieAuthProviderFactory
    implements BookieAuthProvider.Factory {
        public String getPluginName() {
            return TestAuth.TEST_AUTH_PROVIDER_PLUGIN_NAME;
        }

        public void init(ServerConfiguration conf) {
        }

        public BookieAuthProvider newProvider(final BookieConnectionPeer addr, final AuthCallbacks.GenericCallback<Void> completeCb) {
            return new BookieAuthProvider(){

                public void process(AuthToken m, AuthCallbacks.GenericCallback<AuthToken> cb) {
                    addr.setAuthorizedId(new BookKeeperPrincipal("test-principal"));
                    cb.operationComplete(0, (Object)AuthToken.wrap((byte[])SUCCESS_RESPONSE));
                    completeCb.operationComplete(0, null);
                }
            };
        }
    }

    static enum ProtocolVersion {
        ProtocolV2,
        ProtocolV3;

    }
}

