/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.InterleavedLedgerStorage;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerDirsMonitor;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.util.DiskChecker;
import org.apache.bookkeeper.util.TestUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class BookieStorageThresholdTest
extends BookKeeperClusterTestCase {
    private static final int NUM_BOOKIES = 1;
    private static final int NUM_ENTRIES = 100;
    private static final int ENTRY_SIZE = 1024;
    final String msg;
    BookKeeper.DigestType digestType = BookKeeper.DigestType.CRC32;

    public BookieStorageThresholdTest() {
        super(1);
        StringBuilder msgSB = new StringBuilder();
        for (int i = 0; i < 1024; ++i) {
            msgSB.append("a");
        }
        this.msg = msgSB.toString();
    }

    @Override
    @Before
    public void setUp() throws Exception {
        this.baseConf.setEntryLogSizeLimit(102400L);
        this.baseConf.setFlushInterval(500);
        this.baseConf.setGcWaitTime(60000L);
        this.baseConf.setMinorCompactionInterval(600000L);
        this.baseConf.setMajorCompactionInterval(700000L);
        this.baseConf.setEntryLogFilePreAllocationEnabled(false);
        this.baseConf.setLedgerStorageClass(InterleavedLedgerStorage.class.getName());
        this.baseConf.setIsForceGCAllowWhenNoSpace(true);
        this.baseConf.setDiskCheckInterval(3000);
        super.setUp();
    }

    LedgerHandle[] prepareData(int numEntryLogs) throws Exception {
        int num1 = 2;
        int num3 = 70;
        int num2 = 100 - num3 - num1;
        LedgerHandle[] lhs = new LedgerHandle[3];
        for (int i = 0; i < 3; ++i) {
            lhs[i] = this.bkc.createLedger(1, 1, this.digestType, "".getBytes());
        }
        for (int n = 0; n < numEntryLogs; ++n) {
            int k;
            for (k = 0; k < num1; ++k) {
                lhs[0].addEntry(this.msg.getBytes());
            }
            for (k = 0; k < num2; ++k) {
                lhs[1].addEntry(this.msg.getBytes());
            }
            for (k = 0; k < num3; ++k) {
                lhs[2].addEntry(this.msg.getBytes());
            }
        }
        return lhs;
    }

    @Test
    public void testStorageThresholdCompaction() throws Exception {
        LedgerDirsMonitor ledgerDirsMonitor;
        this.stopAllBookies();
        ServerConfiguration conf = this.newServerConfiguration();
        File ledgerDir1 = this.createTempDir("ledger", "test1");
        File ledgerDir2 = this.createTempDir("ledger", "test2");
        File journalDir = this.createTempDir("journal", "test");
        String[] ledgerDirNames = new String[]{ledgerDir1.getPath(), ledgerDir2.getPath()};
        conf.setLedgerDirNames(ledgerDirNames);
        conf.setJournalDirName(journalDir.getPath());
        BookieServer server = this.startBookie(conf);
        this.bs.add(server);
        this.bsConfs.add(conf);
        Bookie bookie = server.getBookie();
        bookie.ledgerMonitor.shutdown();
        LedgerDirsManager ledgerDirsManager = bookie.getLedgerDirsManager();
        final CountDownLatch diskWritable = new CountDownLatch(1);
        final CountDownLatch diskFull = new CountDownLatch(1);
        ledgerDirsManager.addLedgerDirsListener(new LedgerDirsManager.LedgerDirsListener(){

            public void diskWritable(File disk) {
                diskWritable.countDown();
            }

            public void diskFull(File disk) {
                diskFull.countDown();
            }
        });
        ThresholdTestDiskChecker thresholdTestDiskChecker = new ThresholdTestDiskChecker(this.baseConf.getDiskUsageThreshold(), this.baseConf.getDiskUsageWarnThreshold());
        bookie.ledgerMonitor = ledgerDirsMonitor = new LedgerDirsMonitor(this.baseConf, (DiskChecker)thresholdTestDiskChecker, ledgerDirsManager);
        bookie.idxMonitor = ledgerDirsMonitor;
        bookie.ledgerMonitor.init();
        bookie.ledgerMonitor.start();
        LedgerHandle[] lhs = this.prepareData(3);
        for (LedgerHandle lh : lhs) {
            lh.close();
        }
        this.bkc.deleteLedger(lhs[1].getId());
        this.bkc.deleteLedger(lhs[2].getId());
        Assert.assertTrue((String)"Disk Full shouldn't have been triggered yet", (diskFull.getCount() == 1L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Disk writable shouldn't have been triggered yet", (diskWritable.getCount() == 1L ? 1 : 0) != 0);
        thresholdTestDiskChecker.setInjectDiskOutOfSpaceException(true);
        diskFull.await(this.baseConf.getDiskCheckInterval() + 500, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"Disk Full should have been triggered", (diskFull.getCount() == 0L ? 1 : 0) != 0);
        Assert.assertTrue((String)"Disk writable shouldn't have been triggered yet", (diskWritable.getCount() == 1L ? 1 : 0) != 0);
        Thread.sleep(500L);
        Assert.assertTrue((String)"Bookie should be transitioned to ReadOnly", (boolean)bookie.isReadOnly());
        for (File ledgerDir : bookie.getLedgerDirsManager().getAllLedgerDirs()) {
            Assert.assertFalse((String)("Found entry log file ([0,1,2].log. They should have been compacted" + ledgerDir), (boolean)TestUtils.hasLogFiles(ledgerDir.getParentFile(), true, 0, 1, 2));
        }
        try {
            ledgerDirsManager.getWritableLedgerDirs();
            Assert.fail((String)"It is expected that there wont be any Writable LedgerDirs and getWritableLedgerDirs is supposed to throw NoWritableLedgerDirException");
        }
        catch (LedgerDirsManager.NoWritableLedgerDirException noWritableLedgerDirException) {
            // empty catch block
        }
        thresholdTestDiskChecker.setInjectDiskOutOfSpaceException(false);
        diskWritable.await(this.baseConf.getDiskCheckInterval() + 500, TimeUnit.MILLISECONDS);
        Assert.assertTrue((String)"Disk writable should have been triggered", (diskWritable.getCount() == 0L ? 1 : 0) != 0);
        Thread.sleep(500L);
        Assert.assertFalse((String)"Bookie should be transitioned to ReadWrite", (boolean)bookie.isReadOnly());
    }

    public class ThresholdTestDiskChecker
    extends DiskChecker {
        final AtomicBoolean injectDiskOutOfSpaceException;

        public ThresholdTestDiskChecker(float threshold, float warnThreshold) {
            super(threshold, warnThreshold);
            this.injectDiskOutOfSpaceException = new AtomicBoolean();
        }

        public void setInjectDiskOutOfSpaceException(boolean setValue) {
            this.injectDiskOutOfSpaceException.set(setValue);
        }

        public float checkDir(File dir) throws DiskChecker.DiskErrorException, DiskChecker.DiskOutOfSpaceException, DiskChecker.DiskWarnThresholdException {
            if (this.injectDiskOutOfSpaceException.get()) {
                throw new DiskChecker.DiskOutOfSpaceException("Injected DiskOutOfSpaceException", BookieStorageThresholdTest.this.baseConf.getDiskUsageThreshold() + 2.0f);
            }
            return super.checkDir(dir);
        }
    }
}

