/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.util.List;
import org.apache.bookkeeper.bookie.EntryLogger;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.util.DiskChecker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateNewLogTest {
    private static final Logger LOG = LoggerFactory.getLogger(CreateNewLogTest.class);
    private String[] ledgerDirs;
    private int numDirs = 100;

    @Before
    public void setUp() throws Exception {
        this.ledgerDirs = new String[this.numDirs];
        for (int i = 0; i < this.numDirs; ++i) {
            File temp = File.createTempFile("bookie", "test");
            temp.delete();
            temp.mkdir();
            File currentTemp = new File(temp.getAbsoluteFile() + "/current");
            currentTemp.mkdir();
            this.ledgerDirs[i] = temp.getPath();
        }
    }

    @After
    public void tearDown() throws Exception {
        for (int i = 0; i < this.numDirs; ++i) {
            File f = new File(this.ledgerDirs[i]);
            this.deleteRecursive(f);
        }
    }

    private void deleteRecursive(File f) {
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                this.deleteRecursive(c);
            }
        }
        f.delete();
    }

    @Test
    public void testCreateNewLog() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setLedgerDirNames(this.ledgerDirs);
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        String logFileName = Long.toHexString(1L) + ".log";
        File dir = ledgerDirsManager.pickRandomWritableDir();
        LOG.info("Picked this directory: " + dir);
        File newLogFile = new File(dir, logFileName);
        newLogFile.createNewFile();
        EntryLogger el = new EntryLogger(conf, ledgerDirsManager);
        el.createNewLog();
        LOG.info("This is the current log id: " + el.getCurrentLogId());
        Assert.assertTrue((String)"Wrong log id", (el.getCurrentLogId() > 1L ? 1 : 0) != 0);
    }

    @Test
    public void testCreateNewLogWithNoWritableLedgerDirs() throws Exception {
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setLedgerDirNames(this.ledgerDirs);
        conf.setIsForceGCAllowWhenNoSpace(true);
        LedgerDirsManager ledgerDirsManager = new LedgerDirsManager(conf, conf.getLedgerDirs(), new DiskChecker(conf.getDiskUsageThreshold(), conf.getDiskUsageWarnThreshold()));
        String logFileName = Long.toHexString(1L) + ".log";
        File dir = ledgerDirsManager.pickRandomWritableDir();
        LOG.info("Picked this directory: " + dir);
        File newLogFile = new File(dir, logFileName);
        newLogFile.createNewFile();
        List wDirs = ledgerDirsManager.getWritableLedgerDirs();
        for (File tdir : wDirs) {
            ledgerDirsManager.addToFilledDirs(tdir);
        }
        EntryLogger el = new EntryLogger(conf, ledgerDirsManager);
        el.createNewLog();
        LOG.info("This is the current log id: " + el.getCurrentLogId());
        Assert.assertTrue((String)"Wrong log id", (el.getCurrentLogId() > 1L ? 1 : 0) != 0);
    }
}

