/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import javax.security.auth.login.Configuration;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.apache.bookkeeper.zookeeper.ZooKeeperClient;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class EnableZkSecurityBasicTest
extends BookKeeperClusterTestCase {
    public EnableZkSecurityBasicTest() {
        super(0);
        this.baseClientConf.setZkEnableSecurity(true);
        this.baseConf.setZkEnableSecurity(true);
    }

    @BeforeClass
    public static void setupJAAS() throws IOException {
        System.setProperty("zookeeper.authProvider.1", "org.apache.zookeeper.server.auth.SASLAuthenticationProvider");
        File tmpJaasDir = new File("target").getAbsoluteFile();
        File tmpJaasFile = new File(tmpJaasDir, "jaas.conf");
        String jassFileContent = "Server {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       user_foo=\"bar\";\n};\n\nClient {\n       org.apache.zookeeper.server.auth.DigestLoginModule required\n       username=\"foo\"\n       password=\"bar\";\n};";
        Files.write(tmpJaasFile.toPath(), jassFileContent.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        System.setProperty("java.security.auth.login.config", tmpJaasFile.getAbsolutePath());
        Configuration.getConfiguration().refresh();
    }

    @AfterClass
    public static void cleanUpJAAS() {
        System.clearProperty("java.security.auth.login.config");
        Configuration.getConfiguration().refresh();
        System.clearProperty("zookeeper.authProvider.1");
    }

    @Test
    public void testCreateLedgerAddEntryOnSecureZooKeepeer() throws Exception {
        this.startNewBookie();
        ClientConfiguration conf = new ClientConfiguration();
        conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        conf.setZkTimeout(20000);
        conf.setZkEnableSecurity(true);
        try (BookKeeper bkc = new BookKeeper(conf);
             LedgerHandle lh = bkc.createLedger(1, 1, 1, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());){
            lh.addEntry("foo".getBytes(StandardCharsets.UTF_8));
        }
        this.checkAllAcls();
    }

    private void checkAllAcls() throws IOException, InterruptedException, KeeperException {
        ZooKeeperClient zk = ZooKeeperClient.newBuilder().connectString(this.zkUtil.getZooKeeperConnectString()).sessionTimeoutMs(20000).build();
        this.checkACls((ZooKeeper)zk, "/");
        zk.close();
    }

    private void checkACls(ZooKeeper zk, String path) throws KeeperException, InterruptedException {
        List children = zk.getChildren(path, null);
        for (String child : children) {
            if (child.equals("readonly")) continue;
            String fullPath = path.equals("/") ? path + child : path + "/" + child;
            List acls = zk.getACL(fullPath, new Stat());
            this.checkACls(zk, fullPath);
            if (fullPath.startsWith("/zookeeper") || fullPath.equals("/ledgers") || fullPath.equals("/ledgers/available")) continue;
            Assert.assertEquals((long)1L, (long)acls.size());
            Assert.assertEquals((long)31L, (long)((ACL)acls.get(0)).getPerms());
            Assert.assertEquals((long)31L, (long)((ACL)acls.get(0)).getPerms());
            Assert.assertEquals((String)("unexpected ACLS on " + fullPath + ": " + acls.get(0)), (Object)"foo", (Object)((ACL)acls.get(0)).getId().getId());
            Assert.assertEquals((String)("unexpected ACLS on " + fullPath + ": " + acls.get(0)), (Object)"sasl", (Object)((ACL)acls.get(0)).getId().getScheme());
        }
    }
}

