/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Random;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.CacheCallback;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.EntryKeyValue;
import org.apache.bookkeeper.bookie.EntryMemTable;
import org.apache.bookkeeper.bookie.LogMark;
import org.apache.bookkeeper.bookie.SkipListFlusher;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestEntryMemTable
implements CacheCallback,
SkipListFlusher,
CheckpointSource {
    private EntryMemTable memTable;
    private final Random random = new Random();
    private TestCheckPoint curCheckpoint = new TestCheckPoint(0L, 0L);

    public CheckpointSource.Checkpoint newCheckpoint() {
        return this.curCheckpoint;
    }

    public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
    }

    @Before
    public void setUp() throws Exception {
        this.memTable = new EntryMemTable(TestBKConfiguration.newServerConfiguration(), (CheckpointSource)this, (StatsLogger)NullStatsLogger.INSTANCE);
    }

    @Test
    public void testLogMark() throws IOException {
        LogMark mark = new LogMark();
        Assert.assertTrue((mark.compare(new LogMark()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((mark.compare(LogMark.MAX_VALUE) < 0 ? 1 : 0) != 0);
        mark.setLogMark(3L, 11L);
        byte[] data = new byte[16];
        ByteBuffer buf = ByteBuffer.wrap(data);
        mark.writeLogMark(buf);
        buf.flip();
        LogMark mark1 = new LogMark(9L, 13L);
        Assert.assertTrue((mark1.compare(mark) > 0 ? 1 : 0) != 0);
        mark1.readLogMark(buf);
        Assert.assertTrue((mark1.compare(mark) == 0 ? 1 : 0) != 0);
    }

    @Test
    public void testBasicOps() throws IOException {
        long ledgerId = 1L;
        long entryId = 1L;
        byte[] data = new byte[10];
        this.random.nextBytes(data);
        ByteBuffer buf = ByteBuffer.wrap(data);
        this.memTable.addEntry(ledgerId, entryId, buf, (CacheCallback)this);
        buf.rewind();
        EntryKeyValue kv = this.memTable.getEntry(ledgerId, entryId);
        Assert.assertTrue((kv.getLedgerId() == ledgerId ? 1 : 0) != 0);
        Assert.assertTrue((kv.getEntryId() == entryId ? 1 : 0) != 0);
        Assert.assertTrue((boolean)kv.getValueAsByteBuffer().nioBuffer().equals(buf));
        this.memTable.flush((SkipListFlusher)this);
    }

    public void onSizeLimitReached(CheckpointSource.Checkpoint cp) throws IOException {
    }

    public void process(long ledgerId, long entryId, ByteBuf entry) throws IOException {
    }

    @Test
    public void testScanAcrossSnapshot() throws IOException {
        byte[] data = new byte[10];
        ArrayList<EntryKeyValue> keyValues = new ArrayList<EntryKeyValue>();
        for (long entryId = 1L; entryId < 100L; ++entryId) {
            for (long ledgerId = 1L; ledgerId < 3L; ++ledgerId) {
                this.random.nextBytes(data);
                this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this);
                keyValues.add(this.memTable.getEntry(ledgerId, entryId));
                if (this.random.nextInt(16) != 0) continue;
                this.memTable.snapshot();
            }
        }
        for (EntryKeyValue kv : keyValues) {
            Assert.assertTrue((boolean)this.memTable.getEntry(kv.getLedgerId(), kv.getEntryId()).equals((Object)kv));
        }
        this.memTable.flush((SkipListFlusher)this, CheckpointSource.Checkpoint.MAX);
    }

    @Test
    public void testFlushLogMark() throws IOException {
        HashSet<EntryKeyValue> flushedKVs = new HashSet<EntryKeyValue>();
        KVFLusher flusher = new KVFLusher(flushedKVs);
        this.curCheckpoint.setCheckPoint(2L, 2L);
        byte[] data = new byte[10];
        long ledgerId = 100L;
        for (long entryId = 1L; entryId < 100L; ++entryId) {
            this.random.nextBytes(data);
            this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this);
        }
        Assert.assertNull((Object)this.memTable.snapshot((CheckpointSource.Checkpoint)new TestCheckPoint(1L, 1L)));
        Assert.assertNotNull((Object)this.memTable.snapshot((CheckpointSource.Checkpoint)new TestCheckPoint(3L, 3L)));
        Assert.assertTrue((0L < this.memTable.flush((SkipListFlusher)flusher) ? 1 : 0) != 0);
        Assert.assertTrue((0L == this.memTable.flush((SkipListFlusher)flusher) ? 1 : 0) != 0);
        this.curCheckpoint.setCheckPoint(4L, 4L);
        this.random.nextBytes(data);
        this.memTable.addEntry(ledgerId, 101L, ByteBuffer.wrap(data), (CacheCallback)this);
        Assert.assertTrue((0L == this.memTable.flush((SkipListFlusher)flusher) ? 1 : 0) != 0);
        Assert.assertTrue((0L == this.memTable.flush((SkipListFlusher)flusher, (CheckpointSource.Checkpoint)new TestCheckPoint(3L, 3L)) ? 1 : 0) != 0);
        Assert.assertTrue((0L < this.memTable.flush((SkipListFlusher)flusher, (CheckpointSource.Checkpoint)new TestCheckPoint(4L, 5L)) ? 1 : 0) != 0);
    }

    @Test
    public void testFlushSnapshot() throws IOException {
        HashSet<EntryKeyValue> keyValues = new HashSet<EntryKeyValue>();
        HashSet<EntryKeyValue> flushedKVs = new HashSet<EntryKeyValue>();
        KVFLusher flusher = new KVFLusher(flushedKVs);
        byte[] data = new byte[10];
        for (long entryId = 1L; entryId < 100L; ++entryId) {
            for (long ledgerId = 1L; ledgerId < 100L; ++ledgerId) {
                this.random.nextBytes(data);
                Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in mem-table!"), (this.memTable.addEntry(ledgerId, entryId, ByteBuffer.wrap(data), (CacheCallback)this) != 0L ? 1 : 0) != 0);
                Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in hash-set!"), (boolean)keyValues.add(this.memTable.getEntry(ledgerId, entryId)));
                if (this.random.nextInt(16) != 0 || null == this.memTable.snapshot() || this.random.nextInt(2) != 0) continue;
                this.memTable.flush((SkipListFlusher)flusher);
            }
        }
        this.memTable.flush((SkipListFlusher)flusher, CheckpointSource.Checkpoint.MAX);
        for (EntryKeyValue kv : keyValues) {
            Assert.assertTrue((String)("kv " + kv.toString() + " was not flushed!"), (boolean)flushedKVs.contains(kv));
        }
    }

    @Test
    public void testNoLedgerException() throws IOException {
        NoLedgerFLusher flusher = new NoLedgerFLusher();
        byte[] data = new byte[10];
        for (long entryId = 1L; entryId < 100L; ++entryId) {
            for (long ledgerId = 1L; ledgerId < 100L; ++ledgerId) {
                this.random.nextBytes(data);
                if (this.random.nextInt(16) != 0 || null == this.memTable.snapshot()) continue;
                this.memTable.flush((SkipListFlusher)flusher);
            }
        }
        this.memTable.flush((SkipListFlusher)flusher, CheckpointSource.Checkpoint.MAX);
    }

    private static class TestCheckPoint
    implements CheckpointSource.Checkpoint {
        LogMark mark;

        public TestCheckPoint(long fid, long fpos) {
            this.mark = new LogMark(fid, fpos);
        }

        private void setCheckPoint(long fid, long fpos) {
            this.mark.setLogMark(fid, fpos);
        }

        public int compareTo(CheckpointSource.Checkpoint o) {
            if (CheckpointSource.Checkpoint.MAX == o) {
                return -1;
            }
            return this.mark.compare(((TestCheckPoint)o).mark);
        }
    }

    private class NoLedgerFLusher
    implements SkipListFlusher {
        private NoLedgerFLusher() {
        }

        public void process(long ledgerId, long entryId, ByteBuf entry) throws IOException {
            throw new Bookie.NoLedgerException(ledgerId);
        }
    }

    private class KVFLusher
    implements SkipListFlusher {
        final HashSet<EntryKeyValue> keyValues;

        KVFLusher(HashSet<EntryKeyValue> keyValues) {
            this.keyValues = keyValues;
        }

        public void process(long ledgerId, long entryId, ByteBuf entry) throws IOException {
            Assert.assertTrue((String)(ledgerId + ":" + entryId + " is duplicate in store!"), (boolean)this.keyValues.add(new EntryKeyValue(ledgerId, entryId, entry.array())));
        }
    }
}

