/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie;

import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.LastAddConfirmedUpdateNotification;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.LedgerStorage;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.bookie.SyncThread;
import org.apache.bookkeeper.common.util.Watcher;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestSyncThread {
    private static final Logger LOG = LoggerFactory.getLogger(TestSyncThread.class);
    ExecutorService executor = null;

    @Before
    public void setupExecutor() {
        this.executor = Executors.newSingleThreadExecutor();
    }

    @After
    public void teardownExecutor() {
        if (this.executor != null) {
            this.executor.shutdownNow();
            this.executor = null;
        }
    }

    @Test
    public void testSyncThreadLongShutdown() throws Exception {
        int flushInterval = 100;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setFlushInterval(flushInterval);
        DummyCheckpointSource checkpointSource = new DummyCheckpointSource();
        LedgerDirsManager.LedgerDirsListener listener = new LedgerDirsManager.LedgerDirsListener(){};
        final CountDownLatch checkpointCalledLatch = new CountDownLatch(1);
        final CountDownLatch checkpointLatch = new CountDownLatch(1);
        final CountDownLatch flushCalledLatch = new CountDownLatch(1);
        final CountDownLatch flushLatch = new CountDownLatch(1);
        final AtomicBoolean failedSomewhere = new AtomicBoolean(false);
        DummyLedgerStorage storage = new DummyLedgerStorage(){

            @Override
            public void flush() throws IOException {
                flushCalledLatch.countDown();
                try {
                    flushLatch.await();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    LOG.error("Interrupted in flush thread", (Throwable)ie);
                    failedSomewhere.set(true);
                }
            }

            @Override
            public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
                checkpointCalledLatch.countDown();
                try {
                    checkpointLatch.await();
                }
                catch (InterruptedException ie) {
                    Thread.currentThread().interrupt();
                    LOG.error("Interrupted in checkpoint thread", (Throwable)ie);
                    failedSomewhere.set(true);
                }
            }
        };
        SyncThread t = new SyncThread(conf, listener, (LedgerStorage)storage, (CheckpointSource)checkpointSource);
        t.startCheckpoint(CheckpointSource.Checkpoint.MAX);
        Assert.assertTrue((String)"Checkpoint should have been called", (boolean)checkpointCalledLatch.await(10L, TimeUnit.SECONDS));
        Future<Boolean> done = this.executor.submit(() -> {
            try {
                t.shutdown();
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                LOG.error("Interrupted shutting down sync thread", (Throwable)ie);
                failedSomewhere.set(true);
                return false;
            }
            return true;
        });
        checkpointLatch.countDown();
        Assert.assertFalse((String)"Shutdown shouldn't have finished", (boolean)done.isDone());
        Assert.assertTrue((String)"Flush should have been called", (boolean)flushCalledLatch.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((String)"Shutdown shouldn't have finished", (boolean)done.isDone());
        flushLatch.countDown();
        Assert.assertTrue((String)"Shutdown should have finished successfully", (boolean)done.get(10L, TimeUnit.SECONDS));
        Assert.assertFalse((String)"Shouldn't have failed anywhere", (boolean)failedSomewhere.get());
    }

    @Test
    public void testSyncThreadSuspension() throws Exception {
        int i;
        int flushInterval = 100;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setFlushInterval(flushInterval);
        DummyCheckpointSource checkpointSource = new DummyCheckpointSource();
        LedgerDirsManager.LedgerDirsListener listener = new LedgerDirsManager.LedgerDirsListener(){};
        final AtomicInteger checkpointCount = new AtomicInteger(0);
        DummyLedgerStorage storage = new DummyLedgerStorage(){

            @Override
            public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
                checkpointCount.incrementAndGet();
            }
        };
        SyncThread t = new SyncThread(conf, listener, (LedgerStorage)storage, (CheckpointSource)checkpointSource);
        t.startCheckpoint(CheckpointSource.Checkpoint.MAX);
        while (checkpointCount.get() == 0) {
            Thread.sleep(flushInterval);
        }
        t.suspendSync();
        Thread.sleep(flushInterval);
        int count = checkpointCount.get();
        for (i = 0; i < 10; ++i) {
            t.startCheckpoint(CheckpointSource.Checkpoint.MAX);
            Assert.assertEquals((String)"Checkpoint count shouldn't change", (long)count, (long)checkpointCount.get());
        }
        t.resumeSync();
        i = 0;
        while (checkpointCount.get() == count) {
            Thread.sleep(flushInterval);
            if (++i <= 100) continue;
            Assert.fail((String)"Checkpointing never resumed");
        }
        t.shutdown();
    }

    @Test
    public void testSyncThreadShutdownOnError() throws Exception {
        int flushInterval = 100;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setFlushInterval(flushInterval);
        DummyCheckpointSource checkpointSource = new DummyCheckpointSource();
        final CountDownLatch fatalLatch = new CountDownLatch(1);
        LedgerDirsManager.LedgerDirsListener listener = new LedgerDirsManager.LedgerDirsListener(){

            public void fatalError() {
                fatalLatch.countDown();
            }
        };
        DummyLedgerStorage storage = new DummyLedgerStorage(){

            @Override
            public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
                throw new RuntimeException("Fatal error in sync thread");
            }
        };
        SyncThread t = new SyncThread(conf, listener, (LedgerStorage)storage, (CheckpointSource)checkpointSource);
        t.startCheckpoint(CheckpointSource.Checkpoint.MAX);
        Assert.assertTrue((String)"Should have called fatal error", (boolean)fatalLatch.await(10L, TimeUnit.SECONDS));
        t.shutdown();
    }

    @Test
    public void testSyncThreadDisksFull() throws Exception {
        int flushInterval = 100;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setFlushInterval(flushInterval);
        DummyCheckpointSource checkpointSource = new DummyCheckpointSource();
        final CountDownLatch diskFullLatch = new CountDownLatch(1);
        LedgerDirsManager.LedgerDirsListener listener = new LedgerDirsManager.LedgerDirsListener(){

            public void allDisksFull(boolean highPriorityWritesAllowed) {
                diskFullLatch.countDown();
            }
        };
        DummyLedgerStorage storage = new DummyLedgerStorage(){

            @Override
            public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
                throw new LedgerDirsManager.NoWritableLedgerDirException("Disk full error in sync thread");
            }
        };
        SyncThread t = new SyncThread(conf, listener, (LedgerStorage)storage, (CheckpointSource)checkpointSource);
        t.startCheckpoint(CheckpointSource.Checkpoint.MAX);
        Assert.assertTrue((String)"Should have disk full error", (boolean)diskFullLatch.await(10L, TimeUnit.SECONDS));
        t.shutdown();
    }

    private static class DummyLedgerStorage
    implements LedgerStorage {
        private DummyLedgerStorage() {
        }

        public void initialize(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger) throws IOException {
        }

        public void deleteLedger(long ledgerId) throws IOException {
        }

        public void start() {
        }

        public void shutdown() throws InterruptedException {
        }

        public boolean ledgerExists(long ledgerId) throws IOException {
            return true;
        }

        public boolean setFenced(long ledgerId) throws IOException {
            return true;
        }

        public boolean isFenced(long ledgerId) throws IOException {
            return false;
        }

        public void setMasterKey(long ledgerId, byte[] masterKey) throws IOException {
        }

        public byte[] readMasterKey(long ledgerId) throws IOException, BookieException {
            return new byte[0];
        }

        public long addEntry(ByteBuf entry) throws IOException {
            return 1L;
        }

        public ByteBuf getEntry(long ledgerId, long entryId) throws IOException {
            return null;
        }

        public long getLastAddConfirmed(long ledgerId) throws IOException {
            return 0L;
        }

        public void flush() throws IOException {
        }

        public void setExplicitlac(long ledgerId, ByteBuf lac) {
        }

        public ByteBuf getExplicitLac(long ledgerId) {
            return null;
        }

        public boolean waitForLastAddConfirmedUpdate(long ledgerId, long previousLAC, Watcher<LastAddConfirmedUpdateNotification> watcher) throws IOException {
            return false;
        }

        public void checkpoint(CheckpointSource.Checkpoint checkpoint) throws IOException {
        }

        public void registerLedgerDeletionListener(LedgerStorage.LedgerDeletionListener listener) {
        }
    }

    private static class DummyCheckpointSource
    implements CheckpointSource {
        private DummyCheckpointSource() {
        }

        public CheckpointSource.Checkpoint newCheckpoint() {
            return CheckpointSource.Checkpoint.MAX;
        }

        public void checkpointComplete(CheckpointSource.Checkpoint checkpoint, boolean compact) throws IOException {
        }
    }
}

