/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import org.apache.bookkeeper.bookie.storage.ldb.ArrayGroupSort;
import org.junit.Assert;
import org.junit.Test;

public class ArraySortGroupTest {
    @Test
    public void simple() {
        long[] data = new long[]{1L, 2L, 3L, 4L, 5L, 6L, 3L, 1L, 4L, 8L, 1L, 2L, 4L, 5L, 12L, 10L, 3L, 3L, 3L, 3L, 4L, 3L, 1L, 2L, 3L, 3L, 3L, 3L};
        long[] expectedSorted = new long[]{1L, 2L, 3L, 4L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 3L, 4L, 3L, 1L, 2L, 4L, 5L, 12L, 10L, 4L, 8L, 1L, 2L, 5L, 6L, 3L, 1L};
        ArrayGroupSort sorter = new ArrayGroupSort(2, 4);
        sorter.sort(data);
        Assert.assertArrayEquals((long[])expectedSorted, (long[])data);
    }

    @Test(expected=IllegalArgumentException.class)
    public void keySmallerThanTotalSize() {
        new ArrayGroupSort(3, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeKeySize() {
        new ArrayGroupSort(-1, 2);
    }

    @Test(expected=IllegalArgumentException.class)
    public void negativeTotalSize() {
        new ArrayGroupSort(1, -1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void arraySizeIsNotMultiple() {
        ArrayGroupSort sorter = new ArrayGroupSort(1, 3);
        sorter.sort(new long[]{1L, 2L, 3L, 4L});
    }

    @Test(expected=IllegalArgumentException.class)
    public void arraySizeIsShorterThanRequired() {
        ArrayGroupSort sorter = new ArrayGroupSort(1, 3);
        sorter.sort(new long[]{1L, 2L});
    }

    @Test
    public void emptyArray() {
        long[] data = new long[]{};
        long[] expectedSorted = new long[]{};
        ArrayGroupSort sorter = new ArrayGroupSort(2, 4);
        sorter.sort(data);
        Assert.assertArrayEquals((long[])expectedSorted, (long[])data);
    }

    @Test
    public void singleItem() {
        long[] data = new long[]{1L, 2L, 3L, 4L};
        long[] expectedSorted = new long[]{1L, 2L, 3L, 4L};
        ArrayGroupSort sorter = new ArrayGroupSort(2, 4);
        sorter.sort(data);
        Assert.assertArrayEquals((long[])expectedSorted, (long[])data);
    }

    @Test
    public void twoItems() {
        long[] data = new long[]{1L, 2L, 3L, 4L, 1L, 1L, 5L, 5L};
        long[] expectedSorted = new long[]{1L, 1L, 5L, 5L, 1L, 2L, 3L, 4L};
        ArrayGroupSort sorter = new ArrayGroupSort(2, 4);
        sorter.sort(data);
        Assert.assertArrayEquals((long[])expectedSorted, (long[])data);
    }

    @Test
    public void threeItems() {
        long[] data = new long[]{1L, 2L, 3L, 4L, 1L, 1L, 5L, 5L, 1L, 0L, 2L, 1L};
        long[] expectedSorted = new long[]{1L, 0L, 2L, 1L, 1L, 1L, 5L, 5L, 1L, 2L, 3L, 4L};
        ArrayGroupSort sorter = new ArrayGroupSort(2, 4);
        sorter.sort(data);
        Assert.assertArrayEquals((long[])expectedSorted, (long[])data);
    }
}

