/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.bookie.BookieException;
import org.apache.bookkeeper.bookie.CheckpointSource;
import org.apache.bookkeeper.bookie.Checkpointer;
import org.apache.bookkeeper.bookie.LedgerDirsManager;
import org.apache.bookkeeper.bookie.StateManager;
import org.apache.bookkeeper.bookie.storage.ldb.DbLedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.SingleDirectoryDbLedgerStorage;
import org.apache.bookkeeper.bookie.storage.ldb.WriteCache;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.conf.TestBKConfiguration;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.stats.StatsLogger;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class DbLedgerStorageWriteCacheTest {
    private DbLedgerStorage storage;
    private File tmpDir;

    @Before
    public void setup() throws Exception {
        this.tmpDir = File.createTempFile("bkTest", ".dir");
        this.tmpDir.delete();
        this.tmpDir.mkdir();
        File curDir = Bookie.getCurrentDirectory((File)this.tmpDir);
        Bookie.checkDirectoryStructure((File)curDir);
        int gcWaitTime = 1000;
        ServerConfiguration conf = TestBKConfiguration.newServerConfiguration();
        conf.setGcWaitTime((long)gcWaitTime);
        conf.setLedgerStorageClass(MockedDbLedgerStorage.class.getName());
        conf.setProperty("dbStorage_writeCacheMaxSizeMb", (Object)1);
        conf.setProperty("dbStorage_maxThrottleTimeMs", (Object)1000);
        conf.setLedgerDirNames(new String[]{this.tmpDir.toString()});
        Bookie bookie = new Bookie(conf);
        this.storage = (DbLedgerStorage)bookie.getLedgerStorage();
    }

    @After
    public void teardown() throws Exception {
        this.storage.shutdown();
        this.tmpDir.delete();
    }

    @Test
    public void writeCacheFull() throws Exception {
        ByteBuf entry;
        int i;
        this.storage.setMasterKey(4L, "key".getBytes());
        Assert.assertEquals((Object)false, (Object)this.storage.isFenced(4L));
        Assert.assertEquals((Object)true, (Object)this.storage.ledgerExists(4L));
        Assert.assertEquals((Object)"key", (Object)new String(this.storage.readMasterKey(4L)));
        for (i = 0; i < 5; ++i) {
            entry = Unpooled.buffer((int)102416);
            entry.writeLong(4L);
            entry.writeLong((long)i);
            entry.writeZero(102400);
            this.storage.addEntry(entry);
        }
        for (i = 0; i < 5; ++i) {
            entry = Unpooled.buffer((int)102416);
            entry.writeLong(4L);
            entry.writeLong((long)(5 + i));
            entry.writeZero(102400);
            this.storage.addEntry(entry);
        }
        ByteBuf entry2 = Unpooled.buffer((int)102416);
        entry2.writeLong(4L);
        entry2.writeLong(22L);
        entry2.writeZero(102400);
        try {
            this.storage.addEntry(entry2);
            Assert.fail((String)"Should have thrown exception");
        }
        catch (BookieException.OperationRejectedException operationRejectedException) {
            // empty catch block
        }
    }

    private static class MockedDbLedgerStorage
    extends DbLedgerStorage {
        private MockedDbLedgerStorage() {
        }

        protected SingleDirectoryDbLedgerStorage newSingleDirectoryDbLedgerStorage(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger, ScheduledExecutorService gcExecutor, long writeCacheSize, long readCacheSize) throws IOException {
            return new MockedSingleDirectoryDbLedgerStorage(conf, ledgerManager, ledgerDirsManager, indexDirsManager, stateManager, checkpointSource, checkpointer, statsLogger, gcExecutor, writeCacheSize, readCacheSize);
        }

        private static class MockedSingleDirectoryDbLedgerStorage
        extends SingleDirectoryDbLedgerStorage {
            public MockedSingleDirectoryDbLedgerStorage(ServerConfiguration conf, LedgerManager ledgerManager, LedgerDirsManager ledgerDirsManager, LedgerDirsManager indexDirsManager, StateManager stateManager, CheckpointSource checkpointSource, Checkpointer checkpointer, StatsLogger statsLogger, ScheduledExecutorService gcExecutor, long writeCacheSize, long readCacheSize) throws IOException {
                super(conf, ledgerManager, ledgerDirsManager, indexDirsManager, stateManager, checkpointSource, checkpointer, statsLogger, gcExecutor, writeCacheSize, readCacheSize);
            }

            public void flush() throws IOException {
                this.flushMutex.lock();
                try {
                    WriteCache tmp = this.writeCacheBeingFlushed;
                    this.writeCacheBeingFlushed = this.writeCache;
                    this.writeCache = tmp;
                    this.hasFlushBeenTriggered.set(false);
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        this.flushMutex.unlock();
                        return;
                    }
                }
                finally {
                    this.flushMutex.unlock();
                }
            }
        }
    }
}

