/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.bookie.storage.ldb;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import org.apache.bookkeeper.bookie.storage.ldb.ReadCache;
import org.junit.Assert;
import org.junit.Test;

public class ReadCacheTest {
    @Test
    public void simple() {
        int i;
        ReadCache cache = new ReadCache(10240L);
        Assert.assertEquals((long)0L, (long)cache.count());
        Assert.assertEquals((long)0L, (long)cache.size());
        ByteBuf entry = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        cache.put(1L, 0L, entry);
        Assert.assertEquals((long)1L, (long)cache.count());
        Assert.assertEquals((long)1024L, (long)cache.size());
        Assert.assertEquals((Object)entry, (Object)cache.get(1L, 0L));
        Assert.assertNull((Object)cache.get(1L, 1L));
        for (i = 1; i < 10; ++i) {
            cache.put(1L, (long)i, entry);
        }
        Assert.assertEquals((long)10L, (long)cache.count());
        Assert.assertEquals((long)10240L, (long)cache.size());
        cache.put(1L, 10L, entry);
        for (i = 0; i < 5; ++i) {
            Assert.assertNull((Object)cache.get(1L, (long)i));
        }
        for (i = 5; i < 11; ++i) {
            Assert.assertEquals((Object)entry, (Object)cache.get(1L, (long)i));
        }
        cache.close();
    }

    @Test
    public void emptyCache() {
        ReadCache cache = new ReadCache(10240L);
        Assert.assertEquals((long)0L, (long)cache.count());
        Assert.assertEquals((long)0L, (long)cache.size());
        Assert.assertEquals(null, (Object)cache.get(0L, 0L));
        cache.close();
    }

    @Test
    public void multipleSegments() {
        int i;
        ReadCache cache = new ReadCache(10240L, 2048);
        Assert.assertEquals((long)0L, (long)cache.count());
        Assert.assertEquals((long)0L, (long)cache.size());
        for (i = 0; i < 10; ++i) {
            ByteBuf entry = Unpooled.wrappedBuffer((byte[])new byte[1024]);
            entry.setInt(0, i);
            cache.put(1L, (long)i, entry);
        }
        for (i = 0; i < 10; ++i) {
            ByteBuf res = cache.get(1L, (long)i);
            Assert.assertEquals((long)1L, (long)res.refCnt());
            Assert.assertEquals((long)1024L, (long)res.readableBytes());
            Assert.assertEquals((long)i, (long)res.getInt(0));
        }
        Assert.assertEquals((long)10L, (long)cache.count());
        Assert.assertEquals((long)10240L, (long)cache.size());
        ByteBuf entry = Unpooled.wrappedBuffer((byte[])new byte[1024]);
        cache.put(2L, 0L, entry);
        Assert.assertEquals((long)9L, (long)cache.count());
        Assert.assertEquals((long)9216L, (long)cache.size());
        cache.close();
    }
}

