/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import java.io.IOException;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.bookkeeper.bookie.Bookie;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.conf.ServerConfiguration;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieServer;
import org.apache.bookkeeper.test.BookKeeperClusterTestCase;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BookKeeperDiskSpaceWeightedLedgerPlacementTest
extends BookKeeperClusterTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(BookKeeperDiskSpaceWeightedLedgerPlacementTest.class);
    private static final long MS_WEIGHT_UPDATE_TIMEOUT = 30000L;

    public BookKeeperDiskSpaceWeightedLedgerPlacementTest() {
        super(10);
    }

    private BookieServer restartBookie(BookKeeperCheckInfoReader client, ServerConfiguration conf, final long initialFreeDiskSpace, final long finalFreeDiskSpace, AtomicBoolean useFinal) throws Exception {
        final AtomicBoolean ready = useFinal == null ? new AtomicBoolean(false) : useFinal;
        Bookie bookieWithCustomFreeDiskSpace = new Bookie(conf){
            long startTime;
            {
                super(x0);
                this.startTime = System.currentTimeMillis();
            }

            public long getTotalFreeSpace() {
                if (this.startTime == 0L) {
                    this.startTime = System.currentTimeMillis();
                }
                if (!ready.get()) {
                    return initialFreeDiskSpace;
                }
                return finalFreeDiskSpace;
            }
        };
        this.bsConfs.add(conf);
        BookieServer server = this.startBookie(conf, bookieWithCustomFreeDiskSpace);
        this.bs.add(server);
        client.blockUntilBookieWeightIs(server.getLocalAddress(), Optional.of(initialFreeDiskSpace));
        if (useFinal == null) {
            ready.set(true);
        }
        return server;
    }

    private BookieServer replaceBookieWithCustomFreeDiskSpaceBookie(BookKeeperCheckInfoReader client, int bookieIdx, long freeDiskSpace) throws Exception {
        return this.replaceBookieWithCustomFreeDiskSpaceBookie(client, bookieIdx, freeDiskSpace, freeDiskSpace, null);
    }

    private BookieServer replaceBookieWithCustomFreeDiskSpaceBookie(BookKeeperCheckInfoReader client, BookieServer bookie, long freeDiskSpace) throws Exception {
        for (int i = 0; i < this.bs.size(); ++i) {
            if (!((BookieServer)this.bs.get(i)).getLocalAddress().equals((Object)bookie.getLocalAddress())) continue;
            return this.replaceBookieWithCustomFreeDiskSpaceBookie(client, i, freeDiskSpace);
        }
        return null;
    }

    private BookieServer replaceBookieWithCustomFreeDiskSpaceBookie(BookKeeperCheckInfoReader client, int bookieIdx, long initialFreeDiskSpace, long finalFreeDiskSpace, AtomicBoolean useFinal) throws Exception {
        BookieSocketAddress addr = ((BookieServer)this.bs.get(bookieIdx)).getLocalAddress();
        LOG.info("Killing bookie {}", (Object)addr);
        ServerConfiguration conf = this.killBookieAndWaitForZK(bookieIdx);
        client.blockUntilBookieWeightIs(addr, Optional.empty());
        return this.restartBookie(client, conf, initialFreeDiskSpace, finalFreeDiskSpace, useFinal);
    }

    public void testDiskSpaceWeightedBookieSelection() throws Exception {
        int i;
        long freeDiskSpace = 1000000L;
        int multiple = 3;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setDiskWeightBasedPlacementEnabled(true).setGetBookieInfoRetryIntervalSeconds(1, TimeUnit.SECONDS).setBookieMaxWeightMultipleForWeightBasedPlacement(multiple).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeperCheckInfoReader client = new BookKeeperCheckInfoReader(conf);
        for (int i2 = 0; i2 < this.numBookies; ++i2) {
            if (i2 < this.numBookies - 2) {
                this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, freeDiskSpace);
                continue;
            }
            this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, (long)multiple * freeDiskSpace);
        }
        HashMap<BookieSocketAddress, Integer> m = new HashMap<BookieSocketAddress, Integer>();
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        for (i = 0; i < 2000; ++i) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        client.close();
        for (i = 0; i < this.numBookies - 2; ++i) {
            double ratio1 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 2)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio1 - (double)multiple)), (Math.abs(ratio1 - (double)multiple) < 1.0 ? 1 : 0) != 0);
            double ratio2 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 1)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio2 - (double)multiple)), (Math.abs(ratio2 - (double)multiple) < 1.0 ? 1 : 0) != 0);
        }
    }

    public void testDiskSpaceWeightedBookieSelectionWithChangingWeights() throws Exception {
        int i;
        int i2;
        long freeDiskSpace = 1000000L;
        int multiple = 3;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setDiskWeightBasedPlacementEnabled(true).setGetBookieInfoRetryIntervalSeconds(1, TimeUnit.SECONDS).setBookieMaxWeightMultipleForWeightBasedPlacement(multiple).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeperCheckInfoReader client = new BookKeeperCheckInfoReader(conf);
        for (int i3 = 0; i3 < this.numBookies; ++i3) {
            if (i3 < this.numBookies - 2) {
                this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, freeDiskSpace);
                continue;
            }
            this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, (long)multiple * freeDiskSpace);
        }
        HashMap<BookieSocketAddress, Integer> m = new HashMap<BookieSocketAddress, Integer>();
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        for (i2 = 0; i2 < 2000; ++i2) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        for (i2 = 0; i2 < this.numBookies - 2; ++i2) {
            double ratio1 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 2)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i2)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio1 - (double)multiple)), (Math.abs(ratio1 - (double)multiple) < 1.0 ? 1 : 0) != 0);
            double ratio2 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 1)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i2)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio2 - (double)multiple)), (Math.abs(ratio2 - (double)multiple) < 1.0 ? 1 : 0) != 0);
        }
        BookieServer server1 = (BookieServer)this.bs.get(0);
        BookieServer server2 = (BookieServer)this.bs.get(1);
        BookieServer server3 = (BookieServer)this.bs.get(this.numBookies - 2);
        BookieServer server4 = (BookieServer)this.bs.get(this.numBookies - 1);
        server1 = this.replaceBookieWithCustomFreeDiskSpaceBookie(client, server1, (long)multiple * freeDiskSpace);
        server2 = this.replaceBookieWithCustomFreeDiskSpaceBookie(client, server2, (long)multiple * freeDiskSpace);
        server3 = this.replaceBookieWithCustomFreeDiskSpaceBookie(client, server3, freeDiskSpace);
        server4 = this.replaceBookieWithCustomFreeDiskSpaceBookie(client, server4, freeDiskSpace);
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        for (i = 0; i < 2000; ++i) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        for (i = 0; i < this.numBookies; ++i) {
            if (server1.getLocalAddress().equals((Object)((BookieServer)this.bs.get(i)).getLocalAddress()) || server2.getLocalAddress().equals((Object)((BookieServer)this.bs.get(i)).getLocalAddress())) continue;
            double ratio1 = (double)((Integer)m.get(server1.getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio1 - (double)multiple)), (Math.abs(ratio1 - (double)multiple) < 1.0 ? 1 : 0) != 0);
            double ratio2 = (double)((Integer)m.get(server2.getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio2 - (double)multiple)), (Math.abs(ratio2 - (double)multiple) < 1.0 ? 1 : 0) != 0);
        }
        client.close();
    }

    public void testDiskSpaceWeightedBookieSelectionWithBookiesDying() throws Exception {
        int i;
        long freeDiskSpace = 1000000L;
        int multiple = 3;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setDiskWeightBasedPlacementEnabled(true).setGetBookieInfoRetryIntervalSeconds(1, TimeUnit.SECONDS).setBookieMaxWeightMultipleForWeightBasedPlacement(multiple).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeperCheckInfoReader client = new BookKeeperCheckInfoReader(conf);
        for (int i2 = 0; i2 < this.numBookies; ++i2) {
            if (i2 < this.numBookies - 2) {
                this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, freeDiskSpace);
                continue;
            }
            this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, (long)multiple * freeDiskSpace);
        }
        HashMap<BookieSocketAddress, Integer> m = new HashMap<BookieSocketAddress, Integer>();
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        for (int i3 = 0; i3 < 2000; ++i3) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        double ratio1 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 2)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(0)).getLocalAddress())).intValue();
        Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio1 - (double)multiple)), (Math.abs(ratio1 - (double)multiple) < 1.0 ? 1 : 0) != 0);
        double ratio2 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 1)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(1)).getLocalAddress())).intValue();
        Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio2 - (double)multiple)), (Math.abs(ratio2 - (double)multiple) < 1.0 ? 1 : 0) != 0);
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        BookieServer server1 = (BookieServer)this.bs.get(this.numBookies - 2);
        BookieServer server2 = (BookieServer)this.bs.get(this.numBookies - 1);
        this.killBookieAndWaitForZK(this.numBookies - 1);
        this.killBookieAndWaitForZK(this.numBookies - 2);
        for (i = 0; i < 2000; ++i) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        for (i = 0; i < this.numBookies - 3; ++i) {
            double delta = Math.abs((double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue() - (double)((Integer)m.get(((BookieServer)this.bs.get(i + 1)).getLocalAddress())).intValue());
            delta = delta * 100.0 / (double)((Integer)m.get(((BookieServer)this.bs.get(i + 1)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + delta), (delta <= 30.0 ? 1 : 0) != 0);
        }
        Assert.assertTrue((String)("Weigheted placement is not honored" + m.get(server1.getLocalAddress())), ((Integer)m.get(server1.getLocalAddress()) == 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)("Weigheted placement is not honored" + m.get(server2.getLocalAddress())), ((Integer)m.get(server2.getLocalAddress()) == 0 ? 1 : 0) != 0);
        client.close();
    }

    public void testDiskSpaceWeightedBookieSelectionWithBookiesBeingAdded() throws Exception {
        int i;
        int i2;
        long freeDiskSpace = 1000000L;
        int multiple = 3;
        ClientConfiguration conf = new ClientConfiguration();
        conf.setDiskWeightBasedPlacementEnabled(true).setGetBookieInfoRetryIntervalSeconds(1, TimeUnit.SECONDS).setBookieMaxWeightMultipleForWeightBasedPlacement(multiple).setMetadataServiceUri(this.zkUtil.getMetadataServiceUri());
        BookKeeperCheckInfoReader client = new BookKeeperCheckInfoReader(conf);
        for (int i3 = 0; i3 < this.numBookies; ++i3) {
            this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, freeDiskSpace);
        }
        ServerConfiguration conf1 = this.killBookieAndWaitForZK(this.numBookies - 1);
        ServerConfiguration conf2 = this.killBookieAndWaitForZK(this.numBookies - 2);
        HashMap<BookieSocketAddress, Integer> m = new HashMap<BookieSocketAddress, Integer>();
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        for (i2 = 0; i2 < 2000; ++i2) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        for (i2 = 0; i2 < this.numBookies - 3; ++i2) {
            double delta = Math.abs((double)((Integer)m.get(((BookieServer)this.bs.get(i2)).getLocalAddress())).intValue() - (double)((Integer)m.get(((BookieServer)this.bs.get(i2 + 1)).getLocalAddress())).intValue());
            delta = delta * 100.0 / (double)((Integer)m.get(((BookieServer)this.bs.get(i2 + 1)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + delta), (delta <= 30.0 ? 1 : 0) != 0);
        }
        this.restartBookie(client, conf1, (long)multiple * freeDiskSpace, (long)multiple * freeDiskSpace, null);
        this.restartBookie(client, conf2, (long)multiple * freeDiskSpace, (long)multiple * freeDiskSpace, null);
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        for (i = 0; i < 2000; ++i) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        for (i = 0; i < this.numBookies - 2; ++i) {
            double ratio1 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 2)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio1 - (double)multiple)), (Math.abs(ratio1 - (double)multiple) < 1.0 ? 1 : 0) != 0);
            double ratio2 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 1)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio2 - (double)multiple)), (Math.abs(ratio2 - (double)multiple) < 1.0 ? 1 : 0) != 0);
        }
        client.close();
    }

    public void testDiskSpaceWeightedBookieSelectionWithPeriodicBookieInfoUpdate() throws Exception {
        int i;
        int i2;
        long freeDiskSpace = 1000000L;
        int multiple = 3;
        int updateIntervalSecs = 6;
        ClientConfiguration conf = new ClientConfiguration();
        ((ClientConfiguration)conf.setMetadataServiceUri(this.zkUtil.getMetadataServiceUri())).setDiskWeightBasedPlacementEnabled(true).setGetBookieInfoRetryIntervalSeconds(1, TimeUnit.SECONDS).setBookieMaxWeightMultipleForWeightBasedPlacement(multiple).setGetBookieInfoIntervalSeconds(updateIntervalSecs, TimeUnit.SECONDS);
        BookKeeperCheckInfoReader client = new BookKeeperCheckInfoReader(conf);
        AtomicBoolean useHigherValue = new AtomicBoolean(false);
        for (int i3 = 0; i3 < this.numBookies; ++i3) {
            if (i3 < this.numBookies - 2) {
                this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, freeDiskSpace);
                continue;
            }
            this.replaceBookieWithCustomFreeDiskSpaceBookie(client, 0, freeDiskSpace, (long)multiple * freeDiskSpace, useHigherValue);
        }
        HashMap<BookieSocketAddress, Integer> m = new HashMap<BookieSocketAddress, Integer>();
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        for (i2 = 0; i2 < 2000; ++i2) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        for (i2 = 0; i2 < this.numBookies - 1; ++i2) {
            double delta = Math.abs((double)((Integer)m.get(((BookieServer)this.bs.get(i2)).getLocalAddress())).intValue() - (double)((Integer)m.get(((BookieServer)this.bs.get(i2 + 1)).getLocalAddress())).intValue());
            delta = delta * 100.0 / (double)((Integer)m.get(((BookieServer)this.bs.get(i2 + 1)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + delta), (delta <= 30.0 ? 1 : 0) != 0);
        }
        useHigherValue.set(true);
        Thread.sleep(updateIntervalSecs * 1000);
        for (i2 = 0; i2 < this.numBookies; ++i2) {
            if (i2 < this.numBookies - 2) {
                client.blockUntilBookieWeightIs(((BookieServer)this.bs.get(i2)).getLocalAddress(), Optional.of(freeDiskSpace));
                continue;
            }
            client.blockUntilBookieWeightIs(((BookieServer)this.bs.get(i2)).getLocalAddress(), Optional.of(freeDiskSpace * (long)multiple));
        }
        for (BookieServer b : this.bs) {
            m.put(b.getLocalAddress(), 0);
        }
        for (i = 0; i < 2000; ++i) {
            LedgerHandle lh = client.createLedger(3, 3, BookKeeper.DigestType.CRC32, "testPasswd".getBytes());
            for (BookieSocketAddress b : lh.getLedgerMetadata().getEnsemble(0L)) {
                m.put(b, (Integer)m.get(b) + 1);
            }
        }
        for (i = 0; i < this.numBookies - 2; ++i) {
            double ratio1 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 2)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio1 - (double)multiple)), (Math.abs(ratio1 - (double)multiple) < 1.0 ? 1 : 0) != 0);
            double ratio2 = (double)((Integer)m.get(((BookieServer)this.bs.get(this.numBookies - 1)).getLocalAddress())).intValue() / (double)((Integer)m.get(((BookieServer)this.bs.get(i)).getLocalAddress())).intValue();
            Assert.assertTrue((String)("Weigheted placement is not honored: " + Math.abs(ratio2 - (double)multiple)), (Math.abs(ratio2 - (double)multiple) < 1.0 ? 1 : 0) != 0);
        }
        client.close();
    }

    class BookKeeperCheckInfoReader
    extends BookKeeper {
        BookKeeperCheckInfoReader(ClientConfiguration conf) throws BKException, IOException, InterruptedException {
            super(conf);
        }

        void blockUntilBookieWeightIs(BookieSocketAddress bookie, Optional<Long> target) throws InterruptedException {
            long startMsecs = System.currentTimeMillis();
            Optional freeDiskSpace = Optional.empty();
            while (System.currentTimeMillis() < startMsecs + 30000L) {
                freeDiskSpace = this.bookieInfoReader.getFreeDiskSpace(bookie);
                if (freeDiskSpace.equals(target)) {
                    return;
                }
                Thread.sleep(1000L);
            }
            Assert.fail((String)String.format("Server %s still has weight %s rather than %s", bookie.toString(), freeDiskSpace.toString(), target.toString()));
        }
    }
}

