/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.GeneralSecurityException;
import org.apache.bookkeeper.client.LedgerHandle;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.util.ByteBufList;

public class ClientUtil {
    public static ByteBuf generatePacket(long ledgerId, long entryId, long lastAddConfirmed, long length, byte[] data) throws GeneralSecurityException {
        return ClientUtil.generatePacket(ledgerId, entryId, lastAddConfirmed, length, data, 0, data.length);
    }

    public static ByteBuf generatePacket(long ledgerId, long entryId, long lastAddConfirmed, long length, byte[] data, int offset, int len) throws GeneralSecurityException {
        DigestManager dm = DigestManager.instantiate((long)ledgerId, (byte[])new byte[2], (DataFormats.LedgerMetadataFormat.DigestType)DataFormats.LedgerMetadataFormat.DigestType.CRC32);
        return ByteBufList.coalesce((ByteBufList)dm.computeDigestAndPackageForSending(entryId, lastAddConfirmed, length, Unpooled.wrappedBuffer((byte[])data, (int)offset, (int)len)));
    }

    public static boolean isLedgerOpen(LedgerHandle handle) {
        return !handle.metadata.isClosed();
    }
}

