/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Charsets;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.proto.DataFormats;
import org.junit.Assert;
import org.junit.Test;

public class LedgerMetadataTest {
    private static final String passwdStr = "testPasswd";
    private static final byte[] passwd = "testPasswd".getBytes(Charsets.UTF_8);

    @Test
    public void testGetters() {
        LedgerMetadata metadata = new LedgerMetadata(3, 2, 1, BookKeeper.DigestType.CRC32, passwd, Collections.emptyMap(), false);
        Assert.assertEquals((long)3L, (long)metadata.getEnsembleSize());
        Assert.assertEquals((long)2L, (long)metadata.getWriteQuorumSize());
        Assert.assertEquals((long)1L, (long)metadata.getAckQuorumSize());
        Assert.assertEquals((Object)DigestType.CRC32, (Object)metadata.getDigestType());
        Assert.assertEquals(Collections.emptyMap(), (Object)metadata.getCustomMetadata());
        Assert.assertEquals((long)-1L, (long)metadata.getCtime());
        Assert.assertEquals((long)-1L, (long)metadata.getLastEntryId());
        Assert.assertEquals((long)0L, (long)metadata.getLength());
        Assert.assertFalse((boolean)metadata.isClosed());
        Assert.assertTrue((boolean)metadata.getAllEnsembles().isEmpty());
        try {
            metadata.getEnsembleAt(99L);
            Assert.fail((String)"Should fail to retrieve ensemble if ensembles is empty");
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    @Test
    public void testStoreSystemtimeAsLedgerCtimeEnabled() throws Exception {
        LedgerMetadata lm = new LedgerMetadata(3, 3, 2, BookKeeper.DigestType.CRC32, passwd, Collections.emptyMap(), true);
        DataFormats.LedgerMetadataFormat format = lm.buildProtoFormat();
        Assert.assertTrue((boolean)format.hasCtime());
    }

    @Test
    public void testStoreSystemtimeAsLedgerCtimeDisabled() throws Exception {
        LedgerMetadata lm = new LedgerMetadata(3, 3, 2, BookKeeper.DigestType.CRC32, passwd, Collections.emptyMap(), false);
        DataFormats.LedgerMetadataFormat format = lm.buildProtoFormat();
        Assert.assertFalse((boolean)format.hasCtime());
    }

    @Test
    public void testIsConflictWithStoreSystemtimeAsLedgerCtimeDisabled() {
        LedgerMetadata lm1 = new LedgerMetadata(3, 3, 2, BookKeeper.DigestType.CRC32, passwd, Collections.emptyMap(), false);
        LedgerMetadata lm2 = new LedgerMetadata(lm1);
        lm1.setCtime(1L);
        lm2.setCtime(2L);
        Assert.assertFalse((boolean)lm1.isConflictWith(lm2));
    }

    @Test
    public void testIsConflictWithStoreSystemtimeAsLedgerCtimeEnabled() {
        LedgerMetadata lm1 = new LedgerMetadata(3, 3, 2, BookKeeper.DigestType.CRC32, passwd, Collections.emptyMap(), true);
        LedgerMetadata lm2 = new LedgerMetadata(lm1);
        lm1.setCtime(1L);
        lm2.setCtime(2L);
        Assert.assertTrue((boolean)lm1.isConflictWith(lm2));
    }

    @Test
    public void testIsConflictWithDifferentStoreSystemtimeAsLedgerCtimeFlags() {
        LedgerMetadata lm1 = new LedgerMetadata(3, 3, 2, BookKeeper.DigestType.CRC32, passwd, Collections.emptyMap(), true);
        LedgerMetadata lm2 = new LedgerMetadata(3, 3, 2, BookKeeper.DigestType.CRC32, passwd, Collections.emptyMap(), false);
        Assert.assertTrue((boolean)lm1.isConflictWith(lm2));
    }

    @Test
    public void testToString() {
        LedgerMetadata lm1 = new LedgerMetadata(3, 3, 2, BookKeeper.DigestType.CRC32, passwd, Collections.emptyMap(), true);
        Assert.assertTrue((String)"toString should contain 'password' field", (boolean)lm1.toString().contains("password"));
        Assert.assertTrue((String)"toString should contain password value", (boolean)lm1.toString().contains(passwdStr));
        Assert.assertFalse((String)"toSafeString should not contain 'password' field", (boolean)lm1.toSafeString().contains("password"));
        Assert.assertFalse((String)"toSafeString should not contain password value", (boolean)lm1.toSafeString().contains(passwdStr));
    }
}

