/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bookkeeper.client;

import com.google.common.base.Optional;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.bookkeeper.client.BKException;
import org.apache.bookkeeper.client.BookKeeper;
import org.apache.bookkeeper.client.BookieWatcher;
import org.apache.bookkeeper.client.LedgerCreateOp;
import org.apache.bookkeeper.client.LedgerDeleteOp;
import org.apache.bookkeeper.client.LedgerMetadata;
import org.apache.bookkeeper.client.LedgerOpenOp;
import org.apache.bookkeeper.client.api.DeleteBuilder;
import org.apache.bookkeeper.client.api.DigestType;
import org.apache.bookkeeper.client.api.OpenBuilder;
import org.apache.bookkeeper.common.util.OrderedExecutor;
import org.apache.bookkeeper.common.util.OrderedScheduler;
import org.apache.bookkeeper.conf.ClientConfiguration;
import org.apache.bookkeeper.feature.Feature;
import org.apache.bookkeeper.meta.LedgerIdGenerator;
import org.apache.bookkeeper.meta.LedgerManager;
import org.apache.bookkeeper.net.BookieSocketAddress;
import org.apache.bookkeeper.proto.BookieClient;
import org.apache.bookkeeper.proto.BookkeeperInternalCallbacks;
import org.apache.bookkeeper.proto.DataFormats;
import org.apache.bookkeeper.proto.checksum.DigestManager;
import org.apache.bookkeeper.stats.NullStatsLogger;
import org.apache.bookkeeper.util.ByteBufList;
import org.apache.bookkeeper.versioning.Version;
import org.junit.After;
import org.junit.Before;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MockBookKeeperTestCase {
    private static final Logger LOG = LoggerFactory.getLogger(MockBookKeeperTestCase.class);
    protected OrderedScheduler scheduler;
    protected OrderedExecutor executor;
    protected BookKeeper bk;
    protected BookieClient bookieClient;
    protected LedgerManager ledgerManager;
    protected LedgerIdGenerator ledgerIdGenerator;
    private BookieWatcher bookieWatcher;
    protected ConcurrentMap<Long, LedgerMetadata> mockLedgerMetadataRegistry;
    protected AtomicLong mockNextLedgerId;
    protected ConcurrentSkipListSet<Long> fencedLedgers;
    protected ConcurrentMap<Long, Map<BookieSocketAddress, Map<Long, MockEntry>>> mockLedgerData;
    List<BookieSocketAddress> failedBookies;
    Set<BookieSocketAddress> availableBookies;
    private int lastIndexForBK;

    private Map<BookieSocketAddress, Map<Long, MockEntry>> getMockLedgerContents(long ledgerId) {
        return this.mockLedgerData.computeIfAbsent(ledgerId, id -> new ConcurrentHashMap());
    }

    private Map<Long, MockEntry> getMockLedgerContentsInBookie(long ledgerId, BookieSocketAddress bookieSocketAddress) {
        return this.getMockLedgerContents(ledgerId).computeIfAbsent(bookieSocketAddress, addr -> new ConcurrentHashMap());
    }

    private MockEntry getMockLedgerEntry(long ledgerId, BookieSocketAddress bookieSocketAddress, long entryId) throws BKException {
        if (this.failedBookies.contains(bookieSocketAddress)) {
            throw BKException.create((int)-3);
        }
        return this.getMockLedgerContentsInBookie(ledgerId, bookieSocketAddress).get(entryId);
    }

    @Before
    public void setup() throws Exception {
        this.mockLedgerMetadataRegistry = new ConcurrentHashMap<Long, LedgerMetadata>();
        this.mockLedgerData = new ConcurrentHashMap<Long, Map<BookieSocketAddress, Map<Long, MockEntry>>>();
        this.mockNextLedgerId = new AtomicLong(1L);
        this.fencedLedgers = new ConcurrentSkipListSet();
        this.scheduler = (OrderedScheduler)OrderedScheduler.newSchedulerBuilder().numThreads(4).name("bk-test").build();
        this.executor = OrderedExecutor.newBuilder().build();
        this.bookieWatcher = (BookieWatcher)Mockito.mock(BookieWatcher.class);
        this.bookieClient = (BookieClient)Mockito.mock(BookieClient.class);
        this.ledgerManager = (LedgerManager)Mockito.mock(LedgerManager.class);
        this.ledgerIdGenerator = (LedgerIdGenerator)Mockito.mock(LedgerIdGenerator.class);
        this.bk = (BookKeeper)Mockito.mock(BookKeeper.class);
        NullStatsLogger nullStatsLogger = this.setupLoggers();
        this.failedBookies = new ArrayList<BookieSocketAddress>();
        this.availableBookies = new HashSet<BookieSocketAddress>();
        Mockito.when((Object)this.bk.getCloseLock()).thenReturn((Object)new ReentrantReadWriteLock());
        Mockito.when((Object)this.bk.isClosed()).thenReturn((Object)false);
        Mockito.when((Object)this.bk.getBookieWatcher()).thenReturn((Object)this.bookieWatcher);
        Mockito.when((Object)this.bk.getDisableEnsembleChangeFeature()).thenReturn(Mockito.mock(Feature.class));
        Mockito.when((Object)this.bk.getExplicitLacInterval()).thenReturn((Object)0);
        Mockito.when((Object)this.bk.getMainWorkerPool()).thenReturn((Object)this.executor);
        Mockito.when((Object)this.bk.getBookieClient()).thenReturn((Object)this.bookieClient);
        Mockito.when((Object)this.bk.getScheduler()).thenReturn((Object)this.scheduler);
        Mockito.when((Object)this.bk.getReadSpeculativeRequestPolicy()).thenReturn((Object)Optional.absent());
        this.mockBookKeeperGetConf(new ClientConfiguration());
        Mockito.when((Object)this.bk.getStatsLogger()).thenReturn((Object)nullStatsLogger);
        Mockito.when((Object)this.bk.getLedgerManager()).thenReturn((Object)this.ledgerManager);
        Mockito.when((Object)this.bk.getLedgerIdGenerator()).thenReturn((Object)this.ledgerIdGenerator);
        Mockito.when((Object)this.bk.getReturnRc(ArgumentMatchers.anyInt())).thenAnswer(invocationOnMock -> invocationOnMock.getArgument(0));
        this.setupLedgerIdGenerator();
        this.setupCreateLedgerMetadata();
        this.setupReadLedgerMetadata();
        this.setupWriteLedgerMetadata();
        this.setupRemoveLedgerMetadata();
        this.setupRegisterLedgerMetadataListener();
        this.setupBookieWatcherForNewEnsemble();
        this.setupBookieWatcherForEnsembleChange();
        this.setupBookieClientReadEntry();
        this.setupBookieClientAddEntry();
    }

    protected void mockBookKeeperGetConf(ClientConfiguration conf) {
        Mockito.when((Object)this.bk.getConf()).thenReturn((Object)conf);
    }

    protected NullStatsLogger setupLoggers() {
        NullStatsLogger nullStatsLogger = NullStatsLogger.INSTANCE;
        Mockito.when((Object)this.bk.getOpenOpLogger()).thenReturn((Object)nullStatsLogger.getOpStatsLogger("mock"));
        Mockito.when((Object)this.bk.getRecoverOpLogger()).thenReturn((Object)nullStatsLogger.getOpStatsLogger("mock"));
        Mockito.when((Object)this.bk.getAddOpLogger()).thenReturn((Object)nullStatsLogger.getOpStatsLogger("mock"));
        Mockito.when((Object)this.bk.getReadOpLogger()).thenReturn((Object)nullStatsLogger.getOpStatsLogger("mock"));
        Mockito.when((Object)this.bk.getDeleteOpLogger()).thenReturn((Object)nullStatsLogger.getOpStatsLogger("mock"));
        Mockito.when((Object)this.bk.getCreateOpLogger()).thenReturn((Object)nullStatsLogger.getOpStatsLogger("mock"));
        Mockito.when((Object)this.bk.getRecoverAddCountLogger()).thenReturn((Object)nullStatsLogger.getOpStatsLogger("mock"));
        Mockito.when((Object)this.bk.getRecoverReadCountLogger()).thenReturn((Object)nullStatsLogger.getOpStatsLogger("mock"));
        return nullStatsLogger;
    }

    private DigestManager getDigestType(long ledgerId) throws GeneralSecurityException {
        LedgerMetadata metadata = (LedgerMetadata)this.mockLedgerMetadataRegistry.get(ledgerId);
        return DigestManager.instantiate((long)ledgerId, (byte[])metadata.getPassword(), (DataFormats.LedgerMetadataFormat.DigestType)BookKeeper.DigestType.toProtoDigestType((BookKeeper.DigestType)BookKeeper.DigestType.fromApiDigestType((DigestType)metadata.getDigestType())));
    }

    @After
    public void tearDown() {
        this.scheduler.shutdown();
        this.executor.shutdown();
    }

    protected void setBookkeeperConfig(ClientConfiguration config) {
        Mockito.when((Object)this.bk.getConf()).thenReturn((Object)config);
    }

    protected LedgerCreateOp.CreateBuilderImpl newCreateLedgerOp() {
        return new LedgerCreateOp.CreateBuilderImpl(this.bk);
    }

    protected OpenBuilder newOpenLedgerOp() {
        return new LedgerOpenOp.OpenBuilderImpl(this.bk);
    }

    protected DeleteBuilder newDeleteLedgerOp() {
        return new LedgerDeleteOp.DeleteBuilderImpl(this.bk);
    }

    protected void closeBookkeeper() {
        Mockito.when((Object)this.bk.isClosed()).thenReturn((Object)true);
    }

    protected void killBookie(BookieSocketAddress killedBookieSocketAddress) {
        this.failedBookies.add(killedBookieSocketAddress);
        this.availableBookies.remove(killedBookieSocketAddress);
    }

    protected BookieSocketAddress startNewBookie() {
        BookieSocketAddress address = this.generateBookieSocketAddress(this.lastIndexForBK++);
        this.availableBookies.add(address);
        return address;
    }

    protected BookieSocketAddress generateBookieSocketAddress(int index) {
        return new BookieSocketAddress("localhost", 1111 + index);
    }

    protected ArrayList<BookieSocketAddress> generateNewEnsemble(int ensembleSize) {
        ArrayList<BookieSocketAddress> ensemble = new ArrayList<BookieSocketAddress>(ensembleSize);
        for (int i = 0; i < ensembleSize; ++i) {
            ensemble.add(this.generateBookieSocketAddress(i));
        }
        this.availableBookies.addAll(ensemble);
        this.lastIndexForBK = ensembleSize;
        return ensemble;
    }

    private void setupBookieWatcherForNewEnsemble() throws BKException.BKNotEnoughBookiesException {
        Mockito.when((Object)this.bookieWatcher.newEnsemble(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), (Map)ArgumentMatchers.any())).thenAnswer((Answer)new Answer<ArrayList<BookieSocketAddress>>(){

            public ArrayList<BookieSocketAddress> answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                int ensembleSize = (Integer)args[0];
                return MockBookKeeperTestCase.this.generateNewEnsemble(ensembleSize);
            }
        });
    }

    private void setupBookieWatcherForEnsembleChange() throws BKException.BKNotEnoughBookiesException {
        Mockito.when((Object)this.bookieWatcher.replaceBookie(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt(), ArgumentMatchers.anyMap(), ArgumentMatchers.anyList(), ArgumentMatchers.anyInt(), ArgumentMatchers.anySet())).thenAnswer((Answer)new Answer<BookieSocketAddress>(){

            public BookieSocketAddress answer(InvocationOnMock invocation) throws Throwable {
                Object[] args = invocation.getArguments();
                List existingBookies = (List)args[4];
                Set excludeBookies = (Set)args[6];
                excludeBookies.addAll(existingBookies);
                HashSet<BookieSocketAddress> remainBookies = new HashSet<BookieSocketAddress>(MockBookKeeperTestCase.this.availableBookies);
                remainBookies.removeAll(excludeBookies);
                if (remainBookies.iterator().hasNext()) {
                    return (BookieSocketAddress)remainBookies.iterator().next();
                }
                throw BKException.create((int)-6);
            }
        });
    }

    private void submit(Runnable operation) {
        try {
            this.scheduler.submit(operation);
        }
        catch (RejectedExecutionException rejected) {
            operation.run();
        }
    }

    protected void registerMockEntryForRead(long ledgerId, long entryId, BookieSocketAddress bookieSocketAddress, byte[] entryData, long lastAddConfirmed) {
        this.getMockLedgerContentsInBookie(ledgerId, bookieSocketAddress).put(entryId, new MockEntry(entryData, lastAddConfirmed));
    }

    protected void registerMockLedgerMetadata(long ledgerId, LedgerMetadata ledgerMetadata) {
        this.mockLedgerMetadataRegistry.put(ledgerId, ledgerMetadata);
    }

    protected void setNewGeneratedLedgerId(long ledgerId) {
        this.mockNextLedgerId.set(ledgerId);
        this.setupLedgerIdGenerator();
    }

    protected LedgerMetadata getLedgerMetadata(long ledgerId) {
        return (LedgerMetadata)this.mockLedgerMetadataRegistry.get(ledgerId);
    }

    private void setupReadLedgerMetadata() {
        ((LedgerManager)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Long ledgerId = (Long)args[0];
            this.executor.executeOrdered((Object)ledgerId, () -> {
                BookkeeperInternalCallbacks.GenericCallback cb = (BookkeeperInternalCallbacks.GenericCallback)args[1];
                LedgerMetadata ledgerMetadata = (LedgerMetadata)this.mockLedgerMetadataRegistry.get(ledgerId);
                if (ledgerMetadata == null) {
                    cb.operationComplete(-7, null);
                } else {
                    cb.operationComplete(0, (Object)new LedgerMetadata(ledgerMetadata));
                }
            });
            return null;
        }).when((Object)this.ledgerManager)).readLedgerMetadata(ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.GenericCallback)ArgumentMatchers.any());
    }

    private void setupRemoveLedgerMetadata() {
        ((LedgerManager)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Long ledgerId = (Long)args[0];
            this.executor.executeOrdered((Object)ledgerId, () -> {
                BookkeeperInternalCallbacks.GenericCallback cb = (BookkeeperInternalCallbacks.GenericCallback)args[2];
                if (this.mockLedgerMetadataRegistry.remove(ledgerId) != null) {
                    cb.operationComplete(0, null);
                } else {
                    cb.operationComplete(-7, null);
                }
            });
            return null;
        }).when((Object)this.ledgerManager)).removeLedgerMetadata(ArgumentMatchers.anyLong(), (Version)ArgumentMatchers.any(), (BookkeeperInternalCallbacks.GenericCallback)ArgumentMatchers.any());
    }

    private void setupRegisterLedgerMetadataListener() {
        ((LedgerManager)Mockito.doAnswer((Answer)new Answer<Void>(){

            public Void answer(InvocationOnMock invocation) throws Throwable {
                return null;
            }
        }).when((Object)this.ledgerManager)).registerLedgerMetadataListener(ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.LedgerMetadataListener)ArgumentMatchers.any());
    }

    private void setupLedgerIdGenerator() {
        ((LedgerIdGenerator)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            BookkeeperInternalCallbacks.GenericCallback cb = (BookkeeperInternalCallbacks.GenericCallback)args[0];
            cb.operationComplete(0, (Object)this.mockNextLedgerId.getAndIncrement());
            return null;
        }).when((Object)this.ledgerIdGenerator)).generateLedgerId((BookkeeperInternalCallbacks.GenericCallback)ArgumentMatchers.any());
    }

    private void setupCreateLedgerMetadata() {
        ((LedgerManager)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            BookkeeperInternalCallbacks.GenericCallback cb = (BookkeeperInternalCallbacks.GenericCallback)args[2];
            Long ledgerId = (Long)args[0];
            this.executor.executeOrdered((Object)ledgerId, () -> {
                LedgerMetadata ledgerMetadata = (LedgerMetadata)args[1];
                this.mockLedgerMetadataRegistry.put(ledgerId, new LedgerMetadata(ledgerMetadata));
                cb.operationComplete(0, null);
            });
            return null;
        }).when((Object)this.ledgerManager)).createLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any(), (BookkeeperInternalCallbacks.GenericCallback)ArgumentMatchers.any());
    }

    private void setupWriteLedgerMetadata() {
        ((LedgerManager)Mockito.doAnswer(invocation -> {
            Object[] args = invocation.getArguments();
            Long ledgerId = (Long)args[0];
            LedgerMetadata metadata = (LedgerMetadata)args[1];
            BookkeeperInternalCallbacks.GenericCallback cb = (BookkeeperInternalCallbacks.GenericCallback)args[2];
            this.executor.executeOrdered((Object)ledgerId, () -> {
                this.mockLedgerMetadataRegistry.put(ledgerId, new LedgerMetadata(metadata));
                cb.operationComplete(0, null);
            });
            return null;
        }).when((Object)this.ledgerManager)).writeLedgerMetadata(ArgumentMatchers.anyLong(), (LedgerMetadata)ArgumentMatchers.any(), (BookkeeperInternalCallbacks.GenericCallback)ArgumentMatchers.any());
    }

    protected void setupBookieClientReadEntry() {
        Answer answer = invokation -> {
            Object[] args = invokation.getArguments();
            BookieSocketAddress bookieSocketAddress = (BookieSocketAddress)args[0];
            long ledgerId = (Long)args[1];
            long entryId = (Long)args[2];
            BookkeeperInternalCallbacks.ReadEntryCallback callback = (BookkeeperInternalCallbacks.ReadEntryCallback)args[3];
            boolean fenced = ((Integer)args[5] & 1) == 1;
            this.executor.executeOrdered(ledgerId, () -> {
                DigestManager macManager = null;
                try {
                    macManager = this.getDigestType(ledgerId);
                }
                catch (GeneralSecurityException gse) {
                    LOG.error("Initialize macManager fail", (Throwable)gse);
                }
                MockEntry mockEntry = null;
                try {
                    mockEntry = this.getMockLedgerEntry(ledgerId, bookieSocketAddress, entryId);
                }
                catch (BKException bke) {
                    LOG.info("readEntryAndFenceLedger - occur BKException {}@{} at {}", new Object[]{entryId, ledgerId, bookieSocketAddress});
                    callback.readEntryComplete(bke.getCode(), ledgerId, entryId, null, args[5]);
                }
                if (fenced) {
                    this.fencedLedgers.add(ledgerId);
                }
                if (mockEntry != null) {
                    LOG.info("readEntry - found mock entry {}@{} at {}", new Object[]{entryId, ledgerId, bookieSocketAddress});
                    ByteBufList entry = macManager.computeDigestAndPackageForSending(entryId, mockEntry.lastAddConfirmed, (long)mockEntry.payload.length, Unpooled.wrappedBuffer((byte[])mockEntry.payload));
                    callback.readEntryComplete(0, ledgerId, entryId, ByteBufList.coalesce((ByteBufList)entry), args[4]);
                    entry.release();
                } else {
                    LOG.info("readEntry - no such mock entry {}@{} at {}", new Object[]{entryId, ledgerId, bookieSocketAddress});
                    callback.readEntryComplete(-13, ledgerId, entryId, null, args[4]);
                }
            });
            return null;
        };
        ((BookieClient)Mockito.doAnswer((Answer)answer).when((Object)this.bookieClient)).readEntry((BookieSocketAddress)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ReadEntryCallback.class), ArgumentMatchers.any(), ArgumentMatchers.anyInt());
        ((BookieClient)Mockito.doAnswer((Answer)answer).when((Object)this.bookieClient)).readEntry((BookieSocketAddress)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong(), (BookkeeperInternalCallbacks.ReadEntryCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.ReadEntryCallback.class), ArgumentMatchers.any(), ArgumentMatchers.anyInt(), (byte[])ArgumentMatchers.any());
    }

    private byte[] extractEntryPayload(long ledgerId, long entryId, ByteBufList toSend) throws BKException.BKDigestMatchException {
        ByteBuf toSendCopy = Unpooled.copiedBuffer((byte[])toSend.toArray());
        toSendCopy.resetReaderIndex();
        DigestManager macManager = null;
        try {
            macManager = this.getDigestType(ledgerId);
        }
        catch (GeneralSecurityException gse) {
            LOG.error("Initialize macManager fail", (Throwable)gse);
        }
        ByteBuf content = macManager.verifyDigestAndReturnData(entryId, toSendCopy);
        byte[] entry = new byte[content.readableBytes()];
        content.readBytes(entry);
        content.resetReaderIndex();
        content.release();
        return entry;
    }

    protected void setupBookieClientAddEntry() {
        ((BookieClient)Mockito.doAnswer(invokation -> {
            Object[] args = invokation.getArguments();
            BookkeeperInternalCallbacks.WriteCallback callback = (BookkeeperInternalCallbacks.WriteCallback)args[5];
            BookieSocketAddress bookieSocketAddress = (BookieSocketAddress)args[0];
            long ledgerId = (Long)args[1];
            long entryId = (Long)args[3];
            ByteBufList toSend = (ByteBufList)args[4];
            Object ctx = args[6];
            int options = (Integer)args[7];
            boolean isRecoveryAdd = ((short)options & 2) == 2;
            this.executor.executeOrdered(ledgerId, () -> {
                byte[] entry;
                try {
                    entry = this.extractEntryPayload(ledgerId, entryId, toSend);
                }
                catch (BKException.BKDigestMatchException e) {
                    callback.writeComplete(-5, ledgerId, entryId, bookieSocketAddress, ctx);
                    return;
                }
                boolean fenced = this.fencedLedgers.contains(ledgerId);
                if (fenced && !isRecoveryAdd) {
                    callback.writeComplete(-101, ledgerId, entryId, bookieSocketAddress, ctx);
                } else {
                    if (this.failedBookies.contains(bookieSocketAddress)) {
                        callback.writeComplete(-3, ledgerId, entryId, bookieSocketAddress, ctx);
                        return;
                    }
                    if (this.getMockLedgerContentsInBookie(ledgerId, bookieSocketAddress).isEmpty()) {
                        this.registerMockEntryForRead(ledgerId, -1L, bookieSocketAddress, new byte[0], -1L);
                    }
                    this.registerMockEntryForRead(ledgerId, entryId, bookieSocketAddress, entry, ledgerId);
                    callback.writeComplete(0, ledgerId, entryId, bookieSocketAddress, ctx);
                }
            });
            return null;
        }).when((Object)this.bookieClient)).addEntry((BookieSocketAddress)ArgumentMatchers.any(BookieSocketAddress.class), ArgumentMatchers.anyLong(), (byte[])ArgumentMatchers.any(byte[].class), ArgumentMatchers.anyLong(), (ByteBufList)ArgumentMatchers.any(ByteBufList.class), (BookkeeperInternalCallbacks.WriteCallback)ArgumentMatchers.any(BookkeeperInternalCallbacks.WriteCallback.class), ArgumentMatchers.any(), ArgumentMatchers.anyInt());
    }

    private static final class MockEntry {
        byte[] payload;
        long lastAddConfirmed;

        public MockEntry(byte[] payload, long lastAddConfirmed) {
            this.payload = payload;
            this.lastAddConfirmed = lastAddConfirmed;
        }
    }
}

